/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.om.InternalGroupPrincipal;
import org.apache.jetspeed.security.om.impl.InternalGroupPrincipalImpl;
import org.apache.jetspeed.security.spi.GroupSecurityHandler;
import org.apache.jetspeed.security.spi.SecurityAccess;

public class DefaultGroupSecurityHandler
implements GroupSecurityHandler {
    private SecurityAccess commonQueries = null;

    public DefaultGroupSecurityHandler(SecurityAccess commonQueries) {
        this.commonQueries = commonQueries;
    }

    public GroupPrincipal getGroupPrincipal(String groupFullPathName) {
        GroupPrincipalImpl groupPrincipal = null;
        InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(GroupPrincipalImpl.getFullPathFromPrincipalName(groupFullPathName));
        if (null != internalGroup) {
            groupPrincipal = new GroupPrincipalImpl(GroupPrincipalImpl.getPrincipalNameFromFullPath(internalGroup.getFullPath()), internalGroup.isEnabled(), internalGroup.isMappingOnly());
        }
        return groupPrincipal;
    }

    public void setGroupPrincipal(GroupPrincipal groupPrincipal) throws SecurityException {
        String fullPath = groupPrincipal.getFullPath();
        InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(fullPath);
        if (null == internalGroup) {
            internalGroup = new InternalGroupPrincipalImpl(fullPath);
            internalGroup.setEnabled(groupPrincipal.isEnabled());
            this.commonQueries.setInternalGroupPrincipal(internalGroup, false);
        } else if (!internalGroup.isMappingOnly() && internalGroup.isEnabled() != groupPrincipal.isEnabled()) {
            internalGroup.setEnabled(groupPrincipal.isEnabled());
            this.commonQueries.setInternalGroupPrincipal(internalGroup, false);
        }
    }

    public void removeGroupPrincipal(GroupPrincipal groupPrincipal) throws SecurityException {
        InternalGroupPrincipal internalGroup = this.commonQueries.getInternalGroupPrincipal(groupPrincipal.getFullPath());
        if (null != internalGroup) {
            this.commonQueries.removeInternalGroupPrincipal(internalGroup);
        }
    }

    public List getGroupPrincipals(String filter) {
        LinkedList<GroupPrincipalImpl> groupPrincipals = new LinkedList<GroupPrincipalImpl>();
        Iterator result = this.commonQueries.getInternalGroupPrincipals(filter);
        while (result.hasNext()) {
            InternalGroupPrincipal internalGroup = (InternalGroupPrincipal)result.next();
            String path = internalGroup.getFullPath();
            if (path == null) continue;
            groupPrincipals.add(new GroupPrincipalImpl(GroupPrincipalImpl.getPrincipalNameFromFullPath(internalGroup.getFullPath()), internalGroup.isEnabled(), internalGroup.isMappingOnly()));
        }
        return groupPrincipals;
    }
}

