/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Principal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.AuthenticationProviderProxy;
import org.apache.jetspeed.security.HierarchyResolver;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SecurityProvider;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.impl.PrincipalsSet;
import org.apache.jetspeed.security.impl.UserImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.spi.SecurityMappingHandler;
import org.apache.jetspeed.util.ArgUtil;

public class UserManagerImpl
implements UserManager {
    private static final Log log = LogFactory.getLog((Class)UserManagerImpl.class);
    private AuthenticationProviderProxy atnProviderProxy = null;
    private SecurityMappingHandler securityMappingHandler = null;
    private String anonymousUser = "guest";
    private User guest = null;
    private boolean rolesInheritableViaGroups = true;

    public UserManagerImpl(SecurityProvider securityProvider) {
        this.atnProviderProxy = securityProvider.getAuthenticationProviderProxy();
        this.securityMappingHandler = securityProvider.getSecurityMappingHandler();
    }

    public UserManagerImpl(SecurityProvider securityProvider, String anonymousUser) {
        this.atnProviderProxy = securityProvider.getAuthenticationProviderProxy();
        this.securityMappingHandler = securityProvider.getSecurityMappingHandler();
        if (anonymousUser != null) {
            this.anonymousUser = anonymousUser;
        }
    }

    public UserManagerImpl(SecurityProvider securityProvider, HierarchyResolver roleHierarchyResolver, HierarchyResolver groupHierarchyResolver) {
        securityProvider.getSecurityMappingHandler().setRoleHierarchyResolver(roleHierarchyResolver);
        securityProvider.getSecurityMappingHandler().setGroupHierarchyResolver(groupHierarchyResolver);
        this.atnProviderProxy = securityProvider.getAuthenticationProviderProxy();
        this.securityMappingHandler = securityProvider.getSecurityMappingHandler();
    }

    public UserManagerImpl(SecurityProvider securityProvider, HierarchyResolver roleHierarchyResolver, HierarchyResolver groupHierarchyResolver, String anonymousUser) {
        securityProvider.getSecurityMappingHandler().setRoleHierarchyResolver(roleHierarchyResolver);
        securityProvider.getSecurityMappingHandler().setGroupHierarchyResolver(groupHierarchyResolver);
        this.atnProviderProxy = securityProvider.getAuthenticationProviderProxy();
        this.securityMappingHandler = securityProvider.getSecurityMappingHandler();
        if (anonymousUser != null) {
            this.anonymousUser = anonymousUser;
        }
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public void setRolesInheritableViaGroups(boolean rolesInheritableViaGroups) {
        this.rolesInheritableViaGroups = rolesInheritableViaGroups;
    }

    public boolean authenticate(String username, String password) {
        ArgUtil.notNull((Object[])new Object[]{username, password}, (String[])new String[]{"username", "password"}, (String)"authenticate(java.lang.String, java.lang.String)");
        boolean authenticated = false;
        try {
            if (!this.getAnonymousUser().equals(username) && (authenticated = this.atnProviderProxy.authenticate(username, password)) && log.isDebugEnabled()) {
                log.debug((Object)("Authenticated user: " + username));
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return authenticated;
    }

    public void addUser(String username, String password) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"addUser(java.lang.String, java.lang.String)");
        this.createUser(username, password, this.atnProviderProxy.getDefaultAuthenticationProvider(), false);
    }

    public void addUser(String username, String password, String atnProviderName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"addUser(java.lang.String, java.lang.String)");
        this.createUser(username, password, atnProviderName, false);
    }

    public void importUser(String username, String password, boolean passThrough) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"addUser(java.lang.String, java.lang.String)");
        this.createUser(username, password, this.atnProviderProxy.getDefaultAuthenticationProvider(), passThrough);
    }

    public void importUser(String username, String password, String atnProviderName, boolean passThrough) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"addUser(java.lang.String, java.lang.String)");
        this.createUser(username, password, atnProviderName, passThrough);
    }

    protected void createUser(String username, String password, String atnProviderName, boolean raw) throws SecurityException {
        block14: {
            ArgUtil.notNull((Object[])new Object[]{username, atnProviderName}, (String[])new String[]{"username", "atnProviderName"}, (String)"addUser(java.lang.String, java.lang.String, java.lang.String)");
            if (this.userExists(username)) {
                throw new SecurityException(SecurityException.USER_ALREADY_EXISTS.create((Object)username));
            }
            UserPrincipalImpl userPrincipal = new UserPrincipalImpl(username);
            String fullPath = userPrincipal.getFullPath();
            Preferences preferences = Preferences.userRoot().node(fullPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added user preferences node: " + fullPath));
            }
            try {
                if (null == preferences || !preferences.absolutePath().equals(fullPath)) break block14;
                this.atnProviderProxy.addUserPrincipal((UserPrincipal)userPrincipal);
                if (password != null) {
                    try {
                        if (raw) {
                            this.atnProviderProxy.importPassword(username, password, atnProviderName);
                        } else {
                            this.atnProviderProxy.setPassword(username, null, password, atnProviderName);
                        }
                    }
                    catch (SecurityException se1) {
                        try {
                            this.atnProviderProxy.removeUserPrincipal((UserPrincipal)userPrincipal);
                        }
                        catch (SecurityException se2) {
                            log.error((Object)"Failed to rollback created user after its password turned out to be invalid", (Throwable)se2);
                        }
                        throw se1;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added user: " + fullPath));
                }
            }
            catch (SecurityException se) {
                log.error((Object)se.getMessage(), (Throwable)se);
                try {
                    preferences.removeNode();
                }
                catch (BackingStoreException bse) {
                    bse.printStackTrace();
                }
                throw se;
            }
        }
    }

    public void removeUser(String username) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"removeUser(java.lang.String)");
        if (this.getAnonymousUser().equals(username)) {
            throw new SecurityException(SecurityException.ANONYMOUS_USER_PROTECTED.create((Object)username));
        }
        UserPrincipalImpl userPrincipal = new UserPrincipalImpl(username);
        String fullPath = userPrincipal.getFullPath();
        this.atnProviderProxy.removeUserPrincipal((UserPrincipal)userPrincipal);
        Preferences preferences = Preferences.userRoot().node(fullPath);
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    public boolean userExists(String username) {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"userExists(java.lang.String)");
        return this.atnProviderProxy.getUserPrincipal(username) != null;
    }

    public User getUser(String username) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"getUser(java.lang.String)");
        if (this.guest != null && this.getAnonymousUser().equals(username)) {
            return this.guest;
        }
        PrincipalsSet principals = new PrincipalsSet();
        String fullPath = new UserPrincipalImpl(username).getFullPath();
        Principal userPrincipal = this.atnProviderProxy.getUserPrincipal(username);
        if (null == userPrincipal) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)username));
        }
        principals.add(userPrincipal);
        principals.addAll(this.securityMappingHandler.getRolePrincipals(username));
        Set groupPrincipals = this.securityMappingHandler.getGroupPrincipals(username);
        principals.addAll(groupPrincipals);
        if (this.rolesInheritableViaGroups) {
            Iterator it = groupPrincipals.iterator();
            while (it.hasNext()) {
                Principal groupPrincipal = (Principal)it.next();
                Set rolePrincipalsInGroup = this.securityMappingHandler.getRolePrincipalsInGroup(groupPrincipal.getName());
                principals.addAll(rolePrincipalsInGroup);
            }
        }
        Subject subject = null;
        subject = this.getAnonymousUser().equals(username) ? new Subject(true, principals, new HashSet(), new HashSet()) : new Subject(true, principals, this.atnProviderProxy.getPublicCredentials(username), this.atnProviderProxy.getPrivateCredentials(username));
        Preferences preferences = Preferences.userRoot().node(fullPath);
        UserImpl user = new UserImpl(subject, preferences);
        if (this.getAnonymousUser().equals(username)) {
            this.guest = user;
        }
        return user;
    }

    public Iterator getUsers(String filter) throws SecurityException {
        LinkedList<User> users = new LinkedList<User>();
        Iterator userPrincipals = this.atnProviderProxy.getUserPrincipals(filter).iterator();
        while (userPrincipals.hasNext()) {
            String username = ((Principal)userPrincipals.next()).getName();
            User user = this.getUser(username);
            users.add(user);
        }
        return users.iterator();
    }

    public Iterator getUserNames(String filter) throws SecurityException {
        LinkedList<String> usernames = new LinkedList<String>();
        Iterator userPrincipals = this.atnProviderProxy.getUserPrincipals(filter).iterator();
        while (userPrincipals.hasNext()) {
            usernames.add(((Principal)userPrincipals.next()).getName());
        }
        return usernames.iterator();
    }

    public Collection getUsersInRole(String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName}, (String[])new String[]{"roleFullPathName"}, (String)"getUsersInRole(java.lang.String)");
        ArrayList<User> users = new ArrayList<User>();
        Set userPrincipals = this.securityMappingHandler.getUserPrincipalsInRole(roleFullPathName);
        Iterator userPrincipalsIter = userPrincipals.iterator();
        while (userPrincipalsIter.hasNext()) {
            Principal userPrincipal = (Principal)userPrincipalsIter.next();
            users.add(this.getUser(userPrincipal.getName()));
        }
        return users;
    }

    public Collection getUsersInGroup(String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{groupFullPathName}, (String[])new String[]{"groupFullPathName"}, (String)"getUsersInGroup(java.lang.String)");
        ArrayList<User> users = new ArrayList<User>();
        Set userPrincipals = this.securityMappingHandler.getUserPrincipalsInGroup(groupFullPathName);
        Iterator userPrincipalsIter = userPrincipals.iterator();
        while (userPrincipalsIter.hasNext()) {
            Principal userPrincipal = (Principal)userPrincipalsIter.next();
            users.add(this.getUser(userPrincipal.getName()));
        }
        return users;
    }

    public void setPassword(String username, String oldPassword, String newPassword) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username, newPassword}, (String[])new String[]{"username", "newPassword"}, (String)"setPassword(java.lang.String, java.lang.String, java.lang.String)");
        if (this.getAnonymousUser().equals(username)) {
            throw new SecurityException(SecurityException.ANONYMOUS_USER_PROTECTED.create((Object)username));
        }
        this.atnProviderProxy.setPassword(username, oldPassword, newPassword);
    }

    public void setPasswordEnabled(String userName, boolean enabled) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{userName}, (String[])new String[]{"userName"}, (String)"setPasswordEnabled(java.lang.String, boolean)");
        if (this.getAnonymousUser().equals(userName)) {
            throw new SecurityException(SecurityException.ANONYMOUS_USER_PROTECTED.create((Object)userName));
        }
        this.atnProviderProxy.setPasswordEnabled(userName, enabled);
    }

    public void setPasswordUpdateRequired(String userName, boolean updateRequired) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{userName}, (String[])new String[]{"userName"}, (String)"setPasswordUpdateRequired(java.lang.String, boolean)");
        if (this.getAnonymousUser().equals(userName)) {
            throw new SecurityException(SecurityException.ANONYMOUS_USER_PROTECTED.create((Object)userName));
        }
        this.atnProviderProxy.setPasswordUpdateRequired(userName, updateRequired);
    }

    public void setUserEnabled(String userName, boolean enabled) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{userName}, (String[])new String[]{"userName"}, (String)"setUserEnabled(java.lang.String, boolean)");
        if (this.getAnonymousUser().equals(userName)) {
            throw new SecurityException(SecurityException.ANONYMOUS_USER_PROTECTED.create((Object)userName));
        }
        UserPrincipalImpl userPrincipal = (UserPrincipalImpl)((Object)this.atnProviderProxy.getUserPrincipal(userName));
        if (null == userPrincipal) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
        if (enabled != userPrincipal.isEnabled()) {
            userPrincipal.setEnabled(enabled);
            this.atnProviderProxy.updateUserPrincipal((UserPrincipal)userPrincipal);
        }
    }

    public void setPasswordExpiration(String userName, Date expirationDate) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{userName}, (String[])new String[]{"userName"}, (String)"setPasswordExpiration(java.lang.String, java.sql.Date)");
        if (this.getAnonymousUser().equals(userName)) {
            throw new SecurityException(SecurityException.ANONYMOUS_USER_PROTECTED.create((Object)userName));
        }
        this.atnProviderProxy.setPasswordExpiration(userName, expirationDate);
    }
}

