/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter.rules.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jetspeed.rewriter.rules.Attribute;
import org.apache.jetspeed.rewriter.rules.Rule;
import org.apache.jetspeed.rewriter.rules.Ruleset;
import org.apache.jetspeed.rewriter.rules.Tag;
import org.apache.jetspeed.rewriter.rules.impl.AttributeImpl;
import org.apache.jetspeed.rewriter.rules.impl.IdentifiedImpl;
import org.apache.jetspeed.rewriter.rules.impl.RuleImpl;
import org.apache.jetspeed.rewriter.rules.impl.TagImpl;

public class RulesetImpl
extends IdentifiedImpl
implements Ruleset {
    private Collection rules = new ArrayList();
    private Collection tags = new ArrayList();
    private Map ruleMap = new HashMap();
    private Map tagMap = new HashMap();
    private boolean removeComments = false;

    public Tag getTag(String tagId) {
        return (Tag)this.tagMap.get(tagId);
    }

    public Rule getRule(String ruleId) {
        return (Rule)this.ruleMap.get(ruleId);
    }

    public String toString() {
        Iterator it;
        StringBuffer buffer = new StringBuffer("Ruleset:" + this.id);
        if (this.rules.size() == 0) {
            buffer.append(", no rules defined, ");
        } else {
            buffer.append(", rules: ");
            it = this.rules.iterator();
            while (it.hasNext()) {
                RuleImpl rule = (RuleImpl)it.next();
                buffer.append(rule.toString());
                buffer.append(", ");
            }
        }
        if (this.tags.size() == 0) {
            buffer.append(" no tags defined.");
        } else {
            buffer.append("tags: ");
            it = this.tags.iterator();
            while (it.hasNext()) {
                TagImpl tag = (TagImpl)it.next();
                buffer.append(tag.toString());
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }

    public void sync() {
        this.ruleMap.clear();
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            this.ruleMap.put(rule.getId(), rule);
        }
        this.tagMap.clear();
        it = this.tags.iterator();
        while (it.hasNext()) {
            Tag tag = (Tag)it.next();
            this.tagMap.put(tag.getId(), tag);
            Iterator attributes = tag.getAttributes().iterator();
            while (attributes.hasNext()) {
                String ruleId;
                Rule rule;
                Attribute attribute = (Attribute)attributes.next();
                if (!(attribute instanceof AttributeImpl) || (rule = (Rule)this.ruleMap.get(ruleId = ((AttributeImpl)attribute).getRuleId())) == null) continue;
                attribute.setRule(rule);
            }
        }
    }

    public void setRules(Collection rules) {
        this.rules = rules;
    }

    public Collection getRules() {
        return this.rules;
    }

    public void setTags(Collection tags) {
        this.tags = tags;
    }

    public Collection getTags() {
        return this.tags;
    }

    public boolean getRemoveComments() {
        return this.removeComments;
    }

    public void setRemoveComments(boolean b) {
        this.removeComments = b;
    }
}

