/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter.html.neko;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.rewriter.ParserAdaptor;
import org.apache.jetspeed.rewriter.Rewriter;
import org.apache.jetspeed.rewriter.RewriterException;
import org.apache.jetspeed.rewriter.html.neko.CallbackElementRemover;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.Purifier;
import org.cyberneko.html.filters.Writer;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.SAXException;

public class NekoParserAdaptor
implements ParserAdaptor {
    protected static final Log log = LogFactory.getLog((Class)NekoParserAdaptor.class);

    public void parse(Rewriter rewriter, Reader reader) throws RewriterException {
        this.rewrite(rewriter, reader, null);
    }

    public void rewrite(Rewriter rewriter, Reader reader, java.io.Writer writer) throws RewriterException {
        SAXParser parser = new SAXParser();
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new Purifier(), new CallbackElementRemover(rewriter), writer != null ? new Writer(writer, null) : new DefaultFilter()};
        String filtersPropName = "http://cyberneko.org/html/properties/filters";
        try {
            parser.setProperty(filtersPropName, (Object)filters);
        }
        catch (SAXException e) {
            log.error((Object)(filtersPropName + " is, unexpectedly, no longer defined for the cyberneko HTML parser"), (Throwable)e);
            throw new RewriterException("cyberneko parser version not supported", e);
        }
        try {
            parser.parse(new XMLInputSource(null, null, null, reader, null));
        }
        catch (IOException e) {
            String msg = "cyberneko HTML parsing failure";
            log.error((Object)msg, (Throwable)e);
            throw new RewriterException(msg, e);
        }
    }
}

