/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter.html.neko;

import org.apache.jetspeed.rewriter.Rewriter;
import org.apache.jetspeed.rewriter.html.neko.XMLAttributesWrapper;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.cyberneko.html.filters.ElementRemover;

public class CallbackElementRemover
extends ElementRemover {
    private Rewriter rewriter;

    public CallbackElementRemover(Rewriter rewriter) {
        this.rewriter = rewriter;
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.rewriter.shouldRemoveComments()) {
            return;
        }
        super.comment(text, augs);
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations arg2) throws XNIException {
        this.processTag(element, attrs);
        super.emptyElement(element, attrs, arg2);
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations arg2) throws XNIException {
        this.processTag(element, attrs);
        super.startElement(element, attrs, arg2);
    }

    protected void processTag(QName element, XMLAttributes attrs) {
        String tag = element.rawname.toLowerCase();
        if (this.fRemovedElements.contains(tag)) {
            return;
        }
        if (this.rewriter.shouldStripTag(tag)) {
            this.removeElement(tag);
            return;
        }
        if (this.rewriter.shouldRemoveTag(tag)) {
            return;
        }
        this.rewriter.enterConvertTagEvent(tag, new XMLAttributesWrapper(attrs));
        this.acceptElement(tag, this.getAttributeNames(attrs));
    }

    protected String[] getAttributeNames(XMLAttributes attrs) {
        int length = attrs != null ? attrs.getLength() : 0;
        String[] names = length > 0 ? new String[length] : null;
        int limit = length;
        for (int i = 0; i < limit; ++i) {
            names[i] = attrs.getQName(i);
        }
        return names;
    }
}

