/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter;

import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.rewriter.MutableAttributes;
import org.apache.jetspeed.rewriter.ParserAdaptor;
import org.apache.jetspeed.rewriter.Rewriter;
import org.apache.jetspeed.rewriter.RewriterException;

public abstract class AbstractRewriter
implements Rewriter {
    protected static final Log log = LogFactory.getLog((Class)AbstractRewriter.class);
    private String baseUrl = null;
    private boolean useProxy = false;

    public void parse(ParserAdaptor adaptor, Reader reader) throws RewriterException {
        adaptor.parse(this, reader);
    }

    public void rewrite(ParserAdaptor adaptor, Reader reader, Writer writer) throws RewriterException {
        adaptor.rewrite(this, reader, writer);
    }

    public abstract String rewriteUrl(String var1, String var2, String var3);

    public void setBaseUrl(String base) {
        this.baseUrl = base;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getBaseRelativeUrl(String relativeUrl) {
        try {
            String baseUrl = this.getBaseUrl();
            if (baseUrl != null) {
                URL xlate = new URL(new URL(baseUrl), relativeUrl);
                return xlate.toString();
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to translate URL relative to base URL", (Throwable)e);
        }
        return relativeUrl;
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public boolean enterSimpleTagEvent(String tag, MutableAttributes attrs) {
        return true;
    }

    public String exitSimpleTagEvent(String tag, MutableAttributes attrs) {
        return null;
    }

    public boolean enterStartTagEvent(String tag, MutableAttributes attrs) {
        return true;
    }

    public String exitStartTagEvent(String tag, MutableAttributes attrs) {
        return null;
    }

    public boolean enterEndTagEvent(String tag) {
        return true;
    }

    public String exitEndTagEvent(String tag) {
        return null;
    }

    public boolean enterText(char[] values, int param) {
        return true;
    }

    public void enterConvertTagEvent(String tag, MutableAttributes attrs) {
    }
}

