/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.window.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.apache.commons.collections.list.TreeList;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.aggregator.RenderTrackable;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.PortletWindowID;
import org.apache.jetspeed.factory.PortletInstance;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.util.KeyValue;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletWindowImpl
implements PortletWindow,
PortletWindowID,
RenderTrackable {
    private static final long serialVersionUID = 6578938580906866201L;
    private String id;
    private ContentFragment fragment;
    private Map<String, Object> attributes;
    protected int timeoutCount = 0;
    protected long expiration = 0L;
    private PortletDefinition pd;
    private RequestContext requestContext;
    private PortletWindow.Action action;
    private PortletRequest portletRequest;
    private PortletResponseContext portletResponseContext;
    private PortletRequestContext portletRequestContext;
    private PortletResponse portletResponse;
    private PortletInstance portletInstance;
    private List<KeyValue<String, Element>> headElements;
    private boolean valid;

    public PortletWindowImpl(RequestContext requestContext, ContentFragment fragment) {
        this(requestContext, fragment, null);
    }

    public PortletWindowImpl(RequestContext requestContext, ContentFragment fragment, PortletDefinition pd) {
        this.requestContext = requestContext;
        this.id = fragment.getId();
        this.fragment = fragment;
        this.pd = pd;
        this.valid = pd != null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getWindowId() {
        return this.id;
    }

    public PortletWindowID getId() {
        return this;
    }

    public String getPortletEntityId() {
        return this.id;
    }

    public String toString() {
        return this.getStringId();
    }

    public String getStringId() {
        return this.id;
    }

    public PortletDefinition getPortletDefinition() {
        return this.pd;
    }

    public ContentFragment getFragment() {
        return this.fragment;
    }

    public boolean isInstantlyRendered() {
        return this.fragment.isInstantlyRendered();
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public PortletMode getPortletMode() {
        return this.valid ? this.requestContext.getPortalURL().getNavigationalState().getMode((PortletWindow)this) : PortletMode.VIEW;
    }

    public WindowState getWindowState() {
        return this.valid ? this.requestContext.getPortalURL().getNavigationalState().getState((PortletWindow)this) : WindowState.NORMAL;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    public Object getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is required");
        }
        if (value == null) {
            this.getAttributes().remove(name);
        } else {
            this.getAttributes().put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public int getRenderTimeoutCount() {
        return this.timeoutCount;
    }

    public synchronized void incrementRenderTimeoutCount() {
        ++this.timeoutCount;
    }

    public synchronized void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void success() {
        this.timeoutCount = 0;
    }

    public void setRenderTimeoutCount(int timeoutCount) {
        this.timeoutCount = timeoutCount;
    }

    public void setInvocationState(PortletWindow.Action action, PortletRequestContext portletRequestContext, PortletResponseContext portletResponseContext, PortletRequest portletRequest, PortletResponse portletResponse, PortletInstance portletInstance) {
        if (!this.valid) {
            throw new IllegalStateException("Invalid window " + this.getId() + " should not have been invoked");
        }
        this.action = action;
        this.portletRequest = portletRequest;
        this.portletResponseContext = portletResponseContext;
        this.portletRequestContext = portletRequestContext;
        this.portletResponse = portletResponse;
        this.portletInstance = portletInstance;
    }

    public void clearInvocationState() {
        this.action = null;
        this.portletRequest = null;
        this.portletResponseContext = null;
        this.portletRequestContext = null;
        this.portletResponse = null;
        this.portletInstance = null;
    }

    public PortletWindow.Action getAction() {
        return this.action;
    }

    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    public PortletResponseContext getPortletResponseContext() {
        return this.portletResponseContext;
    }

    public PortletRequestContext getPortletRequestContext() {
        return this.portletRequestContext;
    }

    public PortletResponse getPortletResponse() {
        return this.portletResponse;
    }

    public PortletInstance getPortletInstance() {
        return this.portletInstance;
    }

    public List<KeyValue<String, Element>> getHeadElements() {
        if (this.headElements == null) {
            this.headElements = new TreeList();
            PortletWindowImpl.aggregateHeadElements(this.getFragment(), this.headElements);
            PortletWindowImpl.mergeHeadElementsByHint(this.headElements);
        }
        return this.headElements;
    }

    private static void aggregateHeadElements(ContentFragment f, List<KeyValue<String, Element>> aggregatedHeadElements) {
        List contentHeadElements;
        PortletContent portletContent;
        List contentFragments = f.getContentFragments();
        if (contentFragments != null && !contentFragments.isEmpty()) {
            for (ContentFragment child : contentFragments) {
                if ("hidden".equals(f.getState())) continue;
                PortletWindowImpl.aggregateHeadElements(child, aggregatedHeadElements);
            }
        }
        if ((portletContent = f.getPortletContent()) != null && !(contentHeadElements = f.getPortletContent().getHeadElements()).isEmpty()) {
            int insertionIndex = 0;
            for (KeyValue kvPair : contentHeadElements) {
                int offset = aggregatedHeadElements.indexOf(kvPair);
                if (offset != -1) {
                    insertionIndex = offset + 1;
                    continue;
                }
                aggregatedHeadElements.add(insertionIndex++, (KeyValue<String, Element>)kvPair);
            }
        }
    }

    private static void mergeHeadElementsByHint(List<KeyValue<String, Element>> headElements) {
        HashMap<String, Element> firstElementByMergeHint = new HashMap<String, Element>();
        HashMap<String, Set<String>> mergedTextContents = new HashMap<String, Set<String>>();
        Iterator<KeyValue<String, Element>> it = headElements.iterator();
        while (it.hasNext()) {
            Set<String> textContentSet;
            KeyValue<String, Element> kvPair = it.next();
            Element element = (Element)kvPair.getValue();
            if (!element.hasAttribute("org.apache.portals.portal.page.head.element.contribution.merge.hint")) continue;
            String mergeHint = element.getAttribute("org.apache.portals.portal.page.head.element.contribution.merge.hint");
            String textContent = element.getTextContent();
            if (textContent != null) {
                textContent = textContent.trim();
            }
            if (firstElementByMergeHint.containsKey(mergeHint)) {
                if (textContent != null && !"".equals(textContent)) {
                    textContentSet = (Set)mergedTextContents.get(mergeHint);
                    textContentSet.add(textContent);
                }
                it.remove();
                continue;
            }
            firstElementByMergeHint.put(mergeHint, element);
            textContentSet = new TreeSet();
            mergedTextContents.put(mergeHint, textContentSet);
            if (textContent == null || "".equals(textContent)) continue;
            textContentSet.add(textContent);
        }
        for (Map.Entry entry : firstElementByMergeHint.entrySet()) {
            String mergeHint = (String)entry.getKey();
            Element firstElement = (Element)entry.getValue();
            Set textContentSet = (Set)mergedTextContents.get(mergeHint);
            firstElement.setTextContent(StringUtils.join((Collection)textContentSet, (String)"\r\n"));
        }
    }
}

