/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.UserAttribute;
import org.apache.jetspeed.om.portlet.UserAttributeRef;
import org.apache.jetspeed.om.portlet.impl.DescriptionImpl;
import org.apache.jetspeed.util.JetspeedLocale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAttributeRefImpl
implements UserAttributeRef {
    private long id;
    private String name;
    private String nameLink;
    private List<Description> descriptions;

    public UserAttributeRefImpl() {
    }

    public UserAttributeRefImpl(UserAttribute userAttribute) {
        this.name = userAttribute.getName();
        for (Description d : userAttribute.getDescriptions()) {
            this.addDescription(d.getLang()).setDescription(d.getDescription());
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameLink() {
        return this.nameLink;
    }

    public void setNameLink(String nameLink) {
        this.nameLink = nameLink;
    }

    public Description getDescription(Locale locale) {
        return (Description)JetspeedLocale.getBestLocalizedObject(this.getDescriptions(), (Locale)locale);
    }

    public List<Description> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<Description>();
        }
        return this.descriptions;
    }

    public Description addDescription(String lang) {
        DescriptionImpl d = new DescriptionImpl(this, lang);
        for (Description desc : this.getDescriptions()) {
            if (!desc.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.descriptions.add(d);
        return d;
    }
}

