/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.portlet.ContainerRuntimeOption;
import org.apache.jetspeed.om.portlet.CustomPortletMode;
import org.apache.jetspeed.om.portlet.CustomWindowState;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.EventDefinition;
import org.apache.jetspeed.om.portlet.Filter;
import org.apache.jetspeed.om.portlet.FilterMapping;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.JetspeedServiceReference;
import org.apache.jetspeed.om.portlet.Listener;
import org.apache.jetspeed.om.portlet.LocaleEncodingMapping;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.PublicRenderParameter;
import org.apache.jetspeed.om.portlet.SecurityConstraint;
import org.apache.jetspeed.om.portlet.SecurityRole;
import org.apache.jetspeed.om.portlet.UserAttribute;
import org.apache.jetspeed.om.portlet.UserAttributeRef;
import org.apache.jetspeed.om.portlet.impl.ContainerRuntimeOptionImpl;
import org.apache.jetspeed.om.portlet.impl.CustomPortletModeImpl;
import org.apache.jetspeed.om.portlet.impl.CustomWindowStateImpl;
import org.apache.jetspeed.om.portlet.impl.DescriptionImpl;
import org.apache.jetspeed.om.portlet.impl.DisplayNameImpl;
import org.apache.jetspeed.om.portlet.impl.EventDefinitionImpl;
import org.apache.jetspeed.om.portlet.impl.FilterImpl;
import org.apache.jetspeed.om.portlet.impl.FilterMappingImpl;
import org.apache.jetspeed.om.portlet.impl.JetspeedServiceReferenceImpl;
import org.apache.jetspeed.om.portlet.impl.ListenerImpl;
import org.apache.jetspeed.om.portlet.impl.LocaleEncodingMappingImpl;
import org.apache.jetspeed.om.portlet.impl.PortletApplicationMetadataImpl;
import org.apache.jetspeed.om.portlet.impl.PortletDefinitionImpl;
import org.apache.jetspeed.om.portlet.impl.PublicRenderParameterImpl;
import org.apache.jetspeed.om.portlet.impl.SecurityConstraintImpl;
import org.apache.jetspeed.om.portlet.impl.SecurityRoleImpl;
import org.apache.jetspeed.om.portlet.impl.UserAttributeImpl;
import org.apache.jetspeed.om.portlet.impl.UserAttributeRefImpl;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletApplicationDefinitionImpl
implements PortletApplication,
Serializable,
Support,
PersistenceBrokerAware {
    private static final long serialVersionUID = 1L;
    private int applicationType = 0;
    private String checksum = "0";
    private long checksumLong = -1L;
    private long revision;
    private String version;
    private String name;
    private String contextPath;
    private Collection<LocalizedField> metadataFields = null;
    private String resourceBundle;
    private String defaultNamespace;
    private String jetspeedSecurityConstraint;
    private List<Description> descriptions;
    private List<DisplayName> displayNames;
    private List<SecurityRole> roles;
    private List<PortletDefinition> portlets;
    private List<EventDefinition> eventDefinitions;
    private List<PublicRenderParameter> publicRenderParameters;
    private List<CustomPortletMode> customPortletModes;
    private List<CustomWindowState> customWindowStates;
    private List<UserAttribute> userAttributes;
    private List<SecurityConstraint> securityConstraints;
    private List<Filter> filters;
    private List<FilterMapping> filterMappings;
    private List<Listener> listeners;
    private List<ContainerRuntimeOption> containerRuntimeOptions;
    private List<UserAttributeRef> userAttributeRefs;
    private List<JetspeedServiceReference> services = new ArrayList<JetspeedServiceReference>();
    private List<LocaleEncodingMapping> localeEncodingMappingList;
    private transient Map<PortletMode, PortletMode> supportedCustomModes;
    private transient Map<WindowState, WindowState> supportedCustomStates;
    private transient Map<PortletMode, PortletMode> mappedCustomModes;
    private transient Map<WindowState, WindowState> mappedCustomStates;
    private transient List<PortletMode> supportedPortletModes;
    private transient List<WindowState> supportedWindowStates;
    private transient Map<Locale, String> localeEncodingMappings;
    private transient String localContextPath;
    private final String[] TRANSPORTS = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setApplicationType(int type) {
        this.applicationType = type;
    }

    public int getApplicationType() {
        return this.applicationType;
    }

    public long getChecksum() {
        if (this.checksumLong == -1L) {
            this.checksumLong = Long.parseLong(this.checksum);
        }
        return this.checksumLong;
    }

    public void setChecksum(long checksum) {
        this.checksumLong = checksum;
        this.checksum = Long.toString(checksum);
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        if (this.applicationType == 1 && this.localContextPath != null) {
            return this.localContextPath;
        }
        return this.contextPath;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getJetspeedSecurityConstraint() {
        return this.jetspeedSecurityConstraint;
    }

    public void setJetspeedSecurityConstraint(String constraint) {
        this.jetspeedSecurityConstraint = constraint;
    }

    public GenericMetadata getMetadata() {
        if (this.metadataFields == null) {
            this.metadataFields = new ArrayList<LocalizedField>();
        }
        PortletApplicationMetadataImpl metadata = new PortletApplicationMetadataImpl();
        metadata.setFields(this.metadataFields);
        return metadata;
    }

    public Description getDescription(Locale locale) {
        return (Description)JetspeedLocale.getBestLocalizedObject(this.getDescriptions(), (Locale)locale);
    }

    public List<Description> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<Description>();
        }
        return this.descriptions;
    }

    public Description addDescription(String lang) {
        DescriptionImpl d = new DescriptionImpl(this, lang);
        for (Description desc : this.getDescriptions()) {
            if (!desc.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.descriptions.add(d);
        return d;
    }

    public DisplayName getDisplayName(Locale locale) {
        return (DisplayName)JetspeedLocale.getBestLocalizedObject(this.getDisplayNames(), (Locale)locale);
    }

    public List<DisplayName> getDisplayNames() {
        if (this.displayNames == null) {
            this.displayNames = new ArrayList<DisplayName>();
        }
        return this.displayNames;
    }

    public DisplayName addDisplayName(String lang) {
        DisplayNameImpl d = new DisplayNameImpl(this, lang);
        for (DisplayName dn : this.getDisplayNames()) {
            if (!dn.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("DisplayName for language: " + d.getLocale() + " already defined");
        }
        this.displayNames.add(d);
        return d;
    }

    public List<SecurityRole> getSecurityRoles() {
        if (this.roles == null) {
            this.roles = new ArrayList<SecurityRole>();
        }
        return this.roles;
    }

    public SecurityRole addSecurityRole(String name) {
        for (SecurityRole role : this.getSecurityRoles()) {
            if (!role.getName().equals(name)) continue;
            throw new IllegalArgumentException("Security Role " + name + " already defined");
        }
        SecurityRoleImpl role = new SecurityRoleImpl();
        role.setName(name);
        this.roles.add(role);
        return role;
    }

    public PortletDefinition getPortlet(String portletName) {
        for (PortletDefinition pd : this.getPortlets()) {
            if (!pd.getPortletName().equals(portletName)) continue;
            return pd;
        }
        return null;
    }

    public List<PortletDefinition> getPortlets() {
        if (this.portlets == null) {
            this.portlets = new ArrayList<PortletDefinition>();
        }
        return this.portlets;
    }

    public PortletDefinition addPortlet(String name) {
        if (this.getPortlet(name) != null) {
            throw new IllegalArgumentException("Portlet with name: " + name + " already defined");
        }
        PortletDefinitionImpl portlet = new PortletDefinitionImpl();
        portlet.setPortletName(name);
        portlet.setApplication(this);
        this.getPortlets().add(portlet);
        return portlet;
    }

    public List<EventDefinition> getEventDefinitions() {
        if (this.eventDefinitions == null) {
            this.eventDefinitions = new ArrayList<EventDefinition>();
        }
        return this.eventDefinitions;
    }

    public EventDefinition addEventDefinition(String name) {
        QName qname = new QName(this.getDefaultNamespace(), name);
        return this.addEventDefinition(qname);
    }

    public EventDefinition addEventDefinition(QName qname) {
        List<EventDefinition> defs = this.getEventDefinitions();
        for (EventDefinition def : defs) {
            if (!def.getQName().equals(qname)) continue;
            return def;
        }
        EventDefinitionImpl ed = new EventDefinitionImpl(qname);
        this.getEventDefinitions().add(ed);
        return ed;
    }

    public PublicRenderParameter getPublicRenderParameter(String identifier) {
        for (PublicRenderParameter p : this.getPublicRenderParameters()) {
            if (!p.getIdentifier().equals(identifier)) continue;
            return p;
        }
        return null;
    }

    public List<PublicRenderParameter> getPublicRenderParameters() {
        if (this.publicRenderParameters == null) {
            this.publicRenderParameters = new ArrayList<PublicRenderParameter>();
        }
        return this.publicRenderParameters;
    }

    public PublicRenderParameter addPublicRenderParameter(String name, String identifier) {
        if (this.getPublicRenderParameter(identifier) != null) {
            throw new IllegalArgumentException("PublicRenderParameter with identifier: " + identifier + " already defined");
        }
        PublicRenderParameterImpl p = new PublicRenderParameterImpl(name, identifier);
        if (!this.containsPublicRenderParameter(p)) {
            this.getPublicRenderParameters().add(p);
        }
        return p;
    }

    public PublicRenderParameter addPublicRenderParameter(QName qname, String identifier) {
        if (this.getPublicRenderParameter(identifier) != null) {
            throw new IllegalArgumentException("PublicRenderParameter with identifier: " + identifier + " already defined");
        }
        PublicRenderParameterImpl p = new PublicRenderParameterImpl(qname);
        p.setIdentifier(identifier);
        if (!this.containsPublicRenderParameter(p)) {
            this.getPublicRenderParameters().add(p);
        }
        return p;
    }

    protected boolean containsPublicRenderParameter(PublicRenderParameter prp) {
        for (PublicRenderParameter p : this.publicRenderParameters) {
            if (!p.equals(prp)) continue;
            return true;
        }
        return false;
    }

    public CustomPortletMode getCustomPortletMode(String name) {
        for (CustomPortletMode cpm : this.getCustomPortletModes()) {
            if (!cpm.getPortletMode().equalsIgnoreCase(name)) continue;
            return cpm;
        }
        return null;
    }

    public PortletMode getCustomPortletMode(PortletMode mode) {
        if (JetspeedActions.getStandardPortletModes().contains(mode)) {
            return mode;
        }
        this.getSupportedPortletModes();
        return this.supportedCustomModes.get(mode);
    }

    public List<CustomPortletMode> getCustomPortletModes() {
        if (this.customPortletModes == null) {
            this.customPortletModes = new ArrayList<CustomPortletMode>();
        }
        return this.customPortletModes;
    }

    public CustomPortletMode addCustomPortletMode(String name) {
        if (this.getCustomPortletMode(name) != null) {
            throw new IllegalArgumentException("Custom PortletMode with mode name: " + name + " already defined");
        }
        this.supportedPortletModes = null;
        this.supportedCustomModes = null;
        this.mappedCustomModes = null;
        CustomPortletModeImpl cpm = new CustomPortletModeImpl();
        cpm.setPortletMode(name);
        this.getCustomPortletModes().add(cpm);
        return cpm;
    }

    public CustomWindowState getCustomWindowState(String name) {
        for (CustomWindowState cws : this.getCustomWindowStates()) {
            if (!cws.getWindowState().equalsIgnoreCase(name)) continue;
            return cws;
        }
        return null;
    }

    public WindowState getCustomWindowState(WindowState state) {
        if (JetspeedActions.getStandardWindowStates().contains(state)) {
            return state;
        }
        if (JetspeedActions.getExtendedWindowStates().contains(state)) {
            this.getSupportedWindowStates();
            return this.supportedCustomStates.get(state);
        }
        return null;
    }

    public List<CustomWindowState> getCustomWindowStates() {
        if (this.customWindowStates == null) {
            this.customWindowStates = new ArrayList<CustomWindowState>();
        }
        return this.customWindowStates;
    }

    public CustomWindowState addCustomWindowState(String name) {
        if (this.getCustomWindowState(name) != null) {
            throw new IllegalArgumentException("Custom WindowState with state name: " + name + " already defined");
        }
        this.supportedWindowStates = null;
        this.supportedCustomStates = null;
        this.mappedCustomStates = null;
        CustomWindowStateImpl cws = new CustomWindowStateImpl();
        cws.setWindowState(name);
        this.getCustomWindowStates().add(cws);
        return cws;
    }

    public List<PortletMode> getSupportedPortletModes() {
        if (this.supportedPortletModes == null) {
            ArrayList<PortletMode> list = new ArrayList<PortletMode>(JetspeedActions.getStandardPortletModes());
            this.supportedCustomModes = new HashMap<PortletMode, PortletMode>();
            this.mappedCustomModes = new HashMap<PortletMode, PortletMode>();
            for (CustomPortletMode customMode : this.getCustomPortletModes()) {
                if (list.contains(customMode.getCustomMode()) || customMode.isPortalManaged() && !JetspeedActions.getExtendedPortletModes().contains(customMode.getMappedMode())) continue;
                list.add(customMode.getCustomMode());
                this.supportedCustomModes.put(customMode.getMappedMode(), customMode.getCustomMode());
                this.mappedCustomModes.put(customMode.getCustomMode(), customMode.getMappedMode());
            }
            this.supportedPortletModes = Collections.unmodifiableList(list);
        }
        return this.supportedPortletModes;
    }

    public List<WindowState> getSupportedWindowStates() {
        if (this.supportedWindowStates == null) {
            ArrayList<WindowState> list = new ArrayList<WindowState>(JetspeedActions.getStandardWindowStates());
            this.supportedCustomStates = new HashMap<WindowState, WindowState>();
            this.mappedCustomStates = new HashMap<WindowState, WindowState>();
            for (CustomWindowState customState : this.getCustomWindowStates()) {
                if (list.contains(customState.getCustomState()) || !JetspeedActions.getExtendedWindowStates().contains(customState.getMappedState())) continue;
                list.add(customState.getCustomState());
                this.supportedCustomStates.put(customState.getMappedState(), customState.getCustomState());
                this.mappedCustomStates.put(customState.getCustomState(), customState.getMappedState());
            }
            this.supportedWindowStates = Collections.unmodifiableList(list);
        }
        return this.supportedWindowStates;
    }

    public PortletMode getMappedPortletMode(PortletMode mode) {
        if (JetspeedActions.getStandardPortletModes().contains(mode)) {
            return mode;
        }
        if (this.getSupportedPortletModes().contains(mode)) {
            return this.mappedCustomModes.get(mode);
        }
        return null;
    }

    public WindowState getMappedWindowState(WindowState state) {
        if (JetspeedActions.getStandardWindowStates().contains(state)) {
            return state;
        }
        if (this.getSupportedWindowStates().contains(state)) {
            return this.mappedCustomStates.get(state);
        }
        return null;
    }

    public UserAttribute getUserAttribute(String name) {
        for (UserAttribute ua : this.getUserAttributes()) {
            if (!ua.getName().equals(name)) continue;
            return ua;
        }
        return null;
    }

    public List<UserAttribute> getUserAttributes() {
        if (this.userAttributes == null) {
            this.userAttributes = new ArrayList<UserAttribute>();
        }
        return this.userAttributes;
    }

    public UserAttribute addUserAttribute(String name) {
        if (this.getUserAttribute(name) != null) {
            throw new IllegalArgumentException("User attribute with name: " + name + " already defined");
        }
        UserAttributeImpl ua = new UserAttributeImpl();
        ua.setName(name);
        this.getUserAttributes().add(ua);
        return ua;
    }

    public UserAttributeRef getUserAttributeRef(String name) {
        for (UserAttributeRef uar : this.getUserAttributeRefs()) {
            if (!uar.getName().equals(name)) continue;
            return uar;
        }
        return null;
    }

    public List<UserAttributeRef> getUserAttributeRefs() {
        if (this.userAttributeRefs == null) {
            this.userAttributeRefs = new ArrayList<UserAttributeRef>();
        }
        return this.userAttributeRefs;
    }

    public UserAttributeRef addUserAttributeRef(String name) {
        if (this.getUserAttributeRef(name) != null) {
            throw new IllegalArgumentException("User attribute reference with name: " + name + " already defined");
        }
        UserAttributeRefImpl uar = new UserAttributeRefImpl();
        uar.setName(name);
        this.getUserAttributeRefs().add(uar);
        return uar;
    }

    public List<SecurityConstraint> getSecurityConstraints() {
        if (this.securityConstraints == null) {
            this.securityConstraints = new ArrayList<SecurityConstraint>();
        }
        return this.securityConstraints;
    }

    public SecurityConstraint addSecurityConstraint(String transportGuarantee) {
        if (this.getSecurityConstraint(transportGuarantee) != null) {
            throw new IllegalArgumentException("Security Constraint with name: " + transportGuarantee + " already defined");
        }
        boolean isValid = false;
        for (String t : this.TRANSPORTS) {
            if (!transportGuarantee.equalsIgnoreCase(t)) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            throw new IllegalArgumentException("Security Constraint with name: " + transportGuarantee + " is not a valid transport name");
        }
        SecurityConstraintImpl sc = new SecurityConstraintImpl();
        sc.getUserDataConstraint().setTransportGuarantee(transportGuarantee);
        this.getSecurityConstraints().add(sc);
        return sc;
    }

    public SecurityConstraint getSecurityConstraint(String transport) {
        for (SecurityConstraint sc : this.getSecurityConstraints()) {
            if (!sc.getUserDataConstraint().getTransportGuarantee().equals(transport)) continue;
            return sc;
        }
        return null;
    }

    public Filter getFilter(String filterName) {
        for (Filter f : this.getFilters()) {
            if (!f.getFilterName().equals(filterName)) continue;
            return f;
        }
        return null;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        return this.filters;
    }

    public Filter addFilter(String filterName) {
        if (this.getFilter(filterName) != null) {
            throw new IllegalArgumentException("Filter with name: " + this.name + " already defined");
        }
        FilterImpl f = new FilterImpl();
        f.setFilterName(filterName);
        this.getFilters().add(f);
        return f;
    }

    public FilterMapping getFilterMapping(String filterName) {
        for (FilterMapping f : this.getFilterMappings()) {
            if (!f.getFilterName().equals(filterName)) continue;
            return f;
        }
        return null;
    }

    public List<FilterMapping> getFilterMappings() {
        if (this.filterMappings == null) {
            this.filterMappings = new ArrayList<FilterMapping>();
        }
        return this.filterMappings;
    }

    public FilterMapping addFilterMapping(String filterName) {
        if (this.getFilterMapping(filterName) != null) {
            throw new IllegalArgumentException("Filtermapping for filter: " + this.name + " already defined");
        }
        FilterMappingImpl fm = new FilterMappingImpl();
        fm.setFilterName(filterName);
        this.getFilterMappings().add(fm);
        return fm;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        return this.listeners;
    }

    public Listener addListener(String listenerClass) {
        for (Listener l : this.getListeners()) {
            if (!l.getListenerClass().equals(listenerClass)) continue;
            throw new IllegalArgumentException("Listener of class: " + listenerClass + " already defined");
        }
        ListenerImpl l = new ListenerImpl();
        l.setListenerClass(listenerClass);
        this.getListeners().add(l);
        return l;
    }

    public ContainerRuntimeOption getContainerRuntimeOption(String name) {
        for (ContainerRuntimeOption cro : this.getContainerRuntimeOptions()) {
            if (!cro.getName().equals(name)) continue;
            return cro;
        }
        return null;
    }

    public List<ContainerRuntimeOption> getContainerRuntimeOptions() {
        if (this.containerRuntimeOptions == null) {
            this.containerRuntimeOptions = new ArrayList<ContainerRuntimeOption>();
        }
        return this.containerRuntimeOptions;
    }

    public ContainerRuntimeOption addContainerRuntimeOption(String name) {
        if (this.getContainerRuntimeOption(name) != null) {
            throw new IllegalArgumentException("Container runtime option with name: " + name + " already defined");
        }
        ContainerRuntimeOptionImpl cro = new ContainerRuntimeOptionImpl(this, name);
        this.getContainerRuntimeOptions().add(cro);
        return cro;
    }

    public Map<Locale, String> getLocaleEncodingMappings() {
        if (this.localeEncodingMappings == null) {
            if (this.localeEncodingMappingList == null) {
                this.localeEncodingMappings = Collections.emptyMap();
            } else {
                HashMap<Locale, String> map = new HashMap<Locale, String>();
                for (LocaleEncodingMapping lem : this.localeEncodingMappingList) {
                    map.put(lem.getLocale(), lem.getEncoding());
                }
                this.localeEncodingMappings = Collections.unmodifiableMap(map);
            }
        }
        return this.localeEncodingMappings;
    }

    public void addLocaleEncodingMapping(Locale locale, String encoding) {
        if (this.localeEncodingMappingList == null) {
            this.localeEncodingMappingList = new ArrayList<LocaleEncodingMapping>();
        }
        this.localeEncodingMappingList.add(new LocaleEncodingMappingImpl(locale, encoding));
    }

    public List<JetspeedServiceReference> getJetspeedServices() {
        if (this.services == null) {
            this.services = new ArrayList<JetspeedServiceReference>();
        }
        return this.services;
    }

    public void addJetspeedServiceReference(String name) {
        for (JetspeedServiceReference ref : this.getJetspeedServices()) {
            if (!ref.getName().equals(name)) continue;
            throw new IllegalArgumentException("Jetspeed service: " + name + " already defined");
        }
        JetspeedServiceReferenceImpl ref = new JetspeedServiceReferenceImpl();
        ref.setName(name);
        this.getJetspeedServices().add(ref);
    }

    public boolean isLayoutApplication() {
        Collection c;
        return this.getMetadata() != null && (c = this.getMetadata().getFields("layout-app")) != null && !c.isEmpty();
    }

    public void postLoad(Object parameter) throws Exception {
        for (PortletDefinition pd : this.portlets) {
            ((Support)pd).postLoad((Object)this);
        }
    }

    public void afterDelete(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void beforeInsert(PersistenceBroker arg0) throws PersistenceBrokerException {
        ++this.revision;
    }

    public void beforeUpdate(PersistenceBroker arg0) throws PersistenceBrokerException {
        ++this.revision;
    }

    public String getLocalContextPath() {
        return this.localContextPath;
    }

    public void setLocalContextPath(String localContextPath) {
        this.localContextPath = localContextPath;
    }
}

