/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.util.Locale;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.util.HashCodeBuilder;

public class LocalizedFieldImpl
implements LocalizedField {
    protected String value;
    protected String name;
    protected Locale locale;

    public LocalizedFieldImpl() {
    }

    public LocalizedFieldImpl(Locale locale, String value) {
        this.locale = locale;
        this.value = value;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setLanguage(String language) {
        if (language != null) {
            String[] localeArray = language.split("[-|_]");
            String country = "";
            String variant = "";
            for (int i = 0; i < localeArray.length; ++i) {
                if (i == 0) {
                    language = localeArray[i];
                    continue;
                }
                if (i == 1) {
                    country = localeArray[i];
                    continue;
                }
                if (i != 2) continue;
                variant = localeArray[i];
            }
            this.locale = new Locale(language, country, variant);
        }
    }

    public String getLanguage() {
        if (this.locale != null) {
            return this.locale.toString();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Name: " + this.name + " Value: " + this.value + " Locale: " + this.locale;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof LocalizedFieldImpl && o != null) {
            LocalizedFieldImpl localField = (LocalizedFieldImpl)o;
            boolean bl = this.name == null ? localField.name == null : (result = this.name.equals(localField.name));
            boolean bl2 = result && (this.value == null ? localField.value == null : this.value.equals(localField.value)) ? true : (result = false);
            result = result && (this.locale == null ? localField.locale == null : this.locale.equals(localField.locale));
        }
        return result;
    }

    public int hashCode() {
        HashCodeBuilder hasher = new HashCodeBuilder(27, 101);
        hasher.append((Object)this.name).append((Object)this.value);
        if (this.locale != null) {
            hasher.append((Object)this.locale.getCountry()).append((Object)this.locale.getLanguage()).append((Object)this.locale.getVariant());
        }
        return hasher.toHashCode();
    }
}

