/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.EventDefinition;
import org.apache.jetspeed.om.portlet.impl.DescriptionImpl;
import org.apache.jetspeed.om.portlet.impl.EventAliasImpl;
import org.apache.jetspeed.util.JetspeedLocale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDefinitionImpl
implements EventDefinition,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String localPart;
    protected String prefix;
    protected String namespace;
    protected String valueType;
    protected List<EventAliasImpl> aliases;
    protected List<Description> descriptions;

    public EventDefinitionImpl() {
    }

    public EventDefinitionImpl(QName qname) {
        this.setQName(qname);
    }

    public Description getDescription(Locale locale) {
        return (Description)JetspeedLocale.getBestLocalizedObject(this.getDescriptions(), (Locale)locale);
    }

    public List<Description> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<Description>();
        }
        return this.descriptions;
    }

    public Description addDescription(String lang) {
        DescriptionImpl d = new DescriptionImpl(this, lang);
        for (Description desc : this.getDescriptions()) {
            if (!desc.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.descriptions.add(d);
        return d;
    }

    public QName getQName() {
        if (this.namespace == null) {
            return new QName(this.localPart);
        }
        if (this.prefix == null) {
            return new QName(this.namespace, this.localPart);
        }
        return new QName(this.namespace, this.localPart, this.prefix);
    }

    public void setQName(QName qname) {
        this.namespace = qname.getNamespaceURI();
        if (this.namespace != null && this.namespace.equals("")) {
            this.namespace = null;
        }
        this.prefix = qname.getPrefix();
        if (this.prefix != null && this.prefix.equals("")) {
            this.prefix = null;
        }
        this.localPart = qname.getLocalPart();
    }

    public String getName() {
        return this.localPart;
    }

    public void setName(String name) {
        this.localPart = name;
        this.prefix = null;
        this.namespace = null;
    }

    public List<QName> getAliases() {
        ArrayList<QName> result = new ArrayList<QName>();
        if (this.aliases != null) {
            for (EventAliasImpl qname : this.aliases) {
                result.add(qname.getQName());
            }
        }
        return result;
    }

    public void addAlias(QName alias) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<EventAliasImpl>();
        }
        if (!this.containsAlias(alias)) {
            this.aliases.add(new EventAliasImpl(alias));
        }
    }

    protected boolean containsAlias(QName qname) {
        EventAliasImpl alias = new EventAliasImpl(qname);
        for (EventAliasImpl p : this.aliases) {
            if (!((Object)p).equals(alias)) continue;
            return true;
        }
        return false;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String value) {
        this.valueType = value;
    }

    public QName getQualifiedName(String defaultnamespace) {
        return new QName(defaultnamespace, this.localPart);
    }

    public boolean equals(Object qname) {
        return this.toString().equals(qname.toString());
    }

    public String toString() {
        return (this.namespace == null ? "" : this.namespace + "//:") + (this.prefix == null ? "" : this.prefix + ":") + (this.localPart == null ? "" : this.localPart);
    }
}

