/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletregistry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.components.portletpreferences.PortletPreferencesProvider;
import org.apache.jetspeed.components.portletregistry.FailedToStorePortletDefinitionException;
import org.apache.jetspeed.components.portletregistry.PortletApplicationProxyImpl;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.PortletRegistryHelper;
import org.apache.jetspeed.components.portletregistry.RegistryApplicationCache;
import org.apache.jetspeed.components.portletregistry.RegistryCacheObjectWrapper;
import org.apache.jetspeed.components.portletregistry.RegistryEventListener;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.components.portletregistry.RegistryPortletCache;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.portlet.ContainerRuntimeOption;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.EventDefinitionReference;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Preference;
import org.apache.jetspeed.om.portlet.SecurityRoleRef;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.om.portlet.impl.PortletApplicationDefinitionImpl;
import org.apache.jetspeed.om.portlet.impl.PortletDefinitionImpl;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceBrokerPortletRegistry
extends InitablePersistenceBrokerDaoSupport
implements PortletRegistry,
JetspeedCacheEventListener {
    static final String PORTLET_UNIQUE_NAME_SEPARATOR = "::";
    private JetspeedCache applicationOidCache = null;
    private JetspeedCache portletOidCache = null;
    private JetspeedCache applicationNameCache = null;
    private JetspeedCache portletNameCache = null;
    private List<RegistryEventListener> listeners = new ArrayList<RegistryEventListener>();
    private PortletPreferencesProvider preferenceService;

    public PersistenceBrokerPortletRegistry(String repositoryPath, PortletPreferencesProvider preferenceService) {
        this(repositoryPath, null, null, null, null, preferenceService);
    }

    public PersistenceBrokerPortletRegistry(String repositoryPath, JetspeedCache applicationOidCache, JetspeedCache portletOidCache, JetspeedCache applicationNameCache, JetspeedCache portletNameCache, PortletPreferencesProvider preferenceService) {
        super(repositoryPath);
        this.applicationOidCache = applicationOidCache;
        this.portletOidCache = portletOidCache;
        this.applicationNameCache = applicationNameCache;
        this.portletNameCache = portletNameCache;
        PortletApplicationProxyImpl.setRegistry(this);
        RegistryApplicationCache.cacheInit(this, applicationOidCache, applicationNameCache, this.listeners);
        RegistryPortletCache.cacheInit(this, portletOidCache, portletNameCache, this.listeners);
        this.applicationNameCache.addEventListener((JetspeedCacheEventListener)this, false);
        this.portletNameCache.addEventListener((JetspeedCacheEventListener)this, false);
        this.preferenceService = preferenceService;
    }

    public Collection<PortletDefinition> getAllPortletDefinitions() {
        Criteria c = new Criteria();
        Collection list = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletDefinitionImpl.class, (Criteria)c));
        this.postLoadColl(list);
        return list;
    }

    public PortletApplication getPortletApplication(String name) {
        return this.getPortletApplication(name, false);
    }

    public PortletApplication getPortletApplication(String name, boolean fromCache) {
        CacheElement cacheElement;
        if (fromCache && (cacheElement = this.applicationNameCache.get((Object)name)) != null && (cacheElement = this.applicationOidCache.get((Object)((RegistryCacheObjectWrapper)cacheElement.getContent()).getId())) != null) {
            return (PortletApplication)cacheElement.getContent();
        }
        Criteria c = new Criteria();
        c.addEqualTo("name", (Object)name);
        PortletApplication app = (PortletApplication)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(PortletApplicationDefinitionImpl.class, (Criteria)c));
        this.postLoad(app);
        return app;
    }

    public Collection<PortletApplication> getPortletApplications() {
        Criteria c = new Criteria();
        Collection list = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletApplicationDefinitionImpl.class, (Criteria)c));
        this.postLoadColl(list);
        return list;
    }

    public PortletDefinition getPortletDefinitionByUniqueName(String name) {
        return this.getPortletDefinitionByUniqueName(name, false);
    }

    public PortletDefinition getPortletDefinitionByUniqueName(String name, boolean fromCache) {
        CacheElement cacheElement;
        if (fromCache && (cacheElement = this.portletNameCache.get((Object)name)) != null && (cacheElement = this.portletOidCache.get((Object)((RegistryCacheObjectWrapper)cacheElement.getContent()).getId())) != null) {
            return (PortletDefinition)cacheElement.getContent();
        }
        String appName = PortletRegistryHelper.parseAppName(name);
        String portletName = PortletRegistryHelper.parsePortletName(name);
        Criteria c = new Criteria();
        c.addEqualTo("app.name", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        PortletDefinition def = (PortletDefinition)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(PortletDefinitionImpl.class, (Criteria)c));
        if (def != null && def.getApplication() == null) {
            String msg = "getPortletDefinitionByIdentifier() returned a PortletDefinition that has no parent PortletApplication.";
            throw new IllegalStateException("getPortletDefinitionByIdentifier() returned a PortletDefinition that has no parent PortletApplication.");
        }
        this.postLoad(def);
        return def;
    }

    public boolean portletApplicationExists(String name) {
        return this.getPortletApplication(name, true) != null;
    }

    public boolean portletDefinitionExists(String portletName, PortletApplication app) {
        return this.getPortletDefinitionByUniqueName(app.getName() + PORTLET_UNIQUE_NAME_SEPARATOR + portletName) != null;
    }

    public void registerPortletApplication(PortletApplication newApp) throws RegistryException {
        this.getPersistenceBrokerTemplate().store((Object)newApp);
        this.preferenceService.storeDefaults(newApp);
    }

    public void removeApplication(PortletApplication app) throws RegistryException {
        this.getPersistenceBrokerTemplate().delete((Object)app);
        this.preferenceService.removeDefaults(app);
    }

    public void updatePortletApplication(PortletApplication app) throws RegistryException {
        this.getPersistenceBrokerTemplate().store((Object)app);
    }

    private void postLoad(Object obj) {
        if (obj != null && obj instanceof Support) {
            try {
                ((Support)obj).postLoad(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void postLoadColl(Collection coll) {
        Iterator itr;
        Object test;
        if (coll != null && !coll.isEmpty() && (test = (itr = coll.iterator()).next()) instanceof Support) {
            Support testSupport = (Support)test;
            try {
                testSupport.postLoad((Object)testSupport);
            }
            catch (Exception e1) {
                // empty catch block
            }
            while (itr.hasNext()) {
                Support support = (Support)itr.next();
                try {
                    support.postLoad((Object)support);
                }
                catch (Exception e) {}
            }
        }
    }

    public void savePortletDefinition(PortletDefinition portlet) throws FailedToStorePortletDefinitionException {
        try {
            this.getPersistenceBrokerTemplate().store((Object)portlet);
            portlet.storeChildren();
        }
        catch (DataAccessException e) {
            throw new FailedToStorePortletDefinitionException(portlet, (Throwable)e);
        }
    }

    public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
        block4: {
            block3: {
                if (cache != this.portletNameCache) break block3;
                RegistryPortletCache.cacheRemoveQuiet((String)key, (RegistryCacheObjectWrapper)element);
                if (this.listeners == null || this.listeners.isEmpty()) break block4;
                PortletDefinition pd = this.getPortletDefinitionByUniqueName((String)key);
                for (int ix = 0; ix < this.listeners.size(); ++ix) {
                    RegistryEventListener listener = this.listeners.get(ix);
                    listener.portletRemoved(pd);
                }
                break block4;
            }
            RegistryApplicationCache.cacheRemoveQuiet((String)key, (RegistryCacheObjectWrapper)element);
            if (this.listeners != null && !this.listeners.isEmpty()) {
                PortletApplication pa = this.getPortletApplication((String)key);
                for (int ix = 0; ix < this.listeners.size(); ++ix) {
                    RegistryEventListener listener = this.listeners.get(ix);
                    listener.applicationRemoved(pa);
                }
            }
        }
    }

    public void addRegistryListener(RegistryEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeRegistryEventListener(RegistryEventListener listener) {
        this.listeners.remove(listener);
    }

    public void clonePortletDefinition(PortletDefinition source, String newPortletName) throws FailedToStorePortletDefinitionException {
        Description copyDesc;
        if (this.portletDefinitionExists(newPortletName, source.getApplication())) {
            throw new FailedToStorePortletDefinitionException("Cannot clone to portlet named " + newPortletName + ", name already exists");
        }
        PortletDefinitionImpl copy = new PortletDefinitionImpl();
        copy.setPortletName(newPortletName);
        DisplayName displayName = copy.addDisplayName(JetspeedLocale.getDefaultLocale().getLanguage());
        displayName.setDisplayName(newPortletName);
        copy.setApplication(source.getApplication());
        copy.setPortletClass(source.getPortletClass());
        copy.setResourceBundle(source.getResourceBundle());
        copy.setPreferenceValidatorClassname(source.getPreferenceValidatorClassname());
        copy.setExpirationCache(source.getExpirationCache());
        copy.setCacheScope(source.getCacheScope());
        for (LocalizedField field : source.getMetadata().getFields()) {
            copy.getMetadata().addField(field.getLocale(), field.getName(), field.getValue());
        }
        copy.setJetspeedSecurityConstraint(source.getJetspeedSecurityConstraint());
        for (Description desc : source.getDescriptions()) {
            Description copyDesc2 = copy.addDescription(desc.getLang());
            copyDesc2.setDescription(desc.getDescription());
        }
        for (InitParam initParam : source.getInitParams()) {
            InitParam copyInitParam = copy.addInitParam(initParam.getParamName());
            copyInitParam.setParamValue(initParam.getParamValue());
            for (Description desc : initParam.getDescriptions()) {
                copyDesc = copyInitParam.addDescription(desc.getLang());
                copyDesc.setDescription(desc.getDescription());
            }
        }
        for (EventDefinitionReference eventDefRef : source.getSupportedProcessingEvents()) {
            copy.addSupportedProcessingEvent(eventDefRef.getQName());
        }
        for (EventDefinitionReference eventDefRef : source.getSupportedPublishingEvents()) {
            copy.addSupportedPublishingEvent(eventDefRef.getQName());
        }
        for (SecurityRoleRef secRoleRef : source.getSecurityRoleRefs()) {
            SecurityRoleRef copySecRoleRef = copy.addSecurityRoleRef(secRoleRef.getRoleName());
            copySecRoleRef.setRoleLink(secRoleRef.getRoleLink());
            for (Description desc : secRoleRef.getDescriptions()) {
                copyDesc = copySecRoleRef.addDescription(desc.getLang());
                copyDesc.setDescription(desc.getDescription());
            }
        }
        for (Supports supports : source.getSupports()) {
            Supports copySupports = copy.addSupports(supports.getMimeType());
            for (String portletMode : supports.getPortletModes()) {
                copySupports.addPortletMode(portletMode);
            }
            for (String windowState : supports.getWindowStates()) {
                copySupports.addWindowState(windowState);
            }
        }
        for (Language language : source.getLanguages()) {
            Language copyLanguage = copy.addLanguage(language.getLocale());
            copyLanguage.setTitle(language.getTitle());
            copyLanguage.setShortTitle(language.getShortTitle());
            copyLanguage.setKeywords(language.getKeywords());
            copyLanguage.setSupportedLocale(language.isSupportedLocale());
        }
        for (ContainerRuntimeOption runtimeOption : source.getContainerRuntimeOptions()) {
            ContainerRuntimeOption copyRuntimeOption = copy.addContainerRuntimeOption(runtimeOption.getName());
            for (String value : runtimeOption.getValues()) {
                copyRuntimeOption.addValue(value);
            }
        }
        copy.getSupportedPublicRenderParameters().addAll(source.getSupportedPublicRenderParameters());
        source.getApplication().getPortlets().add(copy);
        try {
            this.updatePortletApplication(source.getApplication());
        }
        catch (RegistryException e) {
            throw new FailedToStorePortletDefinitionException((Throwable)e);
        }
        for (Preference pref : source.getPortletPreferences().getPortletPreferences()) {
            Preference copyPref = copy.addDescriptorPreference(pref.getName());
            copyPref.setReadOnly(pref.isReadOnly());
            for (String value : pref.getValues()) {
                copyPref.addValue(value);
            }
        }
        try {
            this.preferenceService.storeDefaults((PortletDefinition)copy);
        }
        catch (Throwable e) {
            source.getApplication().getPortlets().remove(copy);
            throw new FailedToStorePortletDefinitionException(e);
        }
    }
}

