/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.datasource;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.jetspeed.components.datasource.DatasourceComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCPDatasourceComponent
implements DatasourceComponent {
    private static final Logger log = LoggerFactory.getLogger(DBCPDatasourceComponent.class);
    protected PoolingDataSource dataSource;
    private String user;
    private String password;
    private String driverName;
    private String connectURI;
    private int maxActive;
    private int maxWait;
    private byte whenExhausted;
    private boolean autoCommit;
    private PoolableConnectionFactory dsConnectionFactory;

    public DBCPDatasourceComponent(String user, String password, String driverName, String connectURI, int maxActive, int maxWait, byte whenExhausted, boolean autoCommit) {
        log.info("Setting up data source pooling for " + driverName);
        log.info("Max active connnections set to: " + maxActive);
        log.info("Pool is set to \"" + whenExhausted + "\" when all connections are exhausted.");
        this.user = user;
        this.password = password;
        this.driverName = driverName;
        this.connectURI = connectURI;
        this.maxActive = maxActive;
        this.maxWait = maxWait;
        this.autoCommit = autoCommit;
    }

    public DataSource getDatasource() {
        return this.dataSource;
    }

    public void start() {
        try {
            log.info("Attempting to start DBCPCDatasourceComponent.");
            Class.forName(this.driverName);
            try {
                Connection conn = DriverManager.getConnection(this.connectURI, this.user, this.password);
                conn.close();
            }
            catch (Exception e) {
                log.error("Unable to obtain a connection database via URI: " + this.connectURI, (Throwable)e);
                throw e;
            }
            GenericObjectPool connectionPool = new GenericObjectPool(null, this.maxActive, this.whenExhausted, (long)this.maxWait);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.connectURI, this.user, this.password);
            this.dsConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, this.autoCommit);
            this.dataSource = new PoolingDataSource((ObjectPool)connectionPool);
            log.info("DBCPCDatasourceComponent successfuly started!");
        }
        catch (Throwable e) {
            CharArrayWriter caw = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(caw));
            String msg = "Unable to start DBCPCDatasourceComponent: ";
            log.error(msg + e.toString(), e);
            throw new IllegalStateException(msg + caw.toString());
        }
    }

    public void stop() {
        try {
            if (log.isInfoEnabled()) {
                log.info("Stopping DBCPCDatasourceComponent");
            }
            this.dsConnectionFactory.getPool().close();
            if (this.driverName.equals("org.apache.derby.jdbc.EmbeddedDriver")) {
                if (log.isInfoEnabled()) {
                    log.info("Shutting down derby ...");
                }
                String shutDownURI = null;
                int parIndex = this.connectURI.indexOf(";");
                shutDownURI = parIndex > -1 ? this.connectURI.substring(0, parIndex) + ";shutdown=true" : this.connectURI + ";shutdown=true";
                Class<?> dc = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                Driver driver = (Driver)dc.newInstance();
                Properties info = new Properties();
                info.put("user", this.user);
                info.put("password", this.password);
                driver.connect(shutDownURI, info);
            }
        }
        catch (SQLException e) {
            if (this.driverName.equals("org.apache.derby.jdbc.EmbeddedDriver") && (e.getSQLState().equals("XJ015") || e.getSQLState().equals("08006"))) {
                if (log.isDebugEnabled()) {
                    log.debug("Database shut down normally with sql state '" + e.getSQLState() + "'.");
                }
            } else {
                IllegalStateException ise = new IllegalStateException("Unable to safely shutdown the DBCPConnection pool: " + e.toString());
                ise.initCause(e);
                try {
                    log.error("Unable to safely shutdown the DBCPConnection pool", (Throwable)ise);
                }
                catch (Exception e1) {}
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to safely shutdown the DBCPConnection pool: " + e.toString());
            ise.initCause(e);
            try {
                log.error("Unable to safely shutdown the DBCPConnection pool", (Throwable)ise);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

