/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.jetspeed.tools.migration.JetspeedMigration;
import org.apache.jetspeed.tools.migration.JetspeedMigrationListener;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResult;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResultImpl;

public class JetspeedProfilerMigration
implements JetspeedMigration {
    public String getName() {
        return "Profiler";
    }

    public int detectSourceVersion(Connection sourceConnection, int sourceVersion) throws SQLException {
        return sourceVersion > 0 ? sourceVersion : 213;
    }

    public JetspeedMigrationResult migrate(Connection sourceConnection, int sourceVersion, Connection targetConnection, JetspeedMigrationListener migrationListener) throws SQLException {
        int rowsMigrated = 0;
        PreparedStatement profilingRuleInsertStatement = targetConnection.prepareStatement("INSERT INTO PROFILING_RULE (RULE_ID, CLASS_NAME, TITLE) VALUES (?, ?, ?)");
        Statement profilingRuleQueryStatement = sourceConnection.createStatement();
        profilingRuleQueryStatement.setFetchSize(10000);
        ResultSet profilingRuleResultSet = profilingRuleQueryStatement.executeQuery("SELECT RULE_ID, CLASS_NAME, TITLE FROM PROFILING_RULE");
        while (profilingRuleResultSet.next()) {
            profilingRuleInsertStatement.setString(1, profilingRuleResultSet.getString(1));
            profilingRuleInsertStatement.setString(2, profilingRuleResultSet.getString(2));
            profilingRuleInsertStatement.setString(3, profilingRuleResultSet.getString(3));
            profilingRuleInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        profilingRuleResultSet.close();
        profilingRuleQueryStatement.close();
        profilingRuleInsertStatement.close();
        PreparedStatement ruleCriterionInsertStatement = targetConnection.prepareStatement("INSERT INTO RULE_CRITERION (CRITERION_ID, RULE_ID, FALLBACK_ORDER, REQUEST_TYPE, NAME, COLUMN_VALUE, FALLBACK_TYPE) VALUES (?, ?, ?, ?, ?, ?, ?)");
        Statement ruleCriterionQueryStatement = sourceConnection.createStatement();
        ruleCriterionQueryStatement.setFetchSize(10000);
        ResultSet ruleCriterionResultSet = ruleCriterionQueryStatement.executeQuery("SELECT CRITERION_ID, RULE_ID, FALLBACK_ORDER, REQUEST_TYPE, NAME, COLUMN_VALUE, FALLBACK_TYPE FROM RULE_CRITERION");
        while (ruleCriterionResultSet.next()) {
            ruleCriterionInsertStatement.setString(1, ruleCriterionResultSet.getString(1));
            ruleCriterionInsertStatement.setString(2, ruleCriterionResultSet.getString(2));
            ruleCriterionInsertStatement.setInt(3, ruleCriterionResultSet.getInt(3));
            ruleCriterionInsertStatement.setString(4, ruleCriterionResultSet.getString(4));
            ruleCriterionInsertStatement.setString(5, ruleCriterionResultSet.getString(5));
            ruleCriterionInsertStatement.setString(6, ruleCriterionResultSet.getString(6));
            JetspeedMigration.Static.setNullableInt((ResultSet)ruleCriterionResultSet, (int)7, (PreparedStatement)ruleCriterionInsertStatement);
            ruleCriterionInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        ruleCriterionResultSet.close();
        ruleCriterionQueryStatement.close();
        ruleCriterionInsertStatement.close();
        PreparedStatement principalRuleAssocInsertStatement = targetConnection.prepareStatement("INSERT INTO PRINCIPAL_RULE_ASSOC (PRINCIPAL_NAME, LOCATOR_NAME, RULE_ID) VALUES (?, ?, ?)");
        Statement principalRuleAssocQueryStatement = sourceConnection.createStatement();
        principalRuleAssocQueryStatement.setFetchSize(10000);
        ResultSet principalRuleAssocResultSet = principalRuleAssocQueryStatement.executeQuery("SELECT PRINCIPAL_NAME, LOCATOR_NAME, RULE_ID FROM PRINCIPAL_RULE_ASSOC");
        while (principalRuleAssocResultSet.next()) {
            principalRuleAssocInsertStatement.setString(1, principalRuleAssocResultSet.getString(1));
            principalRuleAssocInsertStatement.setString(2, principalRuleAssocResultSet.getString(2));
            principalRuleAssocInsertStatement.setString(3, principalRuleAssocResultSet.getString(3));
            principalRuleAssocInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        principalRuleAssocResultSet.close();
        principalRuleAssocQueryStatement.close();
        principalRuleAssocInsertStatement.close();
        PreparedStatement profilePageAssocInsertStatement = targetConnection.prepareStatement("INSERT INTO PROFILE_PAGE_ASSOC (LOCATOR_HASH, PAGE_ID) VALUES (?, ?)");
        Statement profilePageAssocQueryStatement = sourceConnection.createStatement();
        profilePageAssocQueryStatement.setFetchSize(10000);
        ResultSet profilePageAssocResultSet = profilePageAssocQueryStatement.executeQuery("SELECT LOCATOR_HASH, PAGE_ID FROM PROFILE_PAGE_ASSOC");
        while (profilePageAssocResultSet.next()) {
            profilePageAssocInsertStatement.setString(1, profilePageAssocResultSet.getString(1));
            profilePageAssocInsertStatement.setString(2, profilePageAssocResultSet.getString(2));
            profilePageAssocInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        profilePageAssocResultSet.close();
        profilePageAssocQueryStatement.close();
        profilePageAssocInsertStatement.close();
        PreparedStatement ojbInsertStatement = targetConnection.prepareStatement("INSERT INTO OJB_HL_SEQ (TABLENAME, FIELDNAME, MAX_KEY, GRAB_SIZE, VERSION) VALUES (?, ?, ?, ?, ?)");
        Statement ojbQueryStatement = sourceConnection.createStatement();
        ResultSet ojbResultSet = ojbQueryStatement.executeQuery("SELECT TABLENAME, FIELDNAME, MAX_KEY, GRAB_SIZE, VERSION FROM OJB_HL_SEQ WHERE TABLENAME IN ('SEQ_RULE_CRITERION')");
        while (ojbResultSet.next()) {
            ojbInsertStatement.setString(1, ojbResultSet.getString(1));
            ojbInsertStatement.setString(2, ojbResultSet.getString(2));
            ojbInsertStatement.setInt(3, ojbResultSet.getInt(3));
            ojbInsertStatement.setInt(4, ojbResultSet.getInt(4));
            ojbInsertStatement.setInt(5, ojbResultSet.getInt(5));
            ojbInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        ojbResultSet.close();
        ojbQueryStatement.close();
        ojbInsertStatement.close();
        return new JetspeedMigrationResultImpl(rowsMigrated);
    }
}

