/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.rules.ProfileResolvers;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.request.RequestContext;
import org.apache.ojb.broker.util.collections.RemovalAwareCollection;

public abstract class AbstractProfilingRule
implements ProfilingRule {
    private static final long serialVersionUID = 1L;
    protected Collection<RuleCriterion> criteria = new RemovalAwareCollection();
    protected String id;
    protected String title;
    protected String ojbConcreteClass;
    protected Map<String, ProfileLocator> locators = Collections.synchronizedMap(new HashMap());
    protected ProfileResolvers resolvers;

    public AbstractProfilingRule() {
    }

    public AbstractProfilingRule(ProfileResolvers resolvers) {
        this.resolvers = resolvers;
    }

    protected ProfileLocator getLocatorFromCache(String key) {
        return this.locators.get(key);
    }

    protected void addLocatorToCache(String key, ProfileLocator locator) {
        this.locators.put(key, locator);
    }

    public RuleCriterionResolver getResolver(String name) {
        return this.resolvers.get(name);
    }

    public RuleCriterionResolver getDefaultResolver() {
        return this.resolvers.get("request");
    }

    public abstract ProfileLocator apply(RequestContext var1, Profiler var2);

    public Collection<RuleCriterion> getRuleCriteria() {
        return this.criteria;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getClassname() {
        return this.ojbConcreteClass;
    }

    public void setClassname(String classname) {
        this.ojbConcreteClass = classname;
    }

    public String toString() {
        if (this.id != null) {
            return this.id;
        }
        if (this.title != null) {
            return this.title;
        }
        return this.getClass().toString();
    }

    public ProfileResolvers getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(ProfileResolvers resolvers) {
        this.resolvers = resolvers;
    }
}

