/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.impl;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.profiler.rules.PrincipalRule;
import org.apache.jetspeed.profiler.rules.ProfileResolvers;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.impl.AbstractProfilingRule;
import org.apache.jetspeed.profiler.rules.impl.PrincipalRuleImpl;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class JetspeedProfilerImpl
extends InitablePersistenceBrokerDaoSupport
implements Profiler,
BeanFactoryAware {
    public static final String PROFILER_CONTEXT_ATTRIBUTE_NAME = "org.apache.jetspeed.profiler.ProfilerContext";
    public static final String DEFAULT_GUEST_PRINCIPAL_NAME = "guest";
    public static final String DEFAULT_RULE_PRINCIPAL_NAME = "*";
    public static final long DEFAULT_AND_GUEST_RULE_REAPING_INTERVAL = 30000L;
    public static final String DEFAULT_RULE = "j1";
    protected static final Logger log = LoggerFactory.getLogger(JetspeedProfilerImpl.class);
    public static final Principal DEFAULT_RULE_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return JetspeedProfilerImpl.DEFAULT_RULE_PRINCIPAL_NAME;
        }
    };
    private String locatorBean = "ProfileLocator";
    private Class prRuleClass;
    private String principalRuleBean = "PrincipalRule";
    private String profilingRuleStandardBean = "StandardProfilingRule";
    private String profilingRuleFallbackBean = "RoleFallbackProfilingRule";
    private Class profilingRuleClass = AbstractProfilingRule.class;
    private String defaultRule = "j1";
    private Map<String, PrincipalRule> principalRules = Collections.synchronizedMap(new HashMap());
    private Map<String, Collection<PrincipalRule>> rulesPerPrincipal = Collections.synchronizedMap(new HashMap());
    private Map<String, Collection<PrincipalRule>> allRulesPerPrincipal = Collections.synchronizedMap(new HashMap());
    private ProfileResolvers resolvers;
    private String ruleCriterionBean = "RuleCriterion";
    private BeanFactory beanFactory;
    private volatile long lastDefaultGuestReapTime = System.currentTimeMillis();
    private String guestPrincipalName;

    public JetspeedProfilerImpl(String repositoryPath, ProfileResolvers resolvers) {
        super(repositoryPath);
        this.resolvers = resolvers;
    }

    public JetspeedProfilerImpl(String repositoryPath, String defaultRule, ProfileResolvers resolvers) throws ClassNotFoundException {
        this(repositoryPath, resolvers);
        this.defaultRule = defaultRule;
    }

    public JetspeedProfilerImpl(String repositoryPath, String defaultRule, Properties properties, ProfileResolvers resolvers) throws ClassNotFoundException {
        this(repositoryPath, defaultRule, resolvers);
        this.initModelClasses(properties);
    }

    public JetspeedProfilerImpl(String repositoryPath, String defaultRule, ProfileResolvers resolvers, Map<String, String> ruleConstructors, String ruleCriterionBean) throws ClassNotFoundException {
        this(repositoryPath, defaultRule, resolvers);
        this.ruleCriterionBean = ruleCriterionBean;
        this.initRuleClasses(ruleConstructors);
    }

    public void setDefaultRule(String defaultRule) {
        this.defaultRule = defaultRule;
    }

    private void initModelClasses(Properties properties) throws ClassNotFoundException {
    }

    public ProfileLocator getProfile(RequestContext context, String locatorName) throws ProfilerException {
        Subject subject = context.getSubject();
        if (subject == null) {
            String msg = "Invalid (null) Subject in request pipeline";
            log.error(msg);
            throw new ProfilerException(msg);
        }
        Principal principal = SubjectHelper.getBestPrincipal((Subject)subject, UserSubjectPrincipal.class);
        if (principal == null) {
            String msg = "Could not find a principle for subject in request pipeline";
            log.error(msg);
            throw new ProfilerException(msg);
        }
        this.setupProfilerContext(context);
        ProfilingRule rule = this.getRuleForPrincipal(principal, locatorName);
        if (null == rule) {
            log.warn("Could not find profiling rule for principal: " + principal);
            rule = this.getDefaultRule();
        }
        if (null == rule) {
            String msg = "Couldn't find any profiling rules including default rule for principal " + principal;
            log.error(msg);
            throw new ProfilerException(msg);
        }
        return rule.apply(context, (Profiler)this);
    }

    public ProfileLocator getDefaultProfile(RequestContext context, String locatorName) throws ProfilerException {
        ProfilingRule rule = this.getRuleForPrincipal(DEFAULT_RULE_PRINCIPAL, locatorName);
        if (null == rule) {
            log.warn("Could not find profiling rule for principal: " + DEFAULT_RULE_PRINCIPAL);
            rule = this.getDefaultRule();
        }
        if (null == rule) {
            String msg = "Couldn't find any profiling rules including default rule for principal " + DEFAULT_RULE_PRINCIPAL;
            log.error(msg);
            throw new ProfilerException(msg);
        }
        return rule.apply(context, (Profiler)this);
    }

    public ProfileLocator getProfile(RequestContext context, ProfilingRule rule) throws ProfilerException {
        return rule.apply(context, (Profiler)this);
    }

    public ProfilingRule getRuleForPrincipal(Principal principal, String locatorName) {
        ProfilingRule rule = null;
        PrincipalRule pr = this.lookupPrincipalRule(principal.getName(), locatorName);
        if (pr == null) {
            rule = this.getRule(locatorName);
            if (rule == null) {
                rule = this.getDefaultRule();
            }
            pr = new PrincipalRuleImpl();
            pr.setLocatorName(locatorName);
            pr.setPrincipalName(principal.getName());
            pr.setProfilingRule(rule);
            this.principalRules.put(this.makePrincipalRuleKey(principal.getName(), locatorName), pr);
            this.trackCachedPrincipalRulesPut(principal.getName(), pr);
        } else {
            rule = pr.getProfilingRule();
        }
        return rule;
    }

    private Class getPrincipalRuleClass() {
        if (this.prRuleClass == null) {
            try {
                PrincipalRule tempRule = this.createPrincipalRule();
                this.prRuleClass = tempRule.getClass();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.prRuleClass;
    }

    public void setRuleForPrincipal(Principal principal, ProfilingRule rule, String locatorName) {
        Criteria c = new Criteria();
        c.addEqualTo("principalName", (Object)principal.getName());
        c.addEqualTo("locatorName", (Object)locatorName);
        PrincipalRule pr = (PrincipalRule)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)this.getPrincipalRuleClass(), (Criteria)c));
        if (pr == null) {
            pr = new PrincipalRuleImpl();
            pr.setPrincipalName(principal.getName());
            pr.setLocatorName(locatorName);
            pr.setProfilingRule(rule);
        }
        rule.setResolvers(this.resolvers);
        pr.setProfilingRule(rule);
        this.getPersistenceBrokerTemplate().store((Object)pr);
        this.principalRules.put(this.makePrincipalRuleKey(principal.getName(), locatorName), pr);
        this.trackCachedPrincipalRulesPut(principal.getName(), pr);
        this.rulesPerPrincipal.remove(principal.getName());
    }

    private String makePrincipalRuleKey(String principal, String locator) {
        return principal + ":" + locator;
    }

    private PrincipalRule lookupPrincipalRule(String principal, String locatorName) {
        PrincipalRule pr = this.principalRules.get(this.makePrincipalRuleKey(principal, locatorName));
        if (pr != null) {
            return pr;
        }
        Criteria c = new Criteria();
        c.addEqualTo("principalName", (Object)principal);
        c.addEqualTo("locatorName", (Object)locatorName);
        pr = (PrincipalRule)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)this.getPrincipalRuleClass(), (Criteria)c));
        if (pr != null) {
            pr.getProfilingRule().setResolvers(this.resolvers);
        }
        this.principalRules.put(this.makePrincipalRuleKey(principal, locatorName), pr);
        this.trackCachedPrincipalRulesPut(principal, pr);
        return pr;
    }

    public ProfilingRule getDefaultRule() {
        return this.getRule(this.defaultRule);
    }

    public Collection<ProfilingRule> getRules() {
        Collection rules = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)this.profilingRuleClass, (Criteria)new Criteria()));
        for (ProfilingRule rule : rules) {
            rule.setResolvers(this.resolvers);
        }
        return rules;
    }

    public ProfilingRule getRule(String id) {
        Criteria c = new Criteria();
        c.addEqualTo("id", (Object)id);
        ProfilingRule rule = (ProfilingRule)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)this.profilingRuleClass, (Criteria)c));
        if (rule != null) {
            rule.setResolvers(this.resolvers);
        }
        return rule;
    }

    public String[] getLocatorNamesForPrincipal(Principal principal) {
        Criteria c = new Criteria();
        c.addEqualTo("principalName", (Object)principal.getName());
        Collection result = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)this.getPrincipalRuleClass(), (Criteria)c));
        if (result.size() == 0) {
            return new String[0];
        }
        String[] names = new String[result.size()];
        int ix = 0;
        for (PrincipalRule pr : result) {
            names[ix] = pr.getLocatorName();
            pr.getProfilingRule().setResolvers(this.resolvers);
            ++ix;
        }
        return names;
    }

    public Collection<PrincipalRule> getRulesForPrincipal(Principal principal) {
        Collection rules = this.rulesPerPrincipal.get(principal.getName());
        if (rules != null) {
            return rules;
        }
        Criteria c = new Criteria();
        c.addEqualTo("principalName", (Object)principal.getName());
        rules = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)this.getPrincipalRuleClass(), (Criteria)c));
        for (PrincipalRule pr : rules) {
            ProfilingRule rule = pr.getProfilingRule();
            if (rule == null) continue;
            rule.setResolvers(this.resolvers);
        }
        this.rulesPerPrincipal.put(principal.getName(), rules);
        return rules;
    }

    public Map<String, ProfileLocator> getProfileLocators(RequestContext context, Principal principal) throws ProfilerException {
        this.setupProfilerContext(context);
        HashMap<String, ProfileLocator> locators = new HashMap<String, ProfileLocator>();
        Collection<PrincipalRule> rules = this.getRulesForPrincipal(principal);
        for (PrincipalRule pr : rules) {
            locators.put(pr.getLocatorName(), this.getProfile(context, pr.getLocatorName()));
        }
        return locators;
    }

    public Map<String, ProfileLocator> getDefaultProfileLocators(RequestContext context) throws ProfilerException {
        HashMap<String, ProfileLocator> locators = new HashMap<String, ProfileLocator>();
        Collection<PrincipalRule> rules = this.getRulesForPrincipal(DEFAULT_RULE_PRINCIPAL);
        for (PrincipalRule pr : rules) {
            locators.put(pr.getLocatorName(), this.getDefaultProfile(context, pr.getLocatorName()));
        }
        return locators;
    }

    public void storeProfilingRule(ProfilingRule rule) throws ProfilerException {
        this.getPersistenceBrokerTemplate().store((Object)rule);
    }

    public void deleteProfilingRule(ProfilingRule rule) throws ProfilerException {
        this.getPersistenceBrokerTemplate().delete((Object)rule);
    }

    public void storePrincipalRule(PrincipalRule rule) throws ProfilerException {
        this.getPersistenceBrokerTemplate().store((Object)rule);
    }

    public void deletePrincipalRule(PrincipalRule rule) throws ProfilerException {
        this.getPersistenceBrokerTemplate().delete((Object)rule);
        this.rulesPerPrincipal.remove(rule.getPrincipalName());
        String key = this.makePrincipalRuleKey(rule.getPrincipalName(), rule.getLocatorName());
        this.principalRules.remove(key);
        this.trackCachedPrincipalRulesRemoved(rule.getPrincipalName(), rule);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private void initRuleClasses(Map<String, String> beans) throws ClassNotFoundException {
        String msg;
        String beanName = "";
        try {
            beanName = beans.get("locator");
            if (beanName != null) {
                this.locatorBean = beanName;
            }
        }
        catch (Exception e) {
            msg = "Exception in setting locatorbeanName : " + e.getLocalizedMessage();
            log.error(msg);
        }
        try {
            beanName = beans.get("principal");
            if (beanName != null) {
                this.principalRuleBean = beanName;
            }
        }
        catch (Exception e) {
            msg = "Exception in setting principalRulebeanName : " + e.getLocalizedMessage();
            log.error(msg);
        }
        try {
            beanName = beans.get("standard");
            if (beanName != null) {
                this.profilingRuleStandardBean = beanName;
            }
        }
        catch (Exception e) {
            msg = "Exception in setting profilingRuleStandardbeanName : " + e.getLocalizedMessage();
            log.error(msg);
        }
        try {
            beanName = beans.get("fallback");
            if (beanName != null) {
                this.profilingRuleFallbackBean = beanName;
            }
        }
        catch (Exception e) {
            msg = "Exception in setting profilingRuleFallback : " + e.getLocalizedMessage();
            log.error(msg);
        }
    }

    public ProfilingRule createProfilingRule(boolean standard) throws ClassNotFoundException {
        try {
            if (standard) {
                return (ProfilingRule)this.beanFactory.getBean(this.profilingRuleStandardBean, ProfilingRule.class);
            }
            return (ProfilingRule)this.beanFactory.getBean(this.profilingRuleFallbackBean, ProfilingRule.class);
        }
        catch (BeansException e) {
            throw new ClassNotFoundException("Spring failed to create the " + (standard ? "standard" : "fallback") + " profiling rule bean.", e);
        }
    }

    public ProfileLocator createLocator(RequestContext context) {
        try {
            ProfileLocator locator = (ProfileLocator)this.beanFactory.getBean(this.locatorBean, ProfileLocator.class);
            locator.init((Profiler)this, context.getPath(), context.getRequest() != null ? context.getRequest().getServerName() : null);
            return locator;
        }
        catch (Exception e) {
            log.error("Failed to create locator for " + this.locatorBean + " error : " + e.getLocalizedMessage());
            return null;
        }
    }

    public PrincipalRule createPrincipalRule() throws ClassNotFoundException {
        try {
            PrincipalRule principalRule = (PrincipalRule)this.beanFactory.getBean(this.principalRuleBean, PrincipalRule.class);
            return principalRule;
        }
        catch (Exception e) {
            log.error("Failed to create principalRule for " + this.principalRuleBean + " error : " + e.getLocalizedMessage());
            throw new ClassNotFoundException("Spring failed to create the  principal rule bean.", e);
        }
    }

    public RuleCriterion createRuleCriterion() throws ClassNotFoundException {
        try {
            RuleCriterion ruleCriterion = (RuleCriterion)this.beanFactory.getBean(this.ruleCriterionBean, RuleCriterion.class);
            return ruleCriterion;
        }
        catch (Exception e) {
            log.error("Failed to create principalRule for " + this.ruleCriterionBean + " error : " + e.getLocalizedMessage());
            throw new ClassNotFoundException("Spring failed to create the  rule criterion bean.", e);
        }
    }

    private void setupProfilerContext(RequestContext context) throws ProfilerException {
        ProfilerContext profilerContext = (ProfilerContext)context.getSessionAttribute(PROFILER_CONTEXT_ATTRIBUTE_NAME);
        try {
            Principal principal = SubjectHelper.getBestPrincipal((Subject)context.getSubject(), UserSubjectPrincipal.class);
            if (principal == null) {
                throw new NullPointerException("Principal not found");
            }
            if (profilerContext == null || profilerContext.getPrincipal() != principal) {
                context.setSessionAttribute(PROFILER_CONTEXT_ATTRIBUTE_NAME, (Object)new ProfilerContext(this, principal));
            }
        }
        catch (Exception e) {
            String message = "Unable to access principal in pipeline: " + e;
            log.error(message, (Throwable)e);
            throw new ProfilerException(message, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackCachedPrincipalRulesPut(String principalName, PrincipalRule rule) {
        if (rule != null) {
            Map<String, Collection<PrincipalRule>> map = this.allRulesPerPrincipal;
            synchronized (map) {
                Collection<PrincipalRule> allRules = this.allRulesPerPrincipal.get(principalName);
                if (allRules == null) {
                    allRules = new ArrayList<PrincipalRule>(4);
                    this.allRulesPerPrincipal.put(principalName, allRules);
                }
                allRules.add(rule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackCachedPrincipalRulesRemoved(String principalName, PrincipalRule rule) {
        if (rule != null) {
            Map<String, Collection<PrincipalRule>> map = this.allRulesPerPrincipal;
            synchronized (map) {
                Collection<PrincipalRule> allRules = this.allRulesPerPrincipal.get(principalName);
                if (allRules != null) {
                    allRules.remove(rule);
                }
            }
        }
    }

    private void evictCachedPrincipalRules(String principalName, boolean force) {
        Collection<PrincipalRule> rules;
        if (principalName != null && (force || !principalName.equals(this.getGuestPrincipalName()) && !principalName.equals(DEFAULT_RULE_PRINCIPAL_NAME)) && (rules = this.allRulesPerPrincipal.remove(principalName)) != null) {
            this.rulesPerPrincipal.remove(principalName);
            for (PrincipalRule rule : rules) {
                String key = this.makePrincipalRuleKey(rule.getPrincipalName(), rule.getLocatorName());
                this.principalRules.remove(key);
            }
        }
    }

    private String getGuestPrincipalName() {
        if (this.guestPrincipalName == null) {
            String configGuestPrincipalName;
            this.guestPrincipalName = DEFAULT_GUEST_PRINCIPAL_NAME;
            PortalConfiguration config = Jetspeed.getConfiguration();
            if (config != null && (configGuestPrincipalName = config.getString("default.user.principal")) != null) {
                this.guestPrincipalName = configGuestPrincipalName;
            }
        }
        return this.guestPrincipalName;
    }

    public static class ProfilerContext
    implements HttpSessionActivationListener,
    HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient JetspeedProfilerImpl profiler;
        private transient Principal principal;
        private transient boolean guestPrincipal;

        private ProfilerContext(JetspeedProfilerImpl profiler, Principal principal) {
            this.profiler = profiler;
            this.principal = principal;
            this.guestPrincipal = principal != null && principal.getName().equals(profiler.getGuestPrincipalName());
        }

        public void sessionDidActivate(HttpSessionEvent event) {
        }

        public void sessionWillPassivate(HttpSessionEvent event) {
            this.evictPrincipal();
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            this.evictPrincipal();
        }

        private void evictPrincipal() {
            if (this.profiler != null) {
                if (this.principal != null && !this.guestPrincipal) {
                    this.profiler.evictCachedPrincipalRules(this.principal.getName(), false);
                }
                this.principal = null;
                long now = System.currentTimeMillis();
                if (now - this.profiler.lastDefaultGuestReapTime > 30000L) {
                    this.profiler.lastDefaultGuestReapTime = now;
                    this.profiler.evictCachedPrincipalRules(this.profiler.getGuestPrincipalName(), true);
                    this.profiler.evictCachedPrincipalRules(JetspeedProfilerImpl.DEFAULT_RULE_PRINCIPAL_NAME, true);
                }
            }
        }

        private Principal getPrincipal() {
            return this.principal;
        }
    }
}

