/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.profiler.rules.PrincipalRule;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.serializer.AbstractJetspeedComponentSerializer;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSPrincipal;
import org.apache.jetspeed.serializer.objects.JSPrincipalRule;
import org.apache.jetspeed.serializer.objects.JSPrincipalRules;
import org.apache.jetspeed.serializer.objects.JSProfilingRule;
import org.apache.jetspeed.serializer.objects.JSProfilingRules;
import org.apache.jetspeed.serializer.objects.JSRuleCriterion;
import org.apache.jetspeed.serializer.objects.JSRuleCriterions;
import org.apache.jetspeed.serializer.objects.JSSnapshot;
import org.slf4j.Logger;

public class JetspeedProfilerSerializer
extends AbstractJetspeedComponentSerializer {
    protected Profiler pm;
    protected UserManager userManager;

    public JetspeedProfilerSerializer(Profiler pm, UserManager userManager) {
        this.pm = pm;
        this.userManager = userManager;
    }

    protected void processExport(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        if (JetspeedProfilerSerializer.isSettingSet((Map)settings, (String)"process_profiler")) {
            log.info("collecting profiling rules and user profiling rules");
            this.exportProfilingRules(snapshot, settings, log);
            this.exportUserPrincipalRules(snapshot, settings, log);
        }
    }

    protected void deleteData(Map settings, Logger log) throws SerializerException {
        if (JetspeedProfilerSerializer.isSettingSet((Map)settings, (String)"process_profiler")) {
            log.info("deleting profiling rules and user profiling rules");
            try {
                String anonymousUser = this.userManager.getAnonymousUser();
                for (User _user : this.userManager.getUsers("")) {
                    Collection col = this.pm.getRulesForPrincipal((Principal)_user);
                    Iterator _itCol = col.iterator();
                    while (_itCol.hasNext()) {
                        this.pm.deletePrincipalRule((PrincipalRule)_itCol.next());
                    }
                }
                Iterator _itRules = this.pm.getRules().iterator();
                while (_itRules.hasNext()) {
                    this.pm.deleteProfilingRule((ProfilingRule)_itRules.next());
                }
            }
            catch (Exception e) {
                throw new SerializerException((Throwable)e);
            }
        }
    }

    protected void processImport(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        if (JetspeedProfilerSerializer.isSettingSet((Map)settings, (String)"process_profiler")) {
            log.info("creating profiling rules and user profiling rules");
            this.recreateProfilingRules(snapshot, settings, log);
            this.recreateUserPrincipalRules(snapshot, settings, log);
        }
    }

    private void recreateProfilingRules(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        log.debug("recreateProfilingRules - processing");
        JSProfilingRules rules = snapshot.getRules();
        if (rules != null && rules.size() > 0) {
            ProfilingRule defaultRule;
            for (JSProfilingRule _c : rules) {
                try {
                    ProfilingRule rule = null;
                    rule = this.pm.getRule(_c.getId());
                    if (rule != null && !JetspeedProfilerSerializer.isSettingSet((Map)settings, (String)"overwrite_existing")) continue;
                    rule = this.recreateRule(this.pm, rule, _c);
                    this.pm.storeProfilingRule(rule);
                }
                catch (Exception e) {
                    throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.capabilities.Capabilities", (Object)e.getLocalizedMessage()));
                }
            }
            String defaultRuleID = snapshot.getDefaultRule();
            if (defaultRuleID != null && (defaultRule = this.pm.getRule(defaultRuleID)) != null) {
                this.pm.setDefaultRule(defaultRuleID);
            }
        } else {
            log.debug("NO PROFILING RULES?????");
        }
        log.debug("recreateProfilingRules - done");
    }

    private void recreateUserPrincipalRules(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        User user;
        log.debug("recreateUserPrincipalRules - started");
        for (JSPrincipal _user : snapshot.getPrincipals()) {
            if (!"user".equals(_user.getType())) continue;
            try {
                user = this.userManager.getUser(_user.getName());
                this.recreatePrincipalRules(_user.getRules(), user.getName());
            }
            catch (Exception eUser) {
                eUser.printStackTrace();
            }
        }
        for (JSPrincipal _user : snapshot.getOldUsers()) {
            try {
                user = this.userManager.getUser(_user.getName());
                this.recreatePrincipalRules(_user.getRules(), user.getName());
            }
            catch (Exception eUser) {
                eUser.printStackTrace();
            }
        }
        log.debug("recreateUserPrincipalRules - done");
    }

    private void recreatePrincipalRules(JSPrincipalRules rules, String principalName) {
        for (JSPrincipalRule pr : rules) {
            ProfilingRule pRule = this.pm.getRule(pr.getRule());
            try {
                PrincipalRule p1 = this.pm.createPrincipalRule();
                p1.setLocatorName(pr.getLocator());
                p1.setProfilingRule(pRule);
                p1.setPrincipalName(principalName);
                this.pm.storePrincipalRule(p1);
            }
            catch (Exception eRole) {
                eRole.printStackTrace();
            }
        }
    }

    protected RuleCriterion recreateRuleCriterion(Profiler profiler, JSRuleCriterion jsr, ProfilingRule rule) throws SerializerException, ClassNotFoundException {
        try {
            RuleCriterion c = profiler.createRuleCriterion();
            if (c == null) {
                throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.profiler.rules.RuleCriterion", (Object)"returned null"));
            }
            c.setFallbackOrder(jsr.getFallBackOrder());
            c.setFallbackType(jsr.getFallBackType());
            c.setName(jsr.getName());
            c.setType(jsr.getType());
            c.setValue(jsr.getValue());
            c.setRuleId(rule.getId());
            return c;
        }
        catch (Exception e) {
            SerializerException.CREATE_OBJECT_FAILED.create((Object)"org.apache.jetspeed.profiler.rules.RuleCriterion", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    protected ProfilingRule recreateRule(Profiler profiler, ProfilingRule existingRule, JSProfilingRule jsp) throws SerializerException, ClassNotFoundException, ProfilerException {
        ProfilingRule rule = null;
        boolean existing = false;
        if (existingRule == null) {
            rule = profiler.getRule(jsp.getId());
            rule = jsp.isStandardRule() ? profiler.createProfilingRule(true) : profiler.createProfilingRule(false);
            rule.setId(jsp.getId());
        } else {
            rule = existingRule;
            existing = true;
        }
        rule.setTitle(jsp.getDescription());
        JSRuleCriterions col = jsp.getCriterions();
        Iterator _it = col.iterator();
        while (_it.hasNext()) {
            RuleCriterion c = this.recreateRuleCriterion(profiler, (JSRuleCriterion)_it.next(), rule);
            if (c == null) continue;
            Collection cHelp = rule.getRuleCriteria();
            if (existing && cHelp.contains(c)) continue;
            cHelp.add(c);
        }
        return rule;
    }

    private void exportProfilingRules(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        HashMap<String, JSProfilingRule> rulesMap = new HashMap<String, JSProfilingRule>();
        Class<?> standardRuleClass = null;
        try {
            ProfilingRule tempStandardRule = this.pm.createProfilingRule(true);
            standardRuleClass = tempStandardRule.getClass();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object[])new String[]{"Standard Rule", e.getMessage()}));
        }
        Iterator list = null;
        try {
            list = this.pm.getRules().iterator();
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.GET_EXISTING_OBJECTS.create((Object[])new String[]{"ProfilingRules", e.getMessage()}));
        }
        while (list.hasNext()) {
            try {
                ProfilingRule p = (ProfilingRule)list.next();
                if (rulesMap.containsKey(p.getId())) continue;
                JSProfilingRule rule = this.createProfilingRule(p, standardRuleClass == p.getClass());
                rulesMap.put(rule.getId(), rule);
                snapshot.getRules().add((Object)rule);
            }
            catch (Exception e) {
                throw new SerializerException(SerializerException.CREATE_SERIALIZED_OBJECT_FAILED.create((Object[])new String[]{"ProfilingRules", e.getMessage()}));
            }
        }
        ProfilingRule defaultRule = this.pm.getDefaultRule();
        if (defaultRule != null) {
            snapshot.setDefaultRule(defaultRule.getId());
        }
    }

    private void exportUserPrincipalRules(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        for (JSPrincipal _user : snapshot.getPrincipals()) {
            Principal principal;
            if (!"user".equals(_user.getType()) || (principal = _user.getPrincipal()) == null) continue;
            for (PrincipalRule p1 : this.pm.getRulesForPrincipal(principal)) {
                JSPrincipalRule pr = new JSPrincipalRule(p1.getLocatorName(), p1.getProfilingRule().getId());
                _user.getRules().add((Object)pr);
            }
        }
    }

    private JSProfilingRule createProfilingRule(ProfilingRule p, boolean standard) {
        JSProfilingRule rule = new JSProfilingRule();
        rule.setStandardRule(standard);
        rule.setDescription(p.getTitle());
        rule.setId(p.getId());
        Collection col = p.getRuleCriteria();
        for (RuleCriterion rc : col) {
            rule.getCriterions().add((Object)new JSRuleCriterion(rc));
        }
        return rule;
    }
}

