/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.profiler.rules.FallbackCriterionResolver;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.impl.StandardResolver;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityHelper;

public class PrincipalCriterionResolver
extends StandardResolver
implements FallbackCriterionResolver {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog((Class)PrincipalCriterionResolver.class);

    public String resolve(RequestContext context, RuleCriterion criterion) {
        String value = super.resolve(context, criterion);
        if (value != null) {
            return value;
        }
        Subject subject = context.getSubject();
        if (subject == null) {
            String msg = "Invalid (null) Subject in request pipeline";
            log.error((Object)msg);
            return null;
        }
        return this.resolvePrincipals(context, criterion, subject, criterion.getName());
    }

    public boolean isControl(RuleCriterion criterion) {
        return true;
    }

    protected String resolvePrincipals(RequestContext context, RuleCriterion criterion, Subject subject, String jptName) {
        StringBuffer result = new StringBuffer();
        Iterator principals = SecurityHelper.getPrincipals((Subject)subject, (String)jptName).iterator();
        int count = 0;
        while (principals.hasNext()) {
            Principal principal = (Principal)principals.next();
            if (count > 0) {
                result.append(",");
            }
            result.append(principal.getName());
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return result.toString();
    }

    protected String combinePrincipals(RequestContext context, RuleCriterion criterion, Subject subject, String jptName) {
        StringBuffer result = new StringBuffer();
        Iterator principals = SecurityHelper.getPrincipals((Subject)subject, (String)jptName).iterator();
        int count = 0;
        while (principals.hasNext()) {
            Principal principal = (Principal)principals.next();
            if (count > 0) {
                result.append("-");
            }
            result.append(principal.getName());
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return result.toString();
    }
}

