/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.psml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.cache.file.FileCache;
import org.apache.jetspeed.cache.file.FileCacheEntry;
import org.apache.jetspeed.cache.file.FileCacheEventListener;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.folder.psml.FolderImpl;
import org.apache.jetspeed.om.page.Document;
import org.apache.jetspeed.om.page.psml.AbstractBaseElement;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentHandler;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FailedToDeleteDocumentException;
import org.apache.jetspeed.page.document.FailedToUpdateDocumentException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.psml.AbstractNode;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.SAX2EventProducer;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CastorFileSystemDocumentHandler
implements DocumentHandler,
FileCacheEventListener {
    private static final Logger log = LoggerFactory.getLogger(CastorFileSystemDocumentHandler.class);
    private static final String PSML_DOCUMENT_ENCODING = "UTF-8";
    protected IdGenerator generator;
    protected String documentType;
    protected Class expectedReturnType;
    protected String documentRoot;
    protected File documentRootDir;
    protected FileCache fileCache;
    private OutputFormat format;
    private final XMLReader xmlReader;
    private DocumentHandlerFactory handlerFactory;
    private ClassDescriptorResolver classDescriptorResolver;

    public CastorFileSystemDocumentHandler(IdGenerator generator, String mappingFile, String documentType, Class expectedReturnType, String documentRoot, FileCache fileCache) throws FileNotFoundException, SAXException, ParserConfigurationException, MappingException {
        this.generator = generator;
        this.documentType = documentType;
        this.expectedReturnType = expectedReturnType;
        this.documentRoot = documentRoot;
        this.documentRootDir = new File(documentRoot);
        this.verifyPath(this.documentRootDir);
        this.fileCache = fileCache;
        this.fileCache.addListener((FileCacheEventListener)this);
        this.format = new OutputFormat("    ", true, PSML_DOCUMENT_ENCODING);
        this.format.setXHTML(true);
        this.format.setExpandEmptyElements(false);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        this.xmlReader = parser.getXMLReader();
        this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
        this.createCastorClassDescriptorResolver(mappingFile);
    }

    public CastorFileSystemDocumentHandler(IdGenerator generator, String mappingFile, String documentType, String expectedReturnType, String documentRoot, FileCache fileCache) throws FileNotFoundException, ClassNotFoundException, SAXException, ParserConfigurationException, MappingException {
        this(generator, mappingFile, documentType, Class.forName(expectedReturnType), documentRoot, fileCache);
    }

    public Document getDocument(String name) throws NodeException, DocumentNotFoundException {
        return this.getDocument(name, true);
    }

    public void updateDocument(Document document) throws FailedToUpdateDocumentException {
        this.updateDocument(document, false);
    }

    protected void updateDocument(Document document, boolean systemUpdate) throws FailedToUpdateDocumentException {
        if (document == null) {
            log.warn("Recieved null Document to update");
            return;
        }
        String path = document.getPath();
        if (path == null) {
            path = document.getId();
            if (path == null) {
                log.warn("Recieved Document with null path/id to update");
                return;
            }
            document.setPath(path);
        }
        AbstractBaseElement documentImpl = (AbstractBaseElement)document;
        documentImpl.setHandlerFactory(this.handlerFactory);
        String absolutePath = "";
        Writer writer = null;
        try {
            XMLWriter xmlWriter;
            if (systemUpdate) {
                documentImpl.setPermissionsEnabled(false);
                documentImpl.setConstraintsEnabled(false);
            } else {
                try {
                    document.checkAccess(JetspeedActions.EDIT);
                }
                catch (SecurityException se) {
                    throw new FailedToUpdateDocumentException("Insufficient Access: no edit access, cannot write.");
                }
                documentImpl.setPermissionsEnabled(false);
                documentImpl.setConstraintsEnabled(false);
            }
            documentImpl.marshalling();
            String fileName = path;
            if (!fileName.endsWith(this.documentType)) {
                fileName = path + this.documentType;
            }
            File f = new File(this.documentRootDir, fileName);
            absolutePath = f.getAbsolutePath();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), PSML_DOCUMENT_ENCODING);
            XMLWriter handler = xmlWriter = new XMLWriter(writer, this.format);
            Marshaller marshaller = new Marshaller(new ContentHandler((ContentHandler)handler){
                private int menuDepth = 0;
                final /* synthetic */ ContentHandler val$handler;
                {
                    this.val$handler = contentHandler;
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.val$handler.characters(ch, start, length);
                }

                public void endDocument() throws SAXException {
                    this.val$handler.endDocument();
                }

                public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    this.val$handler.ignorableWhitespace(ch, start, length);
                }

                public void processingInstruction(String target, String data) throws SAXException {
                    this.val$handler.processingInstruction(target, data);
                }

                public void setDocumentLocator(Locator locator) {
                    this.val$handler.setDocumentLocator(locator);
                }

                public void startDocument() throws SAXException {
                    this.val$handler.startDocument();
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals("menu")) {
                        --this.menuDepth;
                    }
                    if (!(this.menuDepth != 0 && qName.equals("menu-element") || qName.equals("fragment-element"))) {
                        this.val$handler.endElement(uri, localName, qName);
                    }
                }

                public void endPrefixMapping(String prefix) throws SAXException {
                }

                public void skippedEntity(String name) throws SAXException {
                    this.val$handler.skippedEntity(name);
                }

                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    if (!(this.menuDepth != 0 && qName.equals("menu-element") || qName.equals("fragment-element"))) {
                        this.val$handler.startElement(uri, localName, qName, atts);
                    }
                    if (qName.equals("menu")) {
                        ++this.menuDepth;
                    }
                }

                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                }
            });
            marshaller.setResolver((XMLClassDescriptorResolver)this.classDescriptorResolver);
            marshaller.setValidation(false);
            marshaller.marshal((Object)document);
        }
        catch (MarshalException e) {
            log.error("Could not marshal the file " + absolutePath, (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        catch (ValidationException e) {
            log.error("Document " + absolutePath + " is not valid", (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not save the file " + absolutePath, (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        catch (Exception e) {
            log.error("Error while saving  " + absolutePath, (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        finally {
            documentImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
            documentImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected void createCastorClassDescriptorResolver(String mappingFile) throws MappingException {
        Mapping mapping = null;
        try {
            InputStream stream = this.getClass().getResourceAsStream(mappingFile);
            if (log.isDebugEnabled()) {
                log.debug("Loading psml mapping file " + mappingFile);
            }
            mapping = new Mapping();
            InputSource is = new InputSource(stream);
            is.setSystemId(mappingFile);
            mapping.loadMapping(is);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Error in psml mapping creation");
            ise.initCause(e);
            throw ise;
        }
        this.classDescriptorResolver = ClassDescriptorResolverFactory.createClassDescriptorResolver((BindingType)BindingType.XML);
        MappingUnmarshaller mappingUnmarshaller = new MappingUnmarshaller();
        MappingLoader mappingLoader = mappingUnmarshaller.getMappingLoader(mapping, BindingType.XML);
        this.classDescriptorResolver.setMappingLoader(mappingLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshallDocument(Class clazz, String path, String extension) throws DocumentNotFoundException, DocumentException {
        Document document = null;
        File f = null;
        f = path.endsWith(extension) ? new File(this.documentRootDir, path) : new File(this.documentRootDir, path + extension);
        if (!f.exists()) {
            throw new PageNotFoundException("Document not found: " + path);
        }
        try {
            final InputSource readerInput = new InputSource(new InputStreamReader((InputStream)new FileInputStream(f), PSML_DOCUMENT_ENCODING));
            Unmarshaller unmarshaller = new Unmarshaller();
            unmarshaller.setResolver((XMLClassDescriptorResolver)this.classDescriptorResolver);
            unmarshaller.setValidation(false);
            XMLReader xMLReader = this.xmlReader;
            synchronized (xMLReader) {
                document = (Document)unmarshaller.unmarshal(new SAX2EventProducer(){

                    public void setContentHandler(final ContentHandler handler) {
                        CastorFileSystemDocumentHandler.this.xmlReader.setContentHandler(new ContentHandler(){
                            private int menuDepth = 0;

                            public void characters(char[] ch, int start, int length) throws SAXException {
                                handler.characters(ch, start, length);
                            }

                            public void endDocument() throws SAXException {
                                handler.endDocument();
                            }

                            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                                handler.ignorableWhitespace(ch, start, length);
                            }

                            public void processingInstruction(String target, String data) throws SAXException {
                                handler.processingInstruction(target, data);
                            }

                            public void setDocumentLocator(Locator locator) {
                                handler.setDocumentLocator(locator);
                            }

                            public void startDocument() throws SAXException {
                                handler.startDocument();
                            }

                            public void endElement(String uri, String localName, String qName) throws SAXException {
                                handler.endElement(uri, localName, qName);
                                if (qName.equals("menu")) {
                                    --this.menuDepth;
                                    if (this.menuDepth > 0) {
                                        handler.endElement(null, null, "menu-element");
                                    }
                                } else if (this.menuDepth > 0 && (qName.equals("options") || qName.equals("separator") || qName.equals("include") || qName.equals("exclude"))) {
                                    handler.endElement(null, null, "menu-element");
                                }
                                if (qName.equals("fragment") || qName.equals("fragment-reference") || qName.equals("page-fragment")) {
                                    handler.endElement(null, null, "fragment-element");
                                }
                            }

                            public void endPrefixMapping(String prefix) throws SAXException {
                            }

                            public void skippedEntity(String name) throws SAXException {
                                handler.skippedEntity(name);
                            }

                            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                                if (qName.equals("menu")) {
                                    if (this.menuDepth > 0) {
                                        handler.startElement(null, null, "menu-element", null);
                                    }
                                    ++this.menuDepth;
                                } else if (this.menuDepth > 0 && (qName.equals("options") || qName.equals("separator") || qName.equals("include") || qName.equals("exclude"))) {
                                    handler.startElement(null, null, "menu-element", null);
                                }
                                if (qName.equals("fragment") || qName.equals("fragment-reference") || qName.equals("page-fragment")) {
                                    handler.startElement(null, null, "fragment-element", null);
                                }
                                handler.startElement(null, null, qName, atts);
                            }

                            public void startPrefixMapping(String prefix, String uri) throws SAXException {
                            }
                        });
                    }

                    public void start() throws SAXException {
                        try {
                            CastorFileSystemDocumentHandler.this.xmlReader.parse(readerInput);
                        }
                        catch (IOException ioe) {
                            throw new SAXException(ioe);
                        }
                    }
                });
            }
            document.setPath(path);
            AbstractBaseElement documentImpl = (AbstractBaseElement)document;
            documentImpl.setHandlerFactory(this.handlerFactory);
            documentImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
            documentImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
            boolean dirty = documentImpl.unmarshalled(this.generator);
            if (dirty || document.isDirty()) {
                this.updateDocument(document, true);
                document.setDirty(false);
            }
        }
        catch (IOException e) {
            log.error("Could not load the file " + f.getAbsolutePath(), (Throwable)e);
            throw new PageNotFoundException("Could not load the file " + f.getAbsolutePath(), (Throwable)e);
        }
        catch (MarshalException e) {
            log.error("Could not unmarshal the file " + f.getAbsolutePath(), (Throwable)e);
            throw new PageNotFoundException("Could not unmarshal the file " + f.getAbsolutePath(), (Throwable)e);
        }
        catch (ValidationException e) {
            log.error("Document " + f.getAbsolutePath() + " is not valid", (Throwable)e);
            throw new DocumentNotFoundException("Document " + f.getAbsolutePath() + " is not valid", (Throwable)e);
        }
        if (document == null) {
            throw new DocumentNotFoundException("Document not found: " + path);
        }
        if (!clazz.isAssignableFrom(document.getClass())) {
            throw new ClassCastException(document.getClass().getName() + " must implement or extend " + clazz.getName());
        }
        return document;
    }

    protected void verifyPath(File path) throws FileNotFoundException {
        if (path == null) {
            throw new IllegalArgumentException("Page root cannot be null");
        }
        if (!path.exists()) {
            throw new FileNotFoundException("Could not locate root pages path " + path.getAbsolutePath());
        }
    }

    public void removeDocument(Document document) throws DocumentNotFoundException, FailedToDeleteDocumentException {
        File file;
        if (document == null) {
            log.warn("Recieved null Document to remove");
            return;
        }
        String path = document.getPath();
        if (path == null && (path = document.getId()) == null) {
            log.warn("Recieved Document with null path/id to remove");
            return;
        }
        String fileName = path;
        if (!fileName.endsWith(this.documentType)) {
            fileName = path + this.documentType;
        }
        if (!(file = new File(this.documentRootDir, fileName)).delete()) {
            throw new FailedToDeleteDocumentException(file.getAbsolutePath() + " document cannot be deleted.");
        }
        this.fileCache.remove(path);
        AbstractNode documentImpl = (AbstractNode)document;
        documentImpl.setParent(null);
    }

    public Document getDocument(String name, boolean fromCache) throws DocumentNotFoundException, NodeException {
        Document document = null;
        if (fromCache) {
            Object obj = this.fileCache.getDocument(name);
            document = (Document)obj;
            if (document == null) {
                document = (Document)this.unmarshallDocument(this.expectedReturnType, name, this.documentType);
                this.addToCache(name, document);
            }
        } else {
            document = (Document)this.unmarshallDocument(this.expectedReturnType, name, this.documentType);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToCache(String path, Object objectToCache) {
        FileCache fileCache = this.fileCache;
        synchronized (fileCache) {
            try {
                this.fileCache.put(path, objectToCache, this.documentRootDir);
            }
            catch (IOException e) {
                log.error("Error putting document: " + e);
                IllegalStateException ise = new IllegalStateException("Error storing Document in the FileCache: " + e.toString());
                ise.initCause(e);
            }
        }
    }

    public void refresh(FileCacheEntry entry) throws Exception {
        Document document;
        Node parent;
        log.debug("Entry is refreshing: " + entry.getFile().getName());
        if (entry.getDocument() instanceof Document && ((Document)entry.getDocument()).getPath().endsWith(this.documentType) && (parent = ((AbstractNode)(document = (Document)entry.getDocument())).getParent(false)) instanceof FolderImpl) {
            Document freshDoc = this.getDocument(document.getPath(), false);
            freshDoc.setParent(parent);
            ((FolderImpl)parent).getAllNodes().add((Node)freshDoc);
            freshDoc.setPath(document.getPath());
            entry.setDocument((Object)freshDoc);
        }
    }

    public void evict(FileCacheEntry entry) throws Exception {
    }

    public String getType() {
        return this.documentType;
    }

    public DocumentHandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public void setHandlerFactory(DocumentHandlerFactory factory) {
        this.handlerFactory = factory;
    }

    public void shutdown() {
        this.fileCache.removeListener((FileCacheEventListener)this);
    }
}

