/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentValidationListener;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.psml.AbstractBaseFragmentElement;
import org.apache.jetspeed.om.page.psml.DocumentImpl;
import org.apache.jetspeed.om.page.psml.FragmentElementImpl;

public abstract class AbstractBaseFragmentsElement
extends DocumentImpl
implements BaseFragmentsElement {
    private static final long serialVersionUID = 1L;
    private BaseFragmentElement root = null;
    private FragmentElementImpl rootFragmentElementImpl = null;
    private int hashCode;

    public void setId(String id) {
        this.hashCode = (this.getClass().getName() + ":" + id).hashCode();
        super.setId(id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseFragmentsElement) {
            BaseFragmentsElement fragmentsElement = (BaseFragmentsElement)obj;
            return fragmentsElement.getId() != null && this.getId() != null && this.getId().equals(fragmentsElement.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public BaseFragmentElement getRootFragment() {
        return this.root;
    }

    public void setRootFragment(BaseFragmentElement root) {
        this.root = root;
        if (root instanceof AbstractBaseFragmentElement) {
            ((AbstractBaseFragmentElement)root).setBaseFragmentsElement(this);
        }
    }

    public FragmentElementImpl getRootFragmentElementImpl() {
        return this.rootFragmentElementImpl;
    }

    public void setRootFragmentElementImpl(FragmentElementImpl element) {
        this.rootFragmentElementImpl = element;
    }

    public BaseFragmentElement getFragmentById(String id) {
        Stack<Object> stack = new Stack<Object>();
        if (this.getRootFragment() != null) {
            stack.push(this.getRootFragment());
        }
        BaseFragmentElement f = (BaseFragmentElement)stack.pop();
        while (f != null && !f.getId().equals(id)) {
            if (f instanceof Fragment) {
                Iterator i = ((Fragment)f).getFragments().iterator();
                while (i.hasNext()) {
                    stack.push(i.next());
                }
            }
            if (stack.size() > 0) {
                f = (BaseFragmentElement)stack.pop();
                continue;
            }
            f = null;
        }
        return f;
    }

    public BaseFragmentElement removeFragmentById(String id) {
        HashMap<BaseFragmentElement, BaseFragmentElement> parents = new HashMap<BaseFragmentElement, BaseFragmentElement>();
        Stack<BaseFragmentElement> stack = new Stack<BaseFragmentElement>();
        if (this.getRootFragment() != null) {
            stack.push(this.getRootFragment());
        }
        BaseFragmentElement f = (BaseFragmentElement)stack.pop();
        while (f != null && !f.getId().equals(id)) {
            if (f instanceof Fragment) {
                for (BaseFragmentElement child : ((Fragment)f).getFragments()) {
                    stack.push(child);
                    parents.put(child, f);
                }
            }
            if (stack.size() > 0) {
                f = (BaseFragmentElement)stack.pop();
                continue;
            }
            f = null;
        }
        if (f != null) {
            BaseFragmentElement parent = (BaseFragmentElement)parents.get(f);
            if (parent != null) {
                if (parent instanceof Fragment && ((Fragment)parent).getFragments().remove(f)) {
                    return f;
                }
            } else if (f == this.root) {
                this.root = null;
                return f;
            }
        }
        return null;
    }

    public List getFragmentsByName(String name) {
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        Stack<Object> stack = new Stack<Object>();
        if (this.getRootFragment() != null) {
            stack.push(this.getRootFragment());
        }
        BaseFragmentElement f = (BaseFragmentElement)stack.pop();
        while (f != null) {
            if (f instanceof Fragment) {
                Fragment fragment = (Fragment)f;
                if (fragment.getName() != null && fragment.getName().equals(name)) {
                    fragments.add(fragment);
                }
                Iterator i = fragment.getFragments().iterator();
                while (i.hasNext()) {
                    stack.push(i.next());
                }
            }
            if (stack.size() > 0) {
                f = (BaseFragmentElement)stack.pop();
                continue;
            }
            f = null;
        }
        return fragments;
    }

    public List getFragmentsByInterface(Class interfaceFilter) {
        BaseFragmentElement f;
        ArrayList<BaseFragmentElement> fragments = new ArrayList<BaseFragmentElement>();
        Stack<Object> stack = new Stack<Object>();
        if (this.getRootFragment() != null) {
            stack.push(this.getRootFragment());
        }
        BaseFragmentElement baseFragmentElement = f = stack.isEmpty() ? null : (BaseFragmentElement)stack.pop();
        while (f != null) {
            if (interfaceFilter == null || interfaceFilter.isInstance(f)) {
                fragments.add(f);
            }
            if (f instanceof Fragment) {
                Fragment fragment = (Fragment)f;
                Iterator i = fragment.getFragments().iterator();
                while (i.hasNext()) {
                    stack.push(i.next());
                }
            }
            f = stack.isEmpty() ? null : (BaseFragmentElement)stack.pop();
        }
        return fragments;
    }

    public boolean unmarshalled(IdGenerator generator) {
        boolean dirty = super.unmarshalled(generator);
        this.root = (AbstractBaseFragmentElement)(this.rootFragmentElementImpl != null ? this.rootFragmentElementImpl.getElement() : null);
        if (this.root != null) {
            AbstractBaseFragmentElement rootFragment = (AbstractBaseFragmentElement)this.root;
            dirty = rootFragment.unmarshalled(generator) || dirty;
            rootFragment.setBaseFragmentsElement(this);
        }
        return dirty;
    }

    public void marshalling() {
        FragmentElementImpl fragmentElementImpl = this.rootFragmentElementImpl = this.root != null ? new FragmentElementImpl(this.root) : null;
        if (this.root != null) {
            ((AbstractBaseFragmentElement)this.root).marshalling();
        }
        super.marshalling();
    }

    public boolean validateFragments() {
        AbstractBaseFragmentElement rootFragment = (AbstractBaseFragmentElement)this.getRootFragment();
        if (rootFragment != null) {
            BaseFragmentValidationListener validationListener = this.newBaseFragmentValidationListener();
            return rootFragment.validateFragments(validationListener) && validationListener.validate();
        }
        return false;
    }

    protected abstract BaseFragmentValidationListener newBaseFragmentValidationListener();
}

