/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import java.util.List;
import org.apache.jetspeed.om.page.impl.BaseFragmentElementImpl;
import org.apache.jetspeed.om.page.impl.FragmentPreferenceImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

class FragmentPreferenceList
extends AbstractList {
    private BaseFragmentElementImpl fragment;
    private List removedPreferences;

    FragmentPreferenceList(BaseFragmentElementImpl fragment) {
        this.fragment = fragment;
    }

    private FragmentPreferenceImpl validatePreferenceForAdd(FragmentPreferenceImpl preference) {
        int removedIndex;
        if (preference == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.fragment.accessPreferences().contains(preference)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + preference.getName());
        }
        if (this.removedPreferences != null && (removedIndex = this.removedPreferences.indexOf(preference)) >= 0) {
            FragmentPreferenceImpl addPreference = preference;
            preference = (FragmentPreferenceImpl)this.removedPreferences.remove(removedIndex);
            preference.setReadOnly(addPreference.isReadOnly());
            preference.setValueList(addPreference.getValueList());
        }
        return preference;
    }

    private List getRemovedPreferences() {
        if (this.removedPreferences == null) {
            this.removedPreferences = DatabasePageManagerUtils.createList();
        }
        return this.removedPreferences;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.fragment.accessPreferences().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        FragmentPreferenceImpl preference = this.validatePreferenceForAdd((FragmentPreferenceImpl)element);
        this.fragment.accessPreferences().add(index, preference);
    }

    public Object get(int index) {
        return this.fragment.accessPreferences().get(index);
    }

    public Object remove(int index) {
        FragmentPreferenceImpl removed = (FragmentPreferenceImpl)this.fragment.accessPreferences().remove(index);
        if (removed != null) {
            this.getRemovedPreferences().add(removed);
        }
        return removed;
    }

    public Object set(int index, Object element) {
        FragmentPreferenceImpl newPreference = this.validatePreferenceForAdd((FragmentPreferenceImpl)element);
        FragmentPreferenceImpl preference = this.fragment.accessPreferences().set(index, newPreference);
        this.getRemovedPreferences().add(preference);
        return preference;
    }

    public int size() {
        return this.fragment.accessPreferences().size();
    }
}

