/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerEventListener;
import org.apache.jetspeed.page.PageManagerUtils;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageManager
implements PageManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractPageManager.class);
    private static final String FOLDER_NODE_TYPE = "folder";
    private static final String PAGE_NODE_TYPE = "page";
    private static final String FRAGMENT_NODE_TYPE = "fragment";
    private static final String LINK_NODE_TYPE = "link";
    protected Class fragmentClass;
    protected Class pageClass;
    protected Class folderClass;
    protected Class linkClass;
    protected Class pageSecurityClass;
    protected Class propertyClass;
    protected Class folderMenuDefinitionClass;
    protected Class folderMenuExcludeDefinitionClass;
    protected Class folderMenuIncludeDefinitionClass;
    protected Class folderMenuOptionsDefinitionClass;
    protected Class folderMenuSeparatorDefinitionClass;
    protected Class pageMenuDefinitionClass;
    protected Class pageMenuExcludeDefinitionClass;
    protected Class pageMenuIncludeDefinitionClass;
    protected Class pageMenuOptionsDefinitionClass;
    protected Class pageMenuSeparatorDefinitionClass;
    protected Class securityConstraintsClass;
    protected Class folderSecurityConstraintClass;
    protected Class pageSecurityConstraintClass;
    protected Class fragmentSecurityConstraintClass;
    protected Class linkSecurityConstraintClass;
    protected Class pageSecuritySecurityConstraintClass;
    protected Class securityConstraintsDefClass;
    protected Class fragmentPreferenceClass;
    private boolean permissionsEnabled;
    private boolean constraintsEnabled;
    private List listeners = new LinkedList();

    public AbstractPageManager(boolean permissionsEnabled, boolean constraintsEnabled) {
        this.permissionsEnabled = permissionsEnabled;
        this.constraintsEnabled = constraintsEnabled;
    }

    public AbstractPageManager(boolean permissionsEnabled, boolean constraintsEnabled, Map modelClasses) {
        this(permissionsEnabled, constraintsEnabled);
        this.fragmentClass = (Class)modelClasses.get("FragmentImpl");
        this.pageClass = (Class)modelClasses.get("PageImpl");
        this.folderClass = (Class)modelClasses.get("FolderImpl");
        this.linkClass = (Class)modelClasses.get("LinkImpl");
        this.pageSecurityClass = (Class)modelClasses.get("PageSecurityImpl");
        this.folderMenuDefinitionClass = (Class)modelClasses.get("FolderMenuDefinitionImpl");
        this.folderMenuExcludeDefinitionClass = (Class)modelClasses.get("FolderMenuExcludeDefinitionImpl");
        this.folderMenuIncludeDefinitionClass = (Class)modelClasses.get("FolderMenuIncludeDefinitionImpl");
        this.folderMenuOptionsDefinitionClass = (Class)modelClasses.get("FolderMenuOptionsDefinitionImpl");
        this.folderMenuSeparatorDefinitionClass = (Class)modelClasses.get("FolderMenuSeparatorDefinitionImpl");
        this.pageMenuDefinitionClass = (Class)modelClasses.get("PageMenuDefinitionImpl");
        this.pageMenuExcludeDefinitionClass = (Class)modelClasses.get("PageMenuExcludeDefinitionImpl");
        this.pageMenuIncludeDefinitionClass = (Class)modelClasses.get("PageMenuIncludeDefinitionImpl");
        this.pageMenuOptionsDefinitionClass = (Class)modelClasses.get("PageMenuOptionsDefinitionImpl");
        this.pageMenuSeparatorDefinitionClass = (Class)modelClasses.get("PageMenuSeparatorDefinitionImpl");
        this.securityConstraintsClass = (Class)modelClasses.get("SecurityConstraintsImpl");
        this.folderSecurityConstraintClass = (Class)modelClasses.get("FolderSecurityConstraintImpl");
        this.pageSecurityConstraintClass = (Class)modelClasses.get("PageSecurityConstraintImpl");
        this.fragmentSecurityConstraintClass = (Class)modelClasses.get("FragmentSecurityConstraintImpl");
        this.linkSecurityConstraintClass = (Class)modelClasses.get("LinkSecurityConstraintImpl");
        this.pageSecuritySecurityConstraintClass = (Class)modelClasses.get("PageSecuritySecurityConstraintImpl");
        this.securityConstraintsDefClass = (Class)modelClasses.get("SecurityConstraintsDefImpl");
        this.fragmentPreferenceClass = (Class)modelClasses.get("FragmentPreferenceImpl");
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public Page newPage(String path) {
        Page page = null;
        try {
            page = (Page)this.createObject(this.pageClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".psml")) {
                path = path + ".psml";
            }
            page.setPath(path);
            page.setRootFragment(this.newFragment());
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error(message, (Throwable)e);
        }
        return page;
    }

    public Folder newFolder(String path) {
        Folder folder = null;
        try {
            folder = (Folder)this.createObject(this.folderClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            folder.setPath(path);
        }
        catch (ClassCastException e) {
            String message = "Failed to create link object for " + this.linkClass;
            log.error(message, (Throwable)e);
        }
        return folder;
    }

    public Link newLink(String path) {
        Link link = null;
        try {
            link = (Link)this.createObject(this.linkClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".link")) {
                path = path + ".link";
            }
            link.setPath(path);
        }
        catch (ClassCastException e) {
            String message = "Failed to create link object for " + this.linkClass;
            log.error(message, (Throwable)e);
        }
        return link;
    }

    public PageSecurity newPageSecurity() {
        PageSecurity pageSecurity = null;
        try {
            pageSecurity = (PageSecurity)this.createObject(this.pageSecurityClass);
            pageSecurity.setPath("/page.security");
        }
        catch (ClassCastException e) {
            String message = "Failed to create page security object for " + this.pageClass;
            log.error(message, (Throwable)e);
        }
        return pageSecurity;
    }

    public Fragment newFragment() {
        Fragment fragment = null;
        try {
            fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setType("layout");
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error(message, (Throwable)e);
        }
        return fragment;
    }

    public Fragment newPortletFragment() {
        Fragment fragment = null;
        try {
            fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setType("portlet");
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error(message, (Throwable)e);
        }
        return fragment;
    }

    public MenuDefinition newFolderMenuDefinition() {
        try {
            return (MenuDefinition)this.createObject(this.folderMenuDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu definition object for " + this.folderMenuDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuExcludeDefinition newFolderMenuExcludeDefinition() {
        try {
            return (MenuExcludeDefinition)this.createObject(this.folderMenuExcludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu exclude definition object for " + this.folderMenuExcludeDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuIncludeDefinition newFolderMenuIncludeDefinition() {
        try {
            return (MenuIncludeDefinition)this.createObject(this.folderMenuIncludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu include definition object for " + this.folderMenuIncludeDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuOptionsDefinition newFolderMenuOptionsDefinition() {
        try {
            return (MenuOptionsDefinition)this.createObject(this.folderMenuOptionsDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu options definition object for " + this.folderMenuOptionsDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuSeparatorDefinition newFolderMenuSeparatorDefinition() {
        try {
            return (MenuSeparatorDefinition)this.createObject(this.folderMenuSeparatorDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu separator definition object for " + this.folderMenuSeparatorDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuDefinition newPageMenuDefinition() {
        try {
            return (MenuDefinition)this.createObject(this.pageMenuDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu definition object for " + this.pageMenuDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuExcludeDefinition newPageMenuExcludeDefinition() {
        try {
            return (MenuExcludeDefinition)this.createObject(this.pageMenuExcludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu exclude definition object for " + this.pageMenuExcludeDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuIncludeDefinition newPageMenuIncludeDefinition() {
        try {
            return (MenuIncludeDefinition)this.createObject(this.pageMenuIncludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu include definition object for " + this.pageMenuIncludeDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuOptionsDefinition newPageMenuOptionsDefinition() {
        try {
            return (MenuOptionsDefinition)this.createObject(this.pageMenuOptionsDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu options definition object for " + this.pageMenuOptionsDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuSeparatorDefinition newPageMenuSeparatorDefinition() {
        try {
            return (MenuSeparatorDefinition)this.createObject(this.pageMenuSeparatorDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu separator definition object for " + this.pageMenuSeparatorDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraints newSecurityConstraints() {
        try {
            return (SecurityConstraints)this.createObject(this.securityConstraintsClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.securityConstraintsClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newFolderSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.folderSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.folderSecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newPageSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.pageSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.pageSecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newFragmentSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.fragmentSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.fragmentSecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newLinkSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.linkSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.linkSecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newPageSecuritySecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.pageSecuritySecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.pageSecuritySecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraintsDef newSecurityConstraintsDef() {
        try {
            return (SecurityConstraintsDef)this.createObject(this.securityConstraintsDefClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.securityConstraintsDefClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public FragmentPreference newFragmentPreference() {
        try {
            return (FragmentPreference)this.createObject(this.fragmentPreferenceClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.fragmentPreferenceClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    private Object createObject(Class classe) {
        Object object = null;
        try {
            object = classe.newInstance();
        }
        catch (Exception e) {
            log.error("Factory failed to create object: " + classe.getName(), (Throwable)e);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PageManagerEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PageManagerEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void reset() {
    }

    public void shutdown() {
    }

    public boolean isDistributed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewNode(Node node) {
        ArrayList listenersList = null;
        List list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList(this.listeners);
        }
        for (PageManagerEventListener listener : listenersList) {
            try {
                listener.newNode(node);
            }
            catch (Exception e) {
                log.error("Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdatedNode(Node node) {
        ArrayList listenersList = null;
        List list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList(this.listeners);
        }
        for (PageManagerEventListener listener : listenersList) {
            try {
                listener.updatedNode(node);
            }
            catch (Exception e) {
                log.error("Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemovedNode(Node node) {
        ArrayList listenersList = null;
        List list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList(this.listeners);
        }
        for (PageManagerEventListener listener : listenersList) {
            try {
                listener.removedNode(node);
            }
            catch (Exception e) {
                log.error("Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    public Folder copyFolder(Folder source, String path) throws NodeException {
        Folder folder = this.newFolder(path);
        folder.setDefaultPage(source.getDefaultPage());
        folder.setShortTitle(source.getShortTitle());
        folder.setTitle(source.getTitle());
        folder.setHidden(source.isHidden());
        folder.setDefaultDecorator(source.getDefaultDecorator("layout"), "layout");
        folder.setDefaultDecorator(source.getDefaultDecorator("portlet"), "portlet");
        folder.setSkin(source.getSkin());
        folder.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(FOLDER_NODE_TYPE, srcSecurity);
            folder.setSecurityConstraints(copiedSecurity);
        }
        folder.setDocumentOrder(DatabasePageManagerUtils.createList());
        for (String name : source.getDocumentOrder()) {
            folder.getDocumentOrder().add(name);
        }
        List menus = source.getMenuDefinitions();
        if (menus != null) {
            List copiedMenus = this.copyMenuDefinitions(FOLDER_NODE_TYPE, menus);
            folder.setMenuDefinitions(copiedMenus);
        }
        return folder;
    }

    public Page copyPage(Page source, String path) throws NodeException {
        List menus;
        Page page = this.newPage(path);
        page.setTitle(source.getTitle());
        page.setShortTitle(source.getShortTitle());
        page.setVersion(source.getVersion());
        page.setDefaultDecorator(source.getDefaultDecorator("layout"), "layout");
        page.setDefaultDecorator(source.getDefaultDecorator("portlet"), "portlet");
        page.setSkin(source.getSkin());
        page.setHidden(source.isHidden());
        page.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(PAGE_NODE_TYPE, srcSecurity);
            page.setSecurityConstraints(copiedSecurity);
        }
        if ((menus = source.getMenuDefinitions()) != null) {
            List copiedMenus = this.copyMenuDefinitions(PAGE_NODE_TYPE, menus);
            page.setMenuDefinitions(copiedMenus);
        }
        Fragment root = this.copyFragment(source.getRootFragment(), source.getRootFragment().getName());
        page.setRootFragment(root);
        return page;
    }

    public Fragment copyFragment(Fragment source, String name) throws NodeException {
        Fragment copy = this.newFragment();
        copy.setDecorator(source.getDecorator());
        copy.setName(name);
        copy.setShortTitle(source.getShortTitle());
        copy.setSkin(source.getSkin());
        copy.setTitle(source.getTitle());
        copy.setType(source.getType());
        copy.setState(source.getState());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(FRAGMENT_NODE_TYPE, srcSecurity);
            copy.setSecurityConstraints(copiedSecurity);
        }
        for (Map.Entry prop : source.getProperties().entrySet()) {
            copy.getProperties().put(prop.getKey(), prop.getValue());
        }
        copy.setPreferences(DatabasePageManagerUtils.createList());
        for (FragmentPreference pref : source.getPreferences()) {
            FragmentPreference newPref = this.newFragmentPreference();
            newPref.setName(pref.getName());
            newPref.setReadOnly(pref.isReadOnly());
            newPref.setValueList(DatabasePageManagerUtils.createList());
            for (String value : pref.getValueList()) {
                newPref.getValueList().add(value);
            }
            copy.getPreferences().add(newPref);
        }
        for (Fragment fragment : source.getFragments()) {
            Fragment copiedFragment = this.copyFragment(fragment, fragment.getName());
            copy.getFragments().add(copiedFragment);
        }
        return copy;
    }

    public Link copyLink(Link source, String path) throws NodeException {
        Link link = this.newLink(path);
        link.setTitle(source.getTitle());
        link.setShortTitle(source.getShortTitle());
        link.setSkin(source.getSkin());
        link.setVersion(source.getVersion());
        link.setTarget(source.getTarget());
        link.setUrl(source.getUrl());
        link.setHidden(source.isHidden());
        link.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(LINK_NODE_TYPE, srcSecurity);
            link.setSecurityConstraints(copiedSecurity);
        }
        return link;
    }

    public PageSecurity copyPageSecurity(PageSecurity source) throws NodeException {
        PageSecurity copy = this.newPageSecurity();
        copy.setPath(source.getPath());
        copy.setVersion(source.getVersion());
        copy.setSecurityConstraintsDefs(DatabasePageManagerUtils.createList());
        for (SecurityConstraintsDef def : source.getSecurityConstraintsDefs()) {
            SecurityConstraintsDef defCopy = this.newSecurityConstraintsDef();
            defCopy.setName(def.getName());
            List copiedConstraints = DatabasePageManagerUtils.createList();
            for (SecurityConstraint srcConstraint : def.getSecurityConstraints()) {
                SecurityConstraint dstConstraint = this.newPageSecuritySecurityConstraint();
                this.copyConstraint(srcConstraint, dstConstraint);
                copiedConstraints.add(dstConstraint);
            }
            defCopy.setSecurityConstraints(copiedConstraints);
            copy.getSecurityConstraintsDefs().add(defCopy);
        }
        copy.setGlobalSecurityConstraintsRefs(DatabasePageManagerUtils.createList());
        for (String global : source.getGlobalSecurityConstraintsRefs()) {
            copy.getGlobalSecurityConstraintsRefs().add(global);
        }
        return copy;
    }

    protected List copyMenuDefinitions(String type, List srcMenus) {
        List copiedMenus = DatabasePageManagerUtils.createList();
        for (MenuDefinition srcMenu : srcMenus) {
            MenuDefinition copiedMenu = (MenuDefinition)this.copyMenuElement(type, srcMenu);
            if (copiedMenu == null) continue;
            copiedMenus.add(copiedMenu);
        }
        return copiedMenus;
    }

    protected Object copyMenuElement(String type, Object srcElement) {
        if (srcElement instanceof MenuDefinition) {
            MenuDefinition source = (MenuDefinition)srcElement;
            MenuDefinition menu = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menu = this.newPageMenuDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menu = this.newFolderMenuDefinition();
            }
            menu.setDepth(source.getDepth());
            menu.setName(source.getName());
            menu.setOptions(source.getOptions());
            menu.setOrder(source.getOrder());
            menu.setPaths(source.isPaths());
            menu.setProfile(source.getProfile());
            menu.setRegexp(source.isRegexp());
            menu.setShortTitle(source.getShortTitle());
            menu.setSkin(source.getSkin());
            menu.setTitle(source.getTitle());
            menu.getMetadata().copyFields(source.getMetadata().getFields());
            List elements = source.getMenuElements();
            if (elements != null) {
                List copiedElements = DatabasePageManagerUtils.createList();
                for (Object element : elements) {
                    Object copiedElement = this.copyMenuElement(type, element);
                    if (copiedElement == null) continue;
                    copiedElements.add(copiedElement);
                }
                menu.setMenuElements(copiedElements);
            }
            return menu;
        }
        if (srcElement instanceof MenuExcludeDefinition) {
            MenuExcludeDefinition source = (MenuExcludeDefinition)srcElement;
            MenuExcludeDefinition menuExclude = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuExclude = this.newPageMenuExcludeDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuExclude = this.newFolderMenuExcludeDefinition();
            }
            menuExclude.setName(source.getName());
            return menuExclude;
        }
        if (srcElement instanceof MenuIncludeDefinition) {
            MenuIncludeDefinition source = (MenuIncludeDefinition)srcElement;
            MenuIncludeDefinition menuInclude = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuInclude = this.newPageMenuIncludeDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuInclude = this.newFolderMenuIncludeDefinition();
            }
            menuInclude.setName(source.getName());
            menuInclude.setNest(source.isNest());
            return menuInclude;
        }
        if (srcElement instanceof MenuOptionsDefinition) {
            MenuOptionsDefinition source = (MenuOptionsDefinition)srcElement;
            MenuOptionsDefinition menuOptions = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuOptions = this.newPageMenuOptionsDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuOptions = this.newFolderMenuOptionsDefinition();
            }
            menuOptions.setDepth(source.getDepth());
            menuOptions.setOptions(source.getOptions());
            menuOptions.setOrder(source.getOrder());
            menuOptions.setPaths(source.isPaths());
            menuOptions.setProfile(source.getProfile());
            menuOptions.setRegexp(source.isRegexp());
            menuOptions.setSkin(source.getSkin());
            return menuOptions;
        }
        if (srcElement instanceof MenuSeparatorDefinition) {
            MenuSeparatorDefinition source = (MenuSeparatorDefinition)srcElement;
            MenuSeparatorDefinition menuSeparator = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuSeparator = this.newPageMenuSeparatorDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuSeparator = this.newFolderMenuSeparatorDefinition();
            }
            menuSeparator.setSkin(source.getSkin());
            menuSeparator.setTitle(source.getTitle());
            menuSeparator.setText(source.getText());
            menuSeparator.getMetadata().copyFields(source.getMetadata().getFields());
            return menuSeparator;
        }
        return null;
    }

    protected void copyConstraint(SecurityConstraint srcConstraint, SecurityConstraint dstConstraint) {
        dstConstraint.setUsers(srcConstraint.getUsers());
        dstConstraint.setRoles(srcConstraint.getRoles());
        dstConstraint.setGroups(srcConstraint.getGroups());
        dstConstraint.setPermissions(srcConstraint.getPermissions());
    }

    protected SecurityConstraints copySecurityConstraints(String type, SecurityConstraints source) {
        SecurityConstraints security = this.newSecurityConstraints();
        if (source.getOwner() != null) {
            security.setOwner(source.getOwner());
        }
        if (source.getSecurityConstraints() != null) {
            List copiedConstraints = DatabasePageManagerUtils.createList();
            for (SecurityConstraint srcConstraint : source.getSecurityConstraints()) {
                SecurityConstraint dstConstraint = null;
                if (type.equals(PAGE_NODE_TYPE)) {
                    dstConstraint = this.newPageSecurityConstraint();
                } else if (type.equals(FOLDER_NODE_TYPE)) {
                    dstConstraint = this.newFolderSecurityConstraint();
                } else if (type.equals(LINK_NODE_TYPE)) {
                    dstConstraint = this.newLinkSecurityConstraint();
                } else if (type.equals(FRAGMENT_NODE_TYPE)) {
                    dstConstraint = this.newFragmentSecurityConstraint();
                }
                this.copyConstraint(srcConstraint, dstConstraint);
                copiedConstraints.add(dstConstraint);
            }
            security.setSecurityConstraints(copiedConstraints);
        }
        if (source.getSecurityConstraintsRefs() != null) {
            List copiedRefs = DatabasePageManagerUtils.createList();
            for (String constraintsRef : source.getSecurityConstraintsRefs()) {
                copiedRefs.add(constraintsRef);
            }
            security.setSecurityConstraintsRefs(copiedRefs);
        }
        return security;
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException {
        PageManagerUtils.deepCopyFolder(this, srcFolder, destinationPath, owner);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException {
        PageManagerUtils.deepMergeFolder(this, srcFolder, destinationPath, owner);
    }

    public Page getUserPage(String userName, String pageName) throws PageNotFoundException, NodeException {
        return this.getPage("/_user/" + userName + "/" + pageName);
    }

    public Folder getUserFolder(String userName) throws FolderNotFoundException, InvalidFolderException, NodeException {
        return this.getFolder("/_user/" + userName);
    }

    public boolean folderExists(String folderName) {
        try {
            this.getFolder(folderName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean pageExists(String pageName) {
        try {
            this.getPage(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean linkExists(String linkName) {
        try {
            this.getLink(linkName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userFolderExists(String userName) {
        try {
            this.getFolder("/_user/" + userName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userPageExists(String userName, String pageName) {
        try {
            this.getPage("/_user/" + userName + "/" + pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void createUserHomePagesFromRoles(Subject subject) throws NodeException {
        PageManagerUtils.createUserHomePagesFromRoles(this, subject);
    }
}

