/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.om.page.impl.FragmentImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

class FragmentPropertyMap
extends AbstractMap {
    private FragmentImpl fragment;
    private FragmentPropertiesEntrySet entrySet;

    FragmentPropertyMap(FragmentImpl fragment) {
        this.fragment = fragment;
        this.entrySet = new FragmentPropertiesEntrySet();
        for (String key : fragment.getPropertyMemberKeys()) {
            this.entrySet.add(new FragmentPropertiesEntry(key, fragment.getPropertyMember(key)));
        }
    }

    public Object put(Object key, Object value) {
        FragmentPropertiesEntry entry = new FragmentPropertiesEntry(key, value);
        for (FragmentPropertiesEntry testEntry : this.entrySet) {
            if (!testEntry.equals(entry)) continue;
            Object oldValue = testEntry.getValue();
            testEntry.setValue(entry.getValue());
            return oldValue;
        }
        this.entrySet.add(entry);
        return null;
    }

    public Set entrySet() {
        return this.entrySet;
    }

    private class FragmentPropertiesEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public FragmentPropertiesEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            FragmentPropertyMap.this.fragment.setPropertyMember(this.key.toString(), newValue.toString());
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (o instanceof FragmentPropertiesEntry) {
                if (this.key != null) {
                    return this.key.equals(((FragmentPropertiesEntry)o).getKey());
                }
                return ((FragmentPropertiesEntry)o).getKey() == null;
            }
            return false;
        }

        public int hashCode() {
            if (this.key != null) {
                return this.key.hashCode();
            }
            return 0;
        }
    }

    private class FragmentPropertiesEntrySet
    extends AbstractSet {
        private Collection entries = DatabasePageManagerUtils.createCollection();

        private FragmentPropertiesEntrySet() {
        }

        public boolean add(Object o) {
            FragmentPropertiesEntry entry = (FragmentPropertiesEntry)o;
            if (!this.entries.contains(entry)) {
                FragmentPropertyMap.this.fragment.setPropertyMember(entry.getKey().toString(), entry.getValue().toString());
                this.entries.add(o);
                return true;
            }
            return false;
        }

        public Iterator iterator() {
            return new Iterator(){
                private Iterator iter;
                private FragmentPropertiesEntry last;
                {
                    this.iter = FragmentPropertiesEntrySet.this.entries.iterator();
                }

                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                public Object next() {
                    this.last = (FragmentPropertiesEntry)this.iter.next();
                    return this.last;
                }

                public void remove() {
                    if (this.last == null) {
                        throw new IllegalStateException("No preceding call to next() or remove() already invoked");
                    }
                    FragmentPropertyMap.this.fragment.clearPropertyMember(this.last.getKey().toString());
                    this.last = null;
                    this.iter.remove();
                }
            };
        }

        public int size() {
            return this.entries.size();
        }
    }
}

