/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.impl;

import java.util.AbstractList;
import java.util.List;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuDefinitionImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

class FolderMenuDefinitionList
extends AbstractList {
    private FolderImpl folder;
    private List removedMenuDefinitions;

    FolderMenuDefinitionList(FolderImpl folder) {
        this.folder = folder;
    }

    private FolderMenuDefinitionImpl validateDefinitionForAdd(FolderMenuDefinitionImpl definition) {
        int removedIndex;
        if (definition == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.folder.accessMenus().contains(definition)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + definition.getName());
        }
        if (this.removedMenuDefinitions != null && (removedIndex = this.removedMenuDefinitions.indexOf(definition)) >= 0) {
            FolderMenuDefinitionImpl addDefinition = definition;
            definition = (FolderMenuDefinitionImpl)this.removedMenuDefinitions.remove(removedIndex);
            definition.setOptions(addDefinition.getOptions());
            definition.setDepth(addDefinition.getDepth());
            definition.setPaths(addDefinition.isPaths());
            definition.setRegexp(addDefinition.isRegexp());
            definition.setProfile(addDefinition.getProfile());
            definition.setOrder(addDefinition.getOrder());
            definition.setSkin(addDefinition.getSkin());
            definition.setTitle(addDefinition.getTitle());
            definition.setShortTitle(addDefinition.getShortTitle());
            definition.setMenuElements(addDefinition.getMenuElements());
            definition.getMetadata().copyFields(addDefinition.getMetadata().getFields());
        }
        return definition;
    }

    private List getRemovedMenuDefinitions() {
        if (this.removedMenuDefinitions == null) {
            this.removedMenuDefinitions = DatabasePageManagerUtils.createList();
        }
        return this.removedMenuDefinitions;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.folder.accessMenus().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        FolderMenuDefinitionImpl definition = this.validateDefinitionForAdd((FolderMenuDefinitionImpl)element);
        this.folder.accessMenus().add(index, definition);
    }

    public Object get(int index) {
        return this.folder.accessMenus().get(index);
    }

    public Object remove(int index) {
        FolderMenuDefinitionImpl removed = (FolderMenuDefinitionImpl)this.folder.accessMenus().remove(index);
        if (removed != null) {
            this.getRemovedMenuDefinitions().add(removed);
        }
        return removed;
    }

    public Object set(int index, Object element) {
        FolderMenuDefinitionImpl newDefinition = this.validateDefinitionForAdd((FolderMenuDefinitionImpl)element);
        FolderMenuDefinitionImpl definition = this.folder.accessMenus().set(index, newDefinition);
        this.getRemovedMenuDefinitions().add(definition);
        return definition;
    }

    public int size() {
        return this.folder.accessMenus().size();
    }
}

