/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.maven.utils;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class DbConnection {
    private String username;
    private String password;
    private String driver;
    private String url;
    private String settingsKey;

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public void checkSettings(Settings settings) {
        Server server;
        if (this.username == null && this.password == null && settings != null && this.settingsKey != null && (server = settings.getServer(this.settingsKey)) != null) {
            if (this.username == null) {
                this.username = server.getUsername();
            }
            if (this.password == null) {
                this.password = server.getPassword();
            }
        }
        if (this.username == null) {
            this.username = "";
        }
        if (this.password == null) {
            this.password = "";
        }
    }

    public Connection getConnection() throws MojoExecutionException {
        Connection connection = null;
        if (this.driver == null) {
            throw new MojoExecutionException("dbConnection.driver attribute not specified");
        }
        if (this.url == null) {
            throw new MojoExecutionException("dbConnection.url attribute not specified");
        }
        try {
            Properties info = new Properties();
            info.put("user", this.username);
            info.put("password", this.password);
            Driver driverInstance = null;
            try {
                Class<?> dc = Class.forName(this.driver);
                driverInstance = (Driver)dc.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Driver class not found: " + this.driver, (Exception)e);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failure loading driver: " + this.driver, e);
            }
            connection = driverInstance.connect(this.url, info);
            if (connection == null) {
                throw new SQLException("No suitable Driver for " + this.url);
            }
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return connection;
    }
}

