/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.layout;

import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.portlets.layout.LayoutCoordinate;

public class LayoutEvent {
    public static final int ADDED = 0;
    public static final int MOVED_UP = 1;
    public static final int MOVED_DOWN = 2;
    public static final int MOVED_LEFT = 3;
    public static final int MOVED_RIGHT = 4;
    private final int eventType;
    private final ContentPage page;
    private final String portletType;
    private final String portletName;
    private final ContentFragment fragment;
    private final LayoutCoordinate originalCoordinate;
    private final LayoutCoordinate newCoordinate;

    public LayoutEvent(int eventType, ContentPage page, String portletType, String portletName) {
        this.eventType = eventType;
        this.page = page;
        this.portletType = portletType;
        this.portletName = portletName;
        this.fragment = null;
        this.originalCoordinate = null;
        this.newCoordinate = null;
    }

    public LayoutEvent(int eventType, ContentFragment fragment, LayoutCoordinate originalCoordinate, LayoutCoordinate newCoordinate) {
        this.eventType = eventType;
        this.page = null;
        this.portletType = null;
        this.portletName = null;
        this.fragment = fragment;
        this.originalCoordinate = originalCoordinate;
        this.newCoordinate = newCoordinate;
    }

    public int getEventType() {
        return this.eventType;
    }

    public ContentPage getPage() {
        return this.page;
    }

    public String getPortletType() {
        return this.portletType;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public ContentFragment getFragment() {
        return this.fragment;
    }

    public LayoutCoordinate getNewCoordinate() {
        return this.newCoordinate;
    }

    public LayoutCoordinate getOriginalCoordinate() {
        return this.originalCoordinate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutEvent) {
            LayoutEvent event = (LayoutEvent)obj;
            if (this.fragment != null) {
                return event.fragment.equals(this.fragment) && event.eventType == this.eventType && event.originalCoordinate.equals(this.originalCoordinate) && event.newCoordinate.equals(this.newCoordinate);
            }
            if (this.page != null) {
                return event.page.equals(this.page) && event.eventType == this.eventType && (event.portletName == null && this.portletName == null || event.portletName != null && event.portletName.equals(this.portletName)) && (event.portletType == null && this.portletType == null || event.portletType != null && event.portletType.equals(this.portletType));
            }
            return event.eventType == this.eventType;
        }
        return false;
    }

    public String toString() {
        if (this.fragment != null) {
            return "event_target=" + this.fragment.getId() + ",event_type_code=" + this.eventType + ",orginial_coordinate=" + this.originalCoordinate + ",new_coordinate=" + this.newCoordinate;
        }
        if (this.page != null) {
            return "event_target=" + this.page.getId() + ",event_type_code=" + this.eventType + ",portlet_type=" + this.portletType + ",portlet_name=" + this.portletName;
        }
        return "event_type_code=" + this.eventType;
    }
}

