/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.util.JetspeedLoggerUtil;
import org.apache.jetspeed.util.ServletRequestCleanupCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestCleanupService {
    private static ThreadLocal<List<ServletRequestCleanupCallback>> callbacks = new ThreadLocal();

    private static List<ServletRequestCleanupCallback> getCallbacks(boolean create) {
        List<ServletRequestCleanupCallback> list = callbacks.get();
        if (list == null && create) {
            list = new ArrayList<ServletRequestCleanupCallback>();
            callbacks.set(list);
        }
        return list;
    }

    public static void addCleanupCallback(ServletRequestCleanupCallback callback) {
        List<ServletRequestCleanupCallback> callbacks = ServletRequestCleanupService.getCallbacks(false);
        if (callbacks == null) {
            callbacks = ServletRequestCleanupService.getCallbacks(true);
            try {
                throw new RuntimeException();
            }
            catch (RuntimeException jre) {
                JetspeedLoggerUtil.getSharedLogger(ServletRequestCleanupService.class).error("Registring cleanup callback before ServletRequestCleanupService invoked from filter chain.", jre);
            }
        }
        callbacks.add(callback);
    }

    static void doFilter(ServletContext context, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        List<ServletRequestCleanupCallback> callbacks = ServletRequestCleanupService.getCallbacks(true);
        Throwable filterException = null;
        try {
            if (filterChain != null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Throwable tf) {
            filterException = tf;
            tf.fillInStackTrace();
        }
        for (ServletRequestCleanupCallback callback : callbacks) {
            try {
                callback.cleanup(context, request, response);
            }
            catch (Throwable tc) {
                try {
                    JetspeedLoggerUtil.getSharedLogger(ServletRequestCleanupService.class).error("Cleanup callback execution failed", tc);
                }
                catch (Throwable tl) {}
            }
        }
        ServletRequestCleanupService.callbacks.remove();
        if (filterException != null) {
            if (filterException instanceof ServletException) {
                throw (ServletException)filterException;
            }
            if (filterException instanceof IOException) {
                throw (IOException)filterException;
            }
            if (filterException instanceof RuntimeException) {
                throw (RuntimeException)filterException;
            }
            throw new RuntimeException(filterException);
        }
    }
}

