/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components;

import java.util.Properties;
import org.apache.jetspeed.components.FilteringListableBeanFactory;
import org.apache.jetspeed.components.JetspeedBeanDefinitionFilter;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FilteringClassPathXmlApplicationContext
extends ClassPathXmlApplicationContext {
    private JetspeedBeanDefinitionFilter filter;

    public FilteringClassPathXmlApplicationContext(JetspeedBeanDefinitionFilter filter, String[] configLocations, Properties initProperties) {
        this(filter, configLocations, initProperties, null);
    }

    public FilteringClassPathXmlApplicationContext(JetspeedBeanDefinitionFilter filter, String[] configLocations, Properties initProperties, ApplicationContext parent) {
        super(parent);
        if (initProperties != null) {
            PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
            ppc.setIgnoreUnresolvablePlaceholders(true);
            ppc.setSystemPropertiesMode(1);
            ppc.setProperties(initProperties);
            this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
        }
        this.setConfigLocations(configLocations);
        this.filter = filter;
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new FilteringListableBeanFactory(this.filter, this.getInternalParentBeanFactory());
    }
}

