/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.jetspeed.components.JetspeedBeanDefinitionFilterMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderSupport;

public class JetspeedBeanDefinitionFilter
extends PropertiesLoaderSupport {
    private static Logger log = LoggerFactory.getLogger(JetspeedBeanDefinitionFilter.class);
    public static final String SYSTEM_PROPERTY_CATEGORIES_KEY = "JetspeedBeanDefinitionFilter.categoriesKey";
    public static final String CATEGORY_META_KEY = "j2:cat";
    public static final String ALIAS_META_KEY = "j2:alias";
    public static final String DEFAULT_CATEGORIES = "default";
    private String categoriesKey;
    private Properties props;
    private Set<String> categories;
    private JetspeedBeanDefinitionFilterMatcher matcher;
    private boolean initialized;

    public JetspeedBeanDefinitionFilter() {
        this.setCategories(DEFAULT_CATEGORIES);
    }

    public JetspeedBeanDefinitionFilter(String categories) {
        this.setCategories(categories);
    }

    public JetspeedBeanDefinitionFilter(Set<String> categories) {
        this.setCategories(categories);
    }

    public JetspeedBeanDefinitionFilter(String propertiesLocation, String categoriesKey) throws IOException {
        this.loadProperties(new String[]{propertiesLocation});
        this.setCategoriesKey(categoriesKey);
    }

    public JetspeedBeanDefinitionFilter(String[] propertiesLocations, String categoriesKey) throws IOException {
        this.loadProperties(propertiesLocations);
        this.setCategoriesKey(categoriesKey);
    }

    protected void loadProperties(String[] propertiesLocations) throws IOException {
        if (propertiesLocations != null) {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            Resource[] resources = new Resource[propertiesLocations.length];
            for (int i = 0; i < propertiesLocations.length; ++i) {
                resources[i] = resourceLoader.getResource(propertiesLocations[i]);
            }
            this.setLocations(resources);
            this.props = new Properties();
            this.loadProperties(this.props);
            HashSet<String> circularRefs = new HashSet<String>();
            ArrayList<String> visitedProps = new ArrayList<String>();
            Enumeration<?> n = this.props.propertyNames();
            while (n.hasMoreElements()) {
                int idx;
                String k = (String)n.nextElement();
                String v = this.props.getProperty(k);
                String result = "";
                visitedProps.clear();
                visitedProps.add(k);
                while ((idx = v.indexOf("${")) >= 0) {
                    result = result + v.substring(0, idx);
                    int idx2 = (v = v.substring(idx + 2)).indexOf(125);
                    if (idx2 < 0) break;
                    String nk = v.substring(0, idx2);
                    v = v.substring(idx2 + 1);
                    String nv = null;
                    if (circularRefs.contains(nk) || visitedProps.contains(nk)) {
                        log.error("Circular property reference: " + nk + " encountered for: " + k + ". Property value not fully resolved");
                        circularRefs.add(k);
                    } else {
                        nv = this.props.getProperty(nk);
                        if (nv == null) {
                            nv = System.getProperty(nk);
                        } else {
                            visitedProps.add(nk);
                        }
                    }
                    if (nv == null || nv.equals(k)) {
                        result = result + "${" + nk + "}";
                        continue;
                    }
                    v = nv + v;
                }
                this.props.setProperty(k, result + v);
            }
        }
    }

    public void setCategoriesKey(String categoriesKey) {
        this.categoriesKey = categoriesKey;
    }

    public void setCategories(String categories) {
        if (categories != null && categories.length() > 0) {
            this.categories = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(categories, " ,;\t");
            while (st.hasMoreTokens()) {
                this.categories.add(st.nextToken());
            }
            this.matcher = new JetspeedBeanDefinitionFilterMatcher(this.categories);
        } else {
            this.categories = null;
            this.matcher = null;
        }
    }

    public void setCategories(Set<String> categories) {
        this.categories = categories;
        this.matcher = this.categories != null ? new JetspeedBeanDefinitionFilterMatcher(this.categories) : null;
    }

    public Properties getProperties() {
        this.props = new Properties();
        if (this.props != null) {
            this.props.putAll((Map<?, ?>)this.props);
        }
        return this.props;
    }

    public void init() throws IllegalStateException {
        if (!this.initialized) {
            this.initialized = true;
            if (this.props != null && this.categories == null) {
                this.categories = new HashSet<String>();
                String value = System.getProperty(SYSTEM_PROPERTY_CATEGORIES_KEY);
                if (value == null && this.props != null) {
                    value = this.props.getProperty(SYSTEM_PROPERTY_CATEGORIES_KEY);
                }
                if (value != null) {
                    this.categoriesKey = value;
                }
                if (this.categoriesKey == null || this.categoriesKey.length() == 0) {
                    throw new IllegalStateException("Required property categoriesKey undefined");
                }
                String categories = (String)this.props.get(this.categoriesKey);
                if (categories != null && categories.length() > 0) {
                    StringTokenizer st = new StringTokenizer(categories, " ,;\t");
                    while (st.hasMoreTokens()) {
                        this.categories.add(st.nextToken());
                    }
                }
                this.props = null;
            }
            if (this.categories == null) {
                this.categories = new HashSet<String>();
            }
            this.matcher = new JetspeedBeanDefinitionFilterMatcher(this.categories);
        }
    }

    public boolean match(BeanDefinition bd) {
        String beanCategoriesExpression = (String)bd.getAttribute(CATEGORY_META_KEY);
        boolean matched = true;
        if (beanCategoriesExpression != null) {
            matched = this.matcher != null && this.matcher.match(beanCategoriesExpression);
        }
        return matched;
    }

    public void registerDynamicAlias(BeanDefinitionRegistry registry, String beanName, BeanDefinition bd) {
        String aliases = (String)bd.getAttribute(ALIAS_META_KEY);
        if (aliases != null) {
            StringTokenizer st = new StringTokenizer(aliases, " ,");
            while (st.hasMoreTokens()) {
                String alias = st.nextToken();
                if (alias.equals(beanName)) continue;
                registry.registerAlias(beanName, alias);
            }
        }
    }
}

