/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.ContentCacheElement;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.ContentCacheKeyGenerator;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.cache.JetspeedContentCache;
import org.apache.jetspeed.cache.impl.EhCacheImpl;
import org.apache.jetspeed.cache.impl.EhPortletContentCacheElementImpl;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.request.RequestContext;

public class EhPortletContentCacheImpl
extends EhCacheImpl
implements JetspeedContentCache,
JetspeedCacheEventListener {
    JetspeedCache preferenceCache = null;
    ContentCacheKeyGenerator keyGenerator = null;
    public static final String KEY_ENTITY_KEY = "/portlet_entity/";
    public static final int KEY_ENTITY_KEY_LENGTH = "/portlet_entity/".length();

    public EhPortletContentCacheImpl(Ehcache ehcache, JetspeedCache preferenceCache, ContentCacheKeyGenerator keyGenerator) {
        this(ehcache);
        this.preferenceCache = preferenceCache;
        this.keyGenerator = keyGenerator;
        preferenceCache.addEventListener((JetspeedCacheEventListener)this, false);
    }

    public EhPortletContentCacheImpl(Ehcache ehcache, JetspeedCache preferenceCache) {
        this(ehcache);
        this.preferenceCache = preferenceCache;
        preferenceCache.addEventListener((JetspeedCacheEventListener)this, false);
    }

    public EhPortletContentCacheImpl(Ehcache ehcache) {
        super(ehcache);
    }

    public EhPortletContentCacheImpl(Ehcache ehcache, ContentCacheKeyGenerator keyGenerator) {
        this(ehcache);
        this.keyGenerator = keyGenerator;
    }

    public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
        this.notifyElementRemoved(cache, local, key, element);
    }

    public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
        if (local) {
            return;
        }
        if (!(key instanceof String)) {
            return;
        }
        String s = (String)key;
        if (!s.startsWith(KEY_ENTITY_KEY)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, "/");
        int count = 0;
        String pe = null;
        String user = null;
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            switch (count) {
                case 0: {
                    break;
                }
                case 1: {
                    pe = temp;
                    break;
                }
                case 2: {
                    user = temp;
                }
            }
            if (++count <= 2) continue;
            break;
        }
        if (pe != null && user != null) {
            this.removeUserEntry(user, "portal", pe);
            this.removeUserEntry(user, "desktop", pe);
        }
    }

    void removeUserEntry(String username, String pipeline, String windowId) {
        Map map;
        Element userElement;
        ContentCacheKey key = this.keyGenerator.createUserCacheKey(username, pipeline, windowId);
        if (this.ehcache.remove((Serializable)((Object)key.getKey())) && (userElement = this.ehcache.get((Serializable)((Object)username))) != null && (map = (Map)userElement.getObjectValue()) != null) {
            map.remove(windowId);
        }
    }

    @Override
    public CacheElement get(Object key) {
        ContentCacheKey cckey = (ContentCacheKey)key;
        Element element = this.ehcache.get((Serializable)((Object)cckey.getKey()));
        if (element == null) {
            return null;
        }
        return new EhPortletContentCacheElementImpl(element, cckey);
    }

    @Override
    public int getTimeToIdleSeconds() {
        return (int)this.ehcache.getCacheConfiguration().getTimeToIdleSeconds();
    }

    @Override
    public int getTimeToLiveSeconds() {
        return (int)this.ehcache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    @Override
    public boolean isKeyInCache(Object key) {
        ContentCacheKey cckey = (ContentCacheKey)key;
        return this.ehcache.isKeyInCache((Object)cckey.getKey());
    }

    @Override
    public void put(CacheElement element) {
        ContentCacheElement ccElement = (ContentCacheElement)element;
        EhPortletContentCacheElementImpl impl = (EhPortletContentCacheElementImpl)element;
        Element ehl = impl.getImplElement();
        String userKey = ccElement.getContentCacheKey().getSessionId();
        if (userKey == null) {
            userKey = ccElement.getContentCacheKey().getUsername();
        }
        String windowId = ccElement.getContentCacheKey().getWindowId();
        try {
            this.ehcache.put(ehl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element userElement = this.ehcache.get((Serializable)((Object)userKey));
        if (userElement == null) {
            Map<String, ContentCacheKey> map = Collections.synchronizedMap(new HashMap());
            map.put(windowId, ccElement.getContentCacheKey());
            userElement = new Element((Object)userKey, map);
            this.ehcache.put(userElement);
        } else {
            Map map = (Map)userElement.getObjectValue();
            map.put(windowId, ccElement.getContentCacheKey());
        }
    }

    @Override
    public CacheElement createElement(Object key, Object content) {
        ContentCacheKey cckey = (ContentCacheKey)key;
        Element cachedElement = new Element((Object)cckey.getKey(), content);
        return new EhPortletContentCacheElementImpl(cachedElement, cckey);
    }

    @Override
    public boolean remove(Object key) {
        Map map;
        CacheElement element = this.get(key);
        boolean removed = false;
        if (element == null) {
            return false;
        }
        ContentCacheElement ccElement = (ContentCacheElement)element;
        EhPortletContentCacheElementImpl impl = (EhPortletContentCacheElementImpl)element;
        Element ehl = impl.getImplElement();
        String userKey = ccElement.getContentCacheKey().getSessionId();
        if (userKey == null) {
            userKey = ccElement.getContentCacheKey().getUsername();
        }
        String windowId = ccElement.getContentCacheKey().getWindowId();
        removed = this.ehcache.remove((Serializable)((Object)ccElement.getContentCacheKey().getKey()));
        Element userElement = this.ehcache.get((Serializable)((Object)userKey));
        if (userElement != null && (map = (Map)userElement.getObjectValue()) != null) {
            map.remove(windowId);
        }
        return removed;
    }

    @Override
    public void evictContentForUser(String username) {
        Element userElement = this.saveGet(username);
        if (userElement != null) {
            Map map = (Map)userElement.getObjectValue();
            if (map != null) {
                for (ContentCacheKey ccKey : map.values()) {
                    this.ehcache.remove((Serializable)((Object)ccKey.getKey()));
                }
            }
            this.ehcache.remove((Serializable)((Object)username));
        }
    }

    @Override
    public void evictContentForSession(String session) {
        Element userElement = this.saveGet(session);
        if (userElement != null) {
            Map map = (Map)userElement.getObjectValue();
            if (map != null) {
                for (ContentCacheKey ccKey : map.values()) {
                    this.ehcache.remove((Serializable)((Object)ccKey.getKey()));
                }
            }
            this.ehcache.remove((Serializable)((Object)session));
        }
    }

    @Override
    public void clear() {
        this.ehcache.removeAll();
    }

    @Override
    public ContentCacheKey createCacheKey(RequestContext context, String windowId) {
        return this.keyGenerator.createCacheKey(context, windowId);
    }

    protected Element saveGet(Object key) {
        try {
            return this.ehcache.get(key);
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    public String createSessionKey(RequestContext context) {
        boolean isAjaxRequest = context == null;
        String mode = isAjaxRequest ? "-d-" : "-p-";
        String user = context.getRequest().getRemoteUser();
        if (user == null) {
            user = "guest";
        }
        return user + mode + context.getPage().getId();
    }

    public void invalidate(RequestContext context) {
        String themeCacheKey = this.createSessionKey(context);
        Theme theme = (Theme)context.getRequest().getSession().getAttribute(themeCacheKey);
        if (theme != null) {
            theme.setInvalidated(true);
        }
    }
}

