/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.util.system;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.jetspeed.components.util.system.SystemResourceUtil;

public class FSSystemResourceUtilImpl
implements SystemResourceUtil {
    private String systemRoot;

    public FSSystemResourceUtilImpl(String systemRoot) throws IOException {
        String absPath = new File(systemRoot).getCanonicalPath();
        this.systemRoot = this.endsWithSeperator(absPath) ? absPath : absPath + File.separator;
    }

    public String getSystemRoot() {
        return this.systemRoot;
    }

    public URL getURL(String relativePath) throws MalformedURLException {
        if (this.beginsWithSeperator(relativePath) && relativePath.length() > 1) {
            return new File(this.systemRoot + relativePath.substring(1)).toURL();
        }
        return new File(this.systemRoot + relativePath).toURL();
    }

    private boolean endsWithSeperator(String path) {
        return path.endsWith("/") || path.endsWith(File.separator);
    }

    private boolean beginsWithSeperator(String path) {
        return path.startsWith("/") || path.startsWith(File.separator);
    }
}

