/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.request.RequestContext;

public class JetspeedContentCacheKey
implements ContentCacheKey,
Serializable {
    private String username = null;
    private String pipeline = null;
    private String windowId = null;
    private String sessionId = null;
    private String requestParameter = null;
    private String sessionAttribute = null;
    private String key = "";

    public JetspeedContentCacheKey(List segments, RequestContext context, String windowId) {
        boolean first = true;
        Iterator si = segments.iterator();
        while (si.hasNext()) {
            int pos;
            String segment = (String)si.next();
            if (segment.equals("username")) {
                this.username = context.getUserPrincipal().getName();
                this.key = first ? this.username : this.key + "/" + this.username;
            } else if (segment.equals("windowid")) {
                this.windowId = windowId;
                this.key = first ? this.windowId : this.key + "/" + this.windowId;
            } else if (segment.equals("sessionid")) {
                this.sessionId = context.getRequest().getSession().getId();
                this.key = first ? this.sessionId : this.key + "/" + this.sessionId;
            } else if (segment.equals("pipeline")) {
                String encoder = context.getRequestParameter("encoder");
                this.pipeline = encoder != null && encoder.equals("desktop") ? "desktop" : "portal";
                this.key = first ? this.pipeline : this.key + "/" + this.pipeline;
            } else if (segment.startsWith("request")) {
                int pos2 = segment.indexOf(".");
                if (pos2 > -1) {
                    String parameterName = segment.substring(pos2);
                    this.requestParameter = context.getRequestParameter(parameterName);
                    if (this.requestParameter != null) {
                        this.key = first ? this.requestParameter : this.key + "/" + this.requestParameter;
                    }
                }
            } else if (segment.startsWith("session") && (pos = segment.indexOf(".")) > -1) {
                String attributeName = segment.substring(pos);
                this.sessionAttribute = (String)context.getSessionAttribute(attributeName);
                if (this.sessionAttribute != null) {
                    this.key = first ? this.sessionAttribute : this.key + "/" + this.sessionAttribute;
                }
            }
            first = false;
        }
    }

    public JetspeedContentCacheKey() {
    }

    public void createFromUser(String username, String pipeline, String windowId) {
        this.setUsername(username);
        this.setPipeline(pipeline);
        this.setWindowId(windowId);
        this.key = this.getUsername() + "/" + this.getPipeline() + "/" + this.getWindowId();
    }

    public void createFromSession(String sessionId, String pipeline, String windowId) {
        this.setSessionId(sessionId);
        this.setPipeline(pipeline);
        this.setWindowId(windowId);
        this.key = this.getSessionId() + "/" + this.getPipeline() + "/" + this.getWindowId();
    }

    public String getKey() {
        return this.key;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public String getRequestParameter() {
        return this.requestParameter;
    }

    public String getSessionAttribute() {
        return this.sessionAttribute;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public void setPipeline(String pipeline) {
        this.pipeline = pipeline;
    }

    public void setRequestParameter(String requestParameter) {
        this.requestParameter = requestParameter;
    }

    public void setSessionAttribute(String sessionAttribute) {
        this.sessionAttribute = sessionAttribute;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setWindowId(String windowId) {
        this.windowId = windowId;
    }
}

