/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.PortletWindowCache;
import org.apache.jetspeed.cache.impl.EhCacheImpl;
import org.apache.pluto.om.window.PortletWindow;

public class EhPortletWindowCache
extends EhCacheImpl
implements PortletWindowCache {
    private Map portletEntityIdToEntityid = Collections.synchronizedMap(new HashMap());
    static final /* synthetic */ boolean $assertionsDisabled;

    public EhPortletWindowCache(Ehcache ehcache) {
        super(ehcache);
    }

    public PortletWindow getPortletWindow(String windowId) {
        if (!$assertionsDisabled && windowId == null) {
            throw new AssertionError();
        }
        CacheElement cacheElement = this.get(windowId);
        if (cacheElement != null) {
            return (PortletWindow)cacheElement.getContent();
        }
        return null;
    }

    public PortletWindow getPortletWindowByEntityId(String portletEntityId) {
        if (!$assertionsDisabled && portletEntityId == null) {
            throw new AssertionError();
        }
        if (this.portletEntityIdToEntityid.containsKey(portletEntityId)) {
            return this.getPortletWindow((String)this.portletEntityIdToEntityid.get(portletEntityId));
        }
        return null;
    }

    public void putPortletWindow(PortletWindow window) {
        if (!$assertionsDisabled && window == null) {
            throw new AssertionError();
        }
        String windowId = window.getId().toString();
        this.portletEntityIdToEntityid.put(window.getPortletEntity().getId().toString(), windowId);
        this.put(this.createElement(windowId, window));
    }

    public void removePortletWindow(String portletWindowId) {
        if (!$assertionsDisabled && portletWindowId == null) {
            throw new AssertionError();
        }
        PortletWindow window = this.getPortletWindow(portletWindowId);
        if (window != null) {
            this.portletEntityIdToEntityid.remove(window.getPortletEntity().getId().toString());
            this.removeQuiet(portletWindowId);
        }
    }

    public void removePortletWindowByPortletEntityId(String portletEntityId) {
        if (!$assertionsDisabled && portletEntityId == null) {
            throw new AssertionError();
        }
        PortletWindow portletWindow = this.getPortletWindowByEntityId(portletEntityId);
        if (portletWindow != null) {
            this.portletEntityIdToEntityid.remove(portletEntityId);
            this.removeQuiet(portletWindow.getId().toString());
        }
    }

    public Set getAllPortletWindows() {
        Iterator keys = this.ehcache.getKeys().iterator();
        HashSet<PortletWindow> windows = new HashSet<PortletWindow>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            PortletWindow window = this.getPortletWindow(key);
            if (window == null) continue;
            windows.add(window);
        }
        return windows;
    }

    static {
        $assertionsDisabled = !EhPortletWindowCache.class.desiredAssertionStatus();
    }
}

