/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.ContentCacheElement;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.ContentCacheKeyGenerator;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.cache.JetspeedContentCache;
import org.apache.jetspeed.cache.impl.EhCacheImpl;
import org.apache.jetspeed.cache.impl.EhDecorationContentCacheElementImpl;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;

public class EhDecorationContentCacheImpl
extends EhCacheImpl
implements JetspeedContentCache,
JetspeedCacheEventListener {
    JetspeedCache preferenceCache = null;
    ContentCacheKeyGenerator keyGenerator = null;
    public static final String KEY_THEME_KEY = "/theme/";
    public static final int KEY_THEME_KEY_LENGTH = "/theme/".length();

    public EhDecorationContentCacheImpl(Ehcache ehcache, JetspeedCache preferenceCache, ContentCacheKeyGenerator keyGenerator) {
        this(ehcache);
        this.preferenceCache = preferenceCache;
        this.keyGenerator = keyGenerator;
        preferenceCache.addEventListener((JetspeedCacheEventListener)this, false);
    }

    public EhDecorationContentCacheImpl(Ehcache ehcache, JetspeedCache preferenceCache) {
        this(ehcache);
        this.preferenceCache = preferenceCache;
        preferenceCache.addEventListener((JetspeedCacheEventListener)this, false);
    }

    public EhDecorationContentCacheImpl(Ehcache ehcache) {
        super(ehcache);
    }

    public EhDecorationContentCacheImpl(Cache ehcache, ContentCacheKeyGenerator keyGenerator) {
        this((Ehcache)ehcache);
        this.keyGenerator = keyGenerator;
    }

    public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
        this.notifyElementRemoved(cache, local, key, element);
    }

    public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
        if (local) {
            return;
        }
        if (!(key instanceof String)) {
            return;
        }
        String s = (String)key;
        if (!s.startsWith(KEY_THEME_KEY)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, "/");
        int count = 0;
        String te = null;
        String user = null;
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            switch (count) {
                case 0: {
                    break;
                }
                case 1: {
                    te = temp;
                    break;
                }
                case 2: {
                    user = temp;
                }
            }
            if (++count <= 2) continue;
            break;
        }
        if (te != null) {
            this.removeUserEntry(user, "theme", te);
        }
    }

    void removeUserEntry(String username, String pipeline, String windowId) {
        Map map;
        Element userElement;
        ContentCacheKey key = this.keyGenerator.createUserCacheKey(username, pipeline, windowId);
        if (this.ehcache.remove((Serializable)((Object)key.getKey())) && (userElement = this.ehcache.get((Serializable)((Object)username))) != null && (map = (Map)userElement.getObjectValue()) != null) {
            map.remove(windowId);
        }
    }

    public CacheElement get(Object key) {
        ContentCacheKey cckey = (ContentCacheKey)key;
        Element element = this.ehcache.get((Serializable)((Object)cckey.getKey()));
        if (element == null) {
            return null;
        }
        return new EhDecorationContentCacheElementImpl(element, cckey);
    }

    public int getTimeToIdleSeconds() {
        return (int)this.ehcache.getTimeToIdleSeconds();
    }

    public int getTimeToLiveSeconds() {
        return (int)this.ehcache.getTimeToLiveSeconds();
    }

    public boolean isKeyInCache(Object key) {
        ContentCacheKey cckey = (ContentCacheKey)key;
        return this.ehcache.isKeyInCache((Object)cckey.getKey());
    }

    public void put(CacheElement element) {
        ContentCacheElement ccElement = (ContentCacheElement)element;
        EhDecorationContentCacheElementImpl impl = (EhDecorationContentCacheElementImpl)element;
        Element ehl = impl.getImplElement();
        String userKey = ccElement.getContentCacheKey().getSessionId();
        if (userKey == null) {
            userKey = ccElement.getContentCacheKey().getUsername();
        }
        String windowId = ccElement.getContentCacheKey().getWindowId();
        try {
            this.ehcache.put(ehl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element userElement = this.ehcache.get((Serializable)((Object)userKey));
        if (userElement == null) {
            Map<String, ContentCacheKey> map = Collections.synchronizedMap(new HashMap());
            map.put(windowId, ccElement.getContentCacheKey());
            userElement = new Element((Object)userKey, map);
            this.ehcache.put(userElement);
        } else {
            Map map = (Map)userElement.getObjectValue();
            map.put(windowId, ccElement.getContentCacheKey());
        }
    }

    public CacheElement createElement(Object key, Object content) {
        ContentCacheKey cckey = (ContentCacheKey)key;
        Element cachedElement = new Element((Object)cckey.getKey(), content);
        return new EhDecorationContentCacheElementImpl(cachedElement, cckey);
    }

    public boolean remove(Object key) {
        Map map;
        CacheElement element = this.get(key);
        boolean removed = false;
        if (element == null) {
            return false;
        }
        ContentCacheElement ccElement = (ContentCacheElement)element;
        EhDecorationContentCacheElementImpl impl = (EhDecorationContentCacheElementImpl)element;
        Element ehl = impl.getImplElement();
        String userKey = ccElement.getContentCacheKey().getSessionId();
        if (userKey == null) {
            userKey = ccElement.getContentCacheKey().getUsername();
        }
        String windowId = ccElement.getContentCacheKey().getWindowId();
        removed = this.ehcache.remove((Serializable)((Object)ccElement.getContentCacheKey().getKey()));
        Element userElement = this.ehcache.get((Serializable)((Object)userKey));
        if (userElement != null && (map = (Map)userElement.getObjectValue()) != null) {
            map.remove(windowId);
        }
        return removed;
    }

    public void evictContentForUser(String username) {
        Element userElement = this.saveGet(username);
        if (userElement != null) {
            Map map = (Map)userElement.getObjectValue();
            if (map != null) {
                Iterator entities = map.values().iterator();
                while (entities.hasNext()) {
                    ContentCacheKey ccKey = (ContentCacheKey)entities.next();
                    this.ehcache.remove((Serializable)((Object)ccKey.getKey()));
                }
            }
            this.ehcache.remove((Serializable)((Object)username));
        }
    }

    public void evictContentForSession(String session) {
        Element userElement = this.saveGet(session);
        if (userElement != null) {
            Map map = (Map)userElement.getObjectValue();
            if (map != null) {
                Iterator entities = map.values().iterator();
                while (entities.hasNext()) {
                    ContentCacheKey ccKey = (ContentCacheKey)entities.next();
                    this.ehcache.remove((Serializable)((Object)ccKey.getKey()));
                }
            }
            this.ehcache.remove((Serializable)((Object)session));
        }
    }

    public void clear() {
        this.ehcache.removeAll();
    }

    public ContentCacheKey createCacheKey(RequestContext context, String windowId) {
        return this.keyGenerator.createCacheKey(context, windowId);
    }

    protected Element saveGet(Object key) {
        try {
            return this.ehcache.get(key);
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    public String createSessionKey(RequestContext context) {
        boolean isAjaxRequest = context == null;
        String mode = isAjaxRequest ? "-d-" : "-p-";
        String user = context.getRequest().getRemoteUser();
        if (user == null) {
            user = "guest";
        }
        return user + mode + context.getPage().getId();
    }

    public void invalidate(RequestContext context) {
        ContentPage page = context.getPage();
        ContentCacheKey themeContentCacheKey = this.createCacheKey(context, page.getId());
        CacheElement themeCacheElem = this.get(themeContentCacheKey);
        if (themeCacheElem != null) {
            Theme theme = (Theme)themeCacheElem.getContent();
            theme.setInvalidated(true);
        }
    }
}

