/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.xmlsimplesign;

import com.google.step2.xmlsimplesign.CertValidator;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CnConstraintCertValidator
implements CertValidator {
    private static final Pattern CN_PATTERN = Pattern.compile("CN=([^,]+)");

    public boolean matches(X509Certificate cert, String authority) {
        String cn = this.getCnFromDn(cert.getSubjectX500Principal().getName());
        if (cn == null) {
            return false;
        }
        return cn.equals(this.getRequiredCn(authority));
    }

    String getCnFromDn(String dn) {
        Matcher m = CN_PATTERN.matcher(dn);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected abstract String getRequiredCn(String var1);
}

