/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.http;

import java.net.URI;

public class FetchRequest {
    private final Method method;
    private final URI uri;

    public static FetchRequest createGetRequest(URI uri) {
        return new FetchRequest(Method.GET, uri);
    }

    public static FetchRequest createHeadRequest(URI uri) {
        return new FetchRequest(Method.HEAD, uri);
    }

    public static FetchRequest createPostRequest(URI uri) {
        return new FetchRequest(Method.POST, uri);
    }

    public FetchRequest(Method method, URI uri) {
        this.method = method;
        this.uri = uri;
    }

    public Method getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchRequest other = (FetchRequest)obj;
        if (this.method == null ? other.method != null : !this.method.equals((Object)other.method)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        HEAD,
        POST;

    }
}

