/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.migration.operation;

import javax.json.JsonObject;
import org.apache.polygene.migration.Migrator;
import org.apache.polygene.migration.assembly.EntityMigrationOperation;
import org.apache.polygene.migration.assembly.MigrationContext;
import org.apache.polygene.spi.entitystore.helpers.StateStore;

public class RemoveProperty
implements EntityMigrationOperation {
    private String property;
    private String defaultValue;

    public RemoveProperty(String property, String defaultValue) {
        this.property = property;
        this.defaultValue = defaultValue;
    }

    @Override
    public JsonObject upgrade(MigrationContext context, JsonObject state, StateStore stateStore, Migrator migrator) {
        return migrator.removeProperty(context, state, this.property);
    }

    @Override
    public JsonObject downgrade(MigrationContext context, JsonObject state, StateStore stateStore, Migrator migrator) {
        return migrator.addProperty(context, state, this.property, this.defaultValue);
    }

    public String toString() {
        return "Remove property " + this.property + ", default:" + this.defaultValue;
    }
}

