/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.migration.assembly;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.polygene.migration.assembly.AbstractMigrationRule;
import org.apache.polygene.migration.util.ListMap;

public class MigrationRules<T extends AbstractMigrationRule> {
    private ListMap<String, String> versionChanges = new ListMap();
    private ListMap<String, T> rules = new ListMap();

    public void addRule(T migrationRule) {
        this.versionChanges.add(((AbstractMigrationRule)migrationRule).toVersion(), ((AbstractMigrationRule)migrationRule).fromVersion());
        this.rules.add(((AbstractMigrationRule)migrationRule).fromVersion() + "->" + ((AbstractMigrationRule)migrationRule).toVersion(), migrationRule);
    }

    public Iterable<T> rulesBetweenVersions(String fromVersion, String toVersion) {
        try {
            String ruleToVersion = this.findHighestToVersion(toVersion);
            return this.migrationRules(fromVersion, ruleToVersion);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private List<T> migrationRules(String fromVersion, String toVersion) {
        List list = (List)this.versionChanges.get(toVersion);
        if (list == null) {
            return null;
        }
        for (String possibleFromVersion : list) {
            if (fromVersion.equals(possibleFromVersion)) {
                return new ArrayList<T>(this.getRulesForTransition(fromVersion, toVersion));
            }
            List<T> migrationRules = this.migrationRules(fromVersion, possibleFromVersion);
            if (migrationRules == null) continue;
            migrationRules.addAll(this.getRulesForTransition(possibleFromVersion, toVersion));
            return migrationRules;
        }
        return null;
    }

    private String findHighestToVersion(String toVersion) {
        if (this.versionChanges.get(toVersion) == null) {
            ArrayList toVersions = new ArrayList(this.versionChanges.keySet());
            toVersions.sort(Collections.reverseOrder());
            for (String version : toVersions) {
                if (version.compareTo(toVersion) > 0) continue;
                return version;
            }
            throw new IllegalArgumentException("No version found in rules that matches the given to-version:" + toVersion);
        }
        return toVersion;
    }

    private List<T> getRulesForTransition(String fromVersion, String toVersion) {
        return (List)this.rules.get(fromVersion + "->" + toVersion);
    }
}

