/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.polygene.api.activation.ActivatorAdapter;
import org.apache.polygene.api.activation.Activators;
import org.apache.polygene.api.configuration.Configuration;
import org.apache.polygene.api.injection.scope.Service;
import org.apache.polygene.api.injection.scope.Structure;
import org.apache.polygene.api.injection.scope.This;
import org.apache.polygene.api.injection.scope.Uses;
import org.apache.polygene.api.mixin.Mixins;
import org.apache.polygene.api.service.ServiceDescriptor;
import org.apache.polygene.api.service.ServiceReference;
import org.apache.polygene.api.structure.Application;
import org.apache.polygene.api.unitofwork.UnitOfWorkFactory;
import org.apache.polygene.migration.MigrationConfiguration;
import org.apache.polygene.migration.MigrationEvents;
import org.apache.polygene.migration.Migrator;
import org.apache.polygene.migration.assembly.EntityMigrationRule;
import org.apache.polygene.migration.assembly.MigrationBuilder;
import org.apache.polygene.migration.assembly.MigrationContext;
import org.apache.polygene.migration.assembly.MigrationRule;
import org.apache.polygene.serialization.javaxjson.JavaxJsonFactories;
import org.apache.polygene.spi.entitystore.EntityStore;
import org.apache.polygene.spi.entitystore.helpers.Migration;
import org.apache.polygene.spi.entitystore.helpers.StateStore;
import org.apache.polygene.spi.serialization.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={MigrationMixin.class})
@Activators(value={Activator.class})
public interface MigrationService
extends Migration {
    public void initialize() throws Exception;

    public static class MigrationMixin
    implements MigrationService,
    Migrator {
        private static final Logger LOGGER = LoggerFactory.getLogger(MigrationService.class);
        @Structure
        private Application app;
        @This
        private Configuration<MigrationConfiguration> config;
        @Uses
        private ServiceDescriptor descriptor;
        @Service
        private StateStore store;
        @Service
        private EntityStore entityStore;
        @Service
        private JsonSerialization serialization;
        @Service
        private JavaxJsonFactories jsonFactories;
        @Structure
        private UnitOfWorkFactory uowf;
        @This
        private Migrator migrator;
        @Service
        private Iterable<MigrationEvents> migrationEvents;
        private MigrationBuilder builder;

        @Override
        public void initialize() throws Exception {
            this.builder = (MigrationBuilder)this.descriptor.metaInfo(MigrationBuilder.class);
            String version = this.app.version();
            String lastVersion = (String)((MigrationConfiguration)this.config.get()).lastStartupVersion().get();
            if (!this.app.version().equals(lastVersion)) {
                Iterable<MigrationRule> rules = this.builder.migrationRules().rulesBetweenVersions(lastVersion, version);
                ArrayList<MigrationRule> executedRules = new ArrayList<MigrationRule>();
                try {
                    if (rules != null) {
                        for (MigrationRule rule : rules) {
                            rule.upgrade(this.store, this);
                            executedRules.add(rule);
                            LOGGER.debug(rule.toString());
                        }
                        LOGGER.info("Migrated to " + version);
                    }
                    ((MigrationConfiguration)this.config.get()).lastStartupVersion().set((Object)version);
                    this.config.save();
                }
                catch (Exception e) {
                    LOGGER.error("Upgrade failed", (Throwable)e);
                    for (MigrationRule executedRule : executedRules) {
                        executedRule.downgrade(this.store, this);
                    }
                }
            }
        }

        public JsonObject migrate(JsonObject state, String toVersion, StateStore stateStore) throws JsonException {
            String fromVersion = state.getString("application_version", "0.0");
            Iterable<EntityMigrationRule> matchedRules = this.builder.entityMigrationRules().rulesBetweenVersions(fromVersion, toVersion);
            JsonObject migratedState = state;
            boolean changed = false;
            ArrayList<String> failures = new ArrayList<String>();
            if (matchedRules != null) {
                for (EntityMigrationRule matchedRule : matchedRules) {
                    MigrationContext context = new MigrationContext();
                    migratedState = matchedRule.upgrade(context, migratedState, stateStore, this.migrator);
                    if (context.isSuccess() && context.hasChanged() && LOGGER.isDebugEnabled()) {
                        LOGGER.debug(matchedRule.toString());
                    }
                    failures.addAll(context.failures());
                    changed = context.hasChanged() || changed;
                }
            }
            JsonObjectBuilder appVersionBuilder = this.jsonFactories.builderFactory().createObjectBuilder();
            for (Map.Entry entry : migratedState.entrySet()) {
                appVersionBuilder.add((String)entry.getKey(), (JsonValue)entry.getValue());
            }
            appVersionBuilder.add("application_version", toVersion);
            migratedState = appVersionBuilder.build();
            if (failures.size() > 0) {
                LOGGER.warn("Migration of {} from {} to {} aborted, failed operation(s):\n{}", new Object[]{state.getString("reference"), fromVersion, toVersion, String.join((CharSequence)"\n\t", failures)});
                return state;
            }
            if (changed) {
                LOGGER.info("Migrated {} from {} to {}", new Object[]{migratedState.getString("reference"), fromVersion, toVersion});
                return migratedState;
            }
            return state;
        }

        @Override
        public JsonObject addProperty(MigrationContext context, JsonObject state, String name, Object defaultValue) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (!valueState.containsKey((Object)name)) {
                valueState = this.jsonFactories.cloneBuilder(valueState).add(name, this.serialization.toJson(defaultValue)).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.propertyAdded(state.getString("reference"), name, defaultValue);
                }
                return migratedState;
            }
            context.addFailure("Add property " + name + ", default:" + defaultValue);
            return state;
        }

        @Override
        public JsonObject removeProperty(MigrationContext context, JsonObject state, String name) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (valueState.containsKey((Object)name)) {
                valueState = this.jsonFactories.cloneBuilderExclude(valueState, new String[]{name}).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.propertyRemoved(state.getString("reference"), name);
                }
                return migratedState;
            }
            context.addFailure("Remove property " + name);
            return state;
        }

        @Override
        public JsonObject renameProperty(MigrationContext context, JsonObject state, String from, String to) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (valueState.containsKey((Object)from)) {
                JsonValue jsonValue = (JsonValue)valueState.get((Object)from);
                valueState = this.jsonFactories.cloneBuilderExclude(valueState, new String[]{from}).add(to, jsonValue).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.propertyRenamed(state.getString("reference"), from, to);
                }
                return migratedState;
            }
            context.addFailure("Rename property " + from + " to " + to);
            return state;
        }

        @Override
        public JsonObject addAssociation(MigrationContext context, JsonObject state, String name, String defaultReference) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (!valueState.containsKey((Object)name)) {
                valueState = this.jsonFactories.cloneBuilder(valueState).add(name, defaultReference).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.associationAdded(state.getString("reference"), name, defaultReference);
                }
                return migratedState;
            }
            context.addFailure("Add association " + name + ", default:" + defaultReference);
            return state;
        }

        @Override
        public JsonObject removeAssociation(MigrationContext context, JsonObject state, String name) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (valueState.containsKey((Object)name)) {
                valueState = this.jsonFactories.cloneBuilderExclude(valueState, new String[]{name}).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.associationRemoved(state.getString("reference"), name);
                }
                return migratedState;
            }
            context.addFailure("Remove association " + name);
            return state;
        }

        @Override
        public JsonObject renameAssociation(MigrationContext context, JsonObject state, String from, String to) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (valueState.containsKey((Object)from)) {
                JsonValue jsonValue = (JsonValue)valueState.get((Object)from);
                valueState = this.jsonFactories.cloneBuilderExclude(valueState, new String[]{from}).add(to, jsonValue).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.associationRenamed(state.getString("reference"), from, to);
                }
                return migratedState;
            }
            context.addFailure("Rename association " + from + " to " + to);
            return state;
        }

        @Override
        public JsonObject addManyAssociation(MigrationContext context, JsonObject state, String name, String ... defaultReferences) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (!valueState.containsKey((Object)name)) {
                JsonArrayBuilder refArrayBuilder = this.jsonFactories.builderFactory().createArrayBuilder();
                for (String ref : defaultReferences) {
                    refArrayBuilder.add(ref);
                }
                valueState = this.jsonFactories.cloneBuilder(valueState).add(name, (JsonValue)refArrayBuilder.build()).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.manyAssociationAdded(state.getString("reference"), name, defaultReferences);
                }
                return migratedState;
            }
            context.addFailure("Add many-association " + name + ", default:" + Arrays.asList(defaultReferences));
            return state;
        }

        @Override
        public JsonObject removeManyAssociation(MigrationContext context, JsonObject state, String name) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (valueState.containsKey((Object)name)) {
                valueState = this.jsonFactories.cloneBuilderExclude(valueState, new String[]{name}).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.manyAssociationRemoved(state.getString("reference"), name);
                }
                return migratedState;
            }
            context.addFailure("Remove many-association " + name);
            return state;
        }

        @Override
        public JsonObject renameManyAssociation(MigrationContext context, JsonObject state, String from, String to) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (valueState.containsKey((Object)from)) {
                JsonValue jsonValue = (JsonValue)valueState.get((Object)from);
                valueState = this.jsonFactories.cloneBuilderExclude(valueState, new String[]{from}).add(to, jsonValue).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.manyAssociationRenamed(state.getString("reference"), from, to);
                }
                return migratedState;
            }
            context.addFailure("Rename many-association " + from + " to " + to);
            return state;
        }

        @Override
        public JsonObject addNamedAssociation(MigrationContext context, JsonObject state, String name, Map<String, String> defaultReferences) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (!valueState.containsKey((Object)name)) {
                JsonObjectBuilder refBuilder = this.jsonFactories.builderFactory().createObjectBuilder();
                for (Map.Entry<String, String> entry : defaultReferences.entrySet()) {
                    refBuilder.add(entry.getKey(), entry.getValue());
                }
                valueState = this.jsonFactories.cloneBuilder(valueState).add(name, (JsonValue)refBuilder.build()).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.namedAssociationAdded(state.getString("reference"), name, defaultReferences);
                }
                return migratedState;
            }
            context.addFailure("Add named-association " + name + ", default:" + defaultReferences);
            return state;
        }

        @Override
        public JsonObject removeNamedAssociation(MigrationContext context, JsonObject state, String name) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (!valueState.containsKey((Object)name)) {
                valueState = this.jsonFactories.cloneBuilderExclude(valueState, new String[]{name}).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.namedAssociationRemoved(state.getString("reference"), name);
                }
                return migratedState;
            }
            context.addFailure("Remove named-association " + name);
            return state;
        }

        @Override
        public JsonObject renameNamedAssociation(MigrationContext context, JsonObject state, String from, String to) throws JsonException {
            JsonObject valueState = state.getJsonObject("value");
            if (valueState.containsKey((Object)from)) {
                JsonValue jsonValue = (JsonValue)valueState.get((Object)from);
                valueState = this.jsonFactories.cloneBuilderExclude(valueState, new String[]{from}).add(to, jsonValue).build();
                JsonObject migratedState = this.jsonFactories.cloneBuilderExclude(state, new String[]{"value"}).add("value", (JsonValue)valueState).build();
                context.markAsChanged();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.namedAssociationRenamed(state.getString("reference"), from, to);
                }
                return migratedState;
            }
            context.addFailure("Rename named-association " + from + " to " + to);
            return state;
        }

        @Override
        public JsonObject changeEntityType(MigrationContext context, JsonObject state, String fromType, String toType) throws JsonException {
            String currentType = state.getString("type");
            if (fromType.equals(currentType)) {
                JsonObject migratedState = this.jsonFactories.cloneBuilder(state).add("type", toType).build();
                for (MigrationEvents migrationEvent : this.migrationEvents) {
                    migrationEvent.entityTypeChanged(state.getString("reference"), toType);
                }
                return migratedState;
            }
            context.addFailure("Change entity type from " + fromType + " to " + toType);
            return state;
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<MigrationService>> {
        public void afterActivation(ServiceReference<MigrationService> activated) throws Exception {
            ((MigrationService)activated.get()).initialize();
        }
    }
}

