/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.TextShape;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.SheetContainer;

public abstract class MasterSheet
extends Sheet {
    public MasterSheet(SheetContainer container, int sheetNo) {
        super(container, sheetNo);
    }

    public abstract TextProp getStyleAttribute(int var1, int var2, String var3, boolean var4);

    public static boolean isPlaceholder(Shape shape) {
        if (!(shape instanceof TextShape)) {
            return false;
        }
        TextShape tx = (TextShape)shape;
        TextRun run = tx.getTextRun();
        if (run == null) {
            return false;
        }
        Record[] records = run._records;
        for (int i = 0; i < records.length; ++i) {
            int type = (int)records[i].getRecordType();
            if (type != RecordTypes.BaseTextPropAtom.typeID && type != RecordTypes.DateTimeMCAtom.typeID && type != RecordTypes.GenericDateMCAtom.typeID && type != RecordTypes.FooterMCAtom.typeID && type != RecordTypes.SlideNumberMCAtom.typeID) continue;
            return true;
        }
        return false;
    }

    public TextShape getPlaceholder(int type) {
        Shape[] shape = this.getShapes();
        for (int i = 0; i < shape.length; ++i) {
            TextShape tx;
            TextRun run;
            if (!(shape[i] instanceof TextShape) || (run = (tx = (TextShape)shape[i]).getTextRun()) == null || run.getRunType() != type) continue;
            return tx;
        }
        return null;
    }
}

