/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hslf;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hslf.usermodel.HSLFObjectData;
import org.apache.poi.hslf.usermodel.HSLFObjectShape;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSoundData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.util.IOUtils;

public final class DataExtraction {
    private DataExtraction() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            DataExtraction.usage();
            return;
        }
        try (FileInputStream fis = new FileInputStream(args[0]);
             HSLFSlideShow ppt = new HSLFSlideShow((InputStream)fis);){
            HSLFSoundData[] sound;
            for (HSLFSoundData aSound : sound = ppt.getSoundData()) {
                DataExtraction.handleSound(aSound);
            }
            int oleIdx = -1;
            int picIdx = -1;
            for (HSLFSlide slide : ppt.getSlides()) {
                for (HSLFShape shape : slide.getShapes()) {
                    if (shape instanceof HSLFObjectShape) {
                        DataExtraction.handleShape((HSLFObjectShape)shape, ++oleIdx);
                        continue;
                    }
                    if (!(shape instanceof HSLFPictureShape)) continue;
                    DataExtraction.handlePicture((HSLFPictureShape)shape, ++picIdx);
                }
            }
        }
    }

    private static void handleShape(HSLFObjectShape ole, int oleIdx) throws IOException {
        HSLFObjectData data = ole.getObjectData();
        String name = ole.getInstanceName();
        switch (name == null ? "" : name) {
            case "Worksheet": {
                DataExtraction.handleWorkbook(data, name, oleIdx);
                break;
            }
            case "Document": {
                DataExtraction.handleDocument(data, name, oleIdx);
                break;
            }
            default: {
                DataExtraction.handleUnknown(data, ole.getProgId(), oleIdx);
            }
        }
    }

    private static void handleWorkbook(HSLFObjectData data, String name, int oleIdx) throws IOException {
        try (InputStream is = data.getInputStream();
             HSSFWorkbook wb = new HSSFWorkbook(is);
             FileOutputStream out = new FileOutputStream(name + "-(" + oleIdx + ").xls");){
            wb.write((OutputStream)out);
        }
    }

    private static void handleDocument(HSLFObjectData data, String name, int oleIdx) throws IOException {
        try (InputStream is = data.getInputStream();
             HWPFDocument doc = new HWPFDocument(is);
             FileOutputStream out = new FileOutputStream(name + "-(" + oleIdx + ").doc");){
            Range r = doc.getRange();
            for (int k = 0; k < r.numParagraphs(); ++k) {
                Paragraph p = r.getParagraph(k);
                System.out.println(p.text());
            }
            doc.write((OutputStream)out);
        }
    }

    private static void handleUnknown(HSLFObjectData data, String name, int oleIdx) throws IOException {
        try (InputStream is = data.getInputStream();
             FileOutputStream out = new FileOutputStream(name + "-" + (oleIdx + 1) + ".dat");){
            IOUtils.copy((InputStream)is, (OutputStream)out);
        }
    }

    private static void handlePicture(HSLFPictureShape p, int picIdx) throws IOException {
        HSLFPictureData data = p.getPictureData();
        String ext = data.getType().extension;
        try (FileOutputStream out = new FileOutputStream("pict-" + picIdx + ext);){
            out.write(data.getData());
        }
    }

    private static void handleSound(HSLFSoundData aSound) throws IOException {
        String type = aSound.getSoundType();
        String name = aSound.getSoundName();
        try (FileOutputStream out = new FileOutputStream(name + type);){
            out.write(aSound.getData());
        }
    }

    private static void usage() {
        System.out.println("Usage: DataExtraction  ppt");
    }
}

