/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hslf;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTable;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.sl.draw.DrawTableShape;
import org.apache.poi.sl.usermodel.TableShape;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.VerticalAlignment;

public final class TableDemo {
    static final String[][] txt1 = new String[][]{{"INPUT FILE", "NUMBER OF RECORDS"}, {"Item File", "11,559"}, {"Vendor File", "502"}, {"Purchase History File - # of PO\u2019s\r(12/01/04 - 05/31/06)", "12,852"}, {"Purchase History File - # of PO Lines\r(12/01/04 - 05/31/06)", "53,523"}, {"Total PO History Spend", "$10,172,038"}};
    static final String[][] txt2 = new String[][]{{"Data Source"}, {"CAS Internal Metrics - Item Master Summary\rCAS Internal Metrics - Vendor Summary\rCAS Internal Metrics - PO History Summary"}};

    public static void main(String[] args) throws Exception {
        try (HSLFSlideShow ppt = new HSLFSlideShow();){
            HSLFSlide slide = ppt.createSlide();
            TableDemo.create1stTable(slide);
            TableDemo.create2ndTable(slide);
            try (FileOutputStream out = new FileOutputStream("hslf-table.ppt");){
                ppt.write((OutputStream)out);
            }
        }
    }

    static void create1stTable(HSLFSlide slide) {
        HSLFTable table1 = slide.createTable(6, 2);
        for (int i = 0; i < txt1.length; ++i) {
            for (int j = 0; j < txt1[i].length; ++j) {
                HSLFTableCell cell = table1.getCell(i, j);
                HSLFTextRun rt = (HSLFTextRun)((HSLFTextParagraph)cell.getTextParagraphs().get(0)).getTextRuns().get(0);
                rt.setFontFamily("Arial");
                rt.setFontSize(Double.valueOf(10.0));
                if (i == 0) {
                    cell.getFill().setForegroundColor(new Color(227, 227, 227));
                } else {
                    rt.setBold(true);
                }
                cell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                cell.setHorizontalCentered(Boolean.valueOf(true));
                cell.setText(txt1[i][j]);
            }
        }
        DrawTableShape dts1 = new DrawTableShape((TableShape)table1);
        dts1.setAllBorders(new Object[]{1.0, Color.black});
        table1.setColumnWidth(0, 300.0);
        table1.setColumnWidth(1, 150.0);
        int pgWidth = slide.getSlideShow().getPageSize().width;
        table1.moveTo(((double)pgWidth - table1.getAnchor().getWidth()) / 2.0, 100.0);
    }

    static void create2ndTable(HSLFSlide slide) {
        HSLFTable table2 = slide.createTable(2, 1);
        for (int i = 0; i < txt2.length; ++i) {
            for (int j = 0; j < txt2[i].length; ++j) {
                HSLFTableCell cell = table2.getCell(i, j);
                HSLFTextRun rt = (HSLFTextRun)((HSLFTextParagraph)cell.getTextParagraphs().get(0)).getTextRuns().get(0);
                rt.setFontSize(Double.valueOf(10.0));
                rt.setFontFamily("Arial");
                if (i == 0) {
                    cell.getFill().setForegroundColor(new Color(0, 51, 102));
                    rt.setFontColor(Color.white);
                    rt.setBold(true);
                    rt.setFontSize(Double.valueOf(14.0));
                    cell.setHorizontalCentered(Boolean.valueOf(true));
                } else {
                    rt.getTextParagraph().setBullet(true);
                    rt.setFontSize(Double.valueOf(12.0));
                    rt.getTextParagraph().setTextAlign(TextParagraph.TextAlign.LEFT);
                    cell.setHorizontalCentered(Boolean.valueOf(false));
                }
                cell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                cell.setText(txt2[i][j]);
            }
        }
        table2.setColumnWidth(0, 300.0);
        table2.setRowHeight(0, 30.0);
        table2.setRowHeight(1, 70.0);
        DrawTableShape dts2 = new DrawTableShape((TableShape)table2);
        dts2.setOutsideBorders(new Object[]{Color.black, 1.0});
        table2.moveTo(200.0, 400.0);
    }
}

