/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hpsf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.EntryUtils;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.TempFile;

public final class CopyCompare {
    private CopyCompare() {
    }

    public static void main(String[] args) throws IOException {
        Throwable throwable;
        String originalFileName = null;
        String copyFileName = null;
        if (args.length == 1) {
            originalFileName = args[0];
            File f = TempFile.createTempFile((String)"CopyOfPOIFileSystem-", (String)".ole2");
            f.deleteOnExit();
            copyFileName = f.getAbsolutePath();
        } else if (args.length == 2) {
            originalFileName = args[0];
            copyFileName = args[1];
        } else {
            System.err.println("Usage: CopyCompare originPOIFS [copyPOIFS]");
            System.exit(1);
        }
        POIFSReader r = new POIFSReader();
        try (POIFSFileSystem poiFs = new POIFSFileSystem();){
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(copyFileName);){
                r.registerListener(e -> CopyCompare.handleEvent(poiFs, e));
                r.setNotifyEmptyDirectories(true);
                r.read(new File(originalFileName));
                poiFs.writeFilesystem((OutputStream)fos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var5_5 = null;
        try (POIFSFileSystem opfs = new POIFSFileSystem(new File(originalFileName));){
            throwable = null;
            try (POIFSFileSystem cpfs = new POIFSFileSystem(new File(copyFileName));){
                DirectoryNode oRoot = opfs.getRoot();
                DirectoryNode cRoot = cpfs.getRoot();
                System.out.println(EntryUtils.areDirectoriesIdentical((DirectoryEntry)oRoot, (DirectoryEntry)cRoot) ? "Equal" : "Not equal");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var5_5 = throwable4;
            throw throwable4;
        }
    }

    public static void handleEvent(POIFSFileSystem poiFs, POIFSReaderEvent event) {
        DocumentInputStream stream = event.getStream();
        try {
            InputStreamSupplier su;
            if (stream != null && PropertySet.isPropertySetStream((InputStream)stream)) {
                PropertySet ps = PropertySetFactory.create((InputStream)stream);
                Object mps = ps instanceof DocumentSummaryInformation ? new DocumentSummaryInformation(ps) : (ps instanceof SummaryInformation ? new SummaryInformation(ps) : new PropertySet(ps));
                su = () -> ((PropertySet)mps).toInputStream();
            } else {
                su = () -> ((POIFSReaderEvent)event).getStream();
            }
            try (InputStream is = su.get();){
                POIFSDocumentPath path = event.getPath();
                DirectoryNode de = poiFs.getRoot();
                if (File.separator.equals(path.toString())) {
                    de.setStorageClsid(event.getStorageClassId());
                }
                for (int i = 0; i < path.length(); ++i) {
                    String subDir = path.getComponent(i);
                    if (de.hasEntry(subDir)) {
                        de = (DirectoryEntry)de.getEntry(subDir);
                        continue;
                    }
                    de = de.createDirectory(subDir);
                    if (i != path.length() - 1) continue;
                    de.setStorageClsid(event.getStorageClassId());
                }
                if (event.getName() != null) {
                    de.createDocument(event.getName(), is);
                }
            }
        }
        catch (IOException | HPSFException ex) {
            throw new HPSFRuntimeException("Could not read file " + event.getPath() + "/" + event.getName(), ex);
        }
    }

    private static interface InputStreamSupplier {
        public InputStream get() throws IOException, WritingNotSupportedException;
    }
}

