/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples;

import java.io.File;
import java.io.InputStream;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class LoadEmbedded {
    public static void main(String[] args) throws Exception {
        Workbook wb = WorkbookFactory.create((File)new File(args[0]));
        LoadEmbedded.loadEmbedded(wb);
    }

    public static void loadEmbedded(Workbook wb) throws Exception {
        if (wb instanceof HSSFWorkbook) {
            LoadEmbedded.loadEmbedded((HSSFWorkbook)wb);
        } else if (wb instanceof XSSFWorkbook) {
            LoadEmbedded.loadEmbedded((XSSFWorkbook)wb);
        } else {
            throw new IllegalArgumentException(wb.getClass().getName());
        }
    }

    public static void loadEmbedded(HSSFWorkbook workbook) throws Exception {
        for (HSSFObjectData obj : workbook.getAllEmbeddedObjects()) {
            DirectoryNode dn;
            String oleName = obj.getOLE2ClassName();
            if (oleName.equals("Worksheet")) {
                dn = (DirectoryNode)obj.getDirectory();
                HSSFWorkbook embeddedWorkbook = new HSSFWorkbook(dn, false);
                continue;
            }
            if (oleName.equals("Document")) {
                dn = (DirectoryNode)obj.getDirectory();
                HWPFDocument embeddedWordDocument = new HWPFDocument(dn);
                continue;
            }
            if (oleName.equals("Presentation")) {
                dn = (DirectoryNode)obj.getDirectory();
                HSLFSlideShow embeddedPowerPointDocument = new HSLFSlideShow(dn);
                continue;
            }
            if (obj.hasDirectoryEntry()) {
                dn = (DirectoryNode)obj.getDirectory();
                for (Entry entry : dn) {
                }
                continue;
            }
            byte[] objectData = obj.getObjectData();
        }
    }

    public static void loadEmbedded(XSSFWorkbook workbook) throws Exception {
        for (PackagePart pPart : workbook.getAllEmbedds()) {
            OPCPackage docPackage;
            String contentType = pPart.getContentType();
            if (contentType.equals("application/vnd.ms-excel")) {
                HSSFWorkbook embeddedWorkbook = new HSSFWorkbook(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                docPackage = OPCPackage.open((InputStream)pPart.getInputStream());
                XSSFWorkbook embeddedWorkbook = new XSSFWorkbook(docPackage);
                continue;
            }
            if (contentType.equals("application/msword")) {
                HWPFDocument document = new HWPFDocument(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                docPackage = OPCPackage.open((InputStream)pPart.getInputStream());
                XWPFDocument document = new XWPFDocument(docPackage);
                continue;
            }
            if (contentType.equals("application/vnd.ms-powerpoint")) {
                HSLFSlideShow slideShow = new HSLFSlideShow(pPart.getInputStream());
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                docPackage = OPCPackage.open((InputStream)pPart.getInputStream());
                XSLFSlideShow slideShow = new XSLFSlideShow(docPackage);
                continue;
            }
            System.out.println("Unknown Embedded Document: " + contentType);
            InputStream inputStream = pPart.getInputStream();
        }
    }
}

