/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;

public class AddDimensionedImage {
    public static final int EXPAND_ROW = 1;
    public static final int EXPAND_COLUMN = 2;
    public static final int EXPAND_ROW_AND_COLUMN = 3;
    public static final int OVERLAY_ROW_AND_COLUMN = 7;
    private static final int EMU_PER_MM = 36000;

    public void addImageToSheet(String cellNumber, Sheet sheet, Drawing drawing, URL imageFile, double reqImageWidthMM, double reqImageHeightMM, int resizeBehaviour) throws IOException, IllegalArgumentException {
        CellReference cellRef = new CellReference(cellNumber);
        this.addImageToSheet(cellRef.getCol(), cellRef.getRow(), sheet, drawing, imageFile, reqImageWidthMM, reqImageHeightMM, resizeBehaviour);
    }

    public void addImageToSheet(int colNumber, int rowNumber, Sheet sheet, Drawing drawing, URL imageFile, double reqImageWidthMM, double reqImageHeightMM, int resizeBehaviour) throws IOException, IllegalArgumentException {
        ClientAnchor anchor = null;
        ClientAnchorDetail rowClientAnchorDetail = null;
        ClientAnchorDetail colClientAnchorDetail = null;
        int imageType = 0;
        if (resizeBehaviour != 2 && resizeBehaviour != 1 && resizeBehaviour != 3 && resizeBehaviour != 7) {
            throw new IllegalArgumentException("Invalid value passed to the resizeBehaviour parameter of AddDimensionedImage.addImageToSheet()");
        }
        colClientAnchorDetail = this.fitImageToColumns(sheet, colNumber, reqImageWidthMM, resizeBehaviour);
        rowClientAnchorDetail = this.fitImageToRows(sheet, rowNumber, reqImageHeightMM, resizeBehaviour);
        anchor = sheet.getWorkbook().getCreationHelper().createClientAnchor();
        anchor.setDx1(0);
        anchor.setDy1(0);
        anchor.setDx2(colClientAnchorDetail.getInset());
        anchor.setDy2(rowClientAnchorDetail.getInset());
        anchor.setCol1(colClientAnchorDetail.getFromIndex());
        anchor.setRow1(rowClientAnchorDetail.getFromIndex());
        anchor.setCol2(colClientAnchorDetail.getToIndex());
        anchor.setRow2(rowClientAnchorDetail.getToIndex());
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        String sURL = imageFile.toString().toLowerCase(Locale.ROOT);
        if (sURL.endsWith(".png")) {
            imageType = 6;
        } else if (sURL.endsWith("jpg") || sURL.endsWith(".jpeg")) {
            imageType = 5;
        } else {
            throw new IllegalArgumentException("Invalid Image file : " + sURL);
        }
        int index = sheet.getWorkbook().addPicture(IOUtils.toByteArray((InputStream)imageFile.openStream()), imageType);
        drawing.createPicture(anchor, index);
    }

    private ClientAnchorDetail fitImageToColumns(Sheet sheet, int colNumber, double reqImageWidthMM, int resizeBehaviour) {
        double colWidthMM = 0.0;
        double colCoordinatesPerMM = 0.0;
        int pictureWidthCoordinates = 0;
        ClientAnchorDetail colClientAnchorDetail = null;
        colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)sheet.getColumnWidth(colNumber));
        if (colWidthMM < reqImageWidthMM) {
            if (resizeBehaviour == 2 || resizeBehaviour == 3) {
                sheet.setColumnWidth(colNumber, ConvertImageUnits.millimetres2WidthUnits(reqImageWidthMM));
                if (sheet instanceof HSSFSheet) {
                    colWidthMM = reqImageWidthMM;
                    colCoordinatesPerMM = 1023.0 / colWidthMM;
                    pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
                } else {
                    pictureWidthCoordinates = (int)reqImageWidthMM * 36000;
                }
                colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 1) {
                colClientAnchorDetail = this.calculateColumnLocation(sheet, colNumber, reqImageWidthMM);
            }
        } else {
            if (sheet instanceof HSSFSheet) {
                colCoordinatesPerMM = 1023.0 / colWidthMM;
                pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
            } else {
                pictureWidthCoordinates = (int)reqImageWidthMM * 36000;
            }
            colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
        }
        return colClientAnchorDetail;
    }

    private ClientAnchorDetail fitImageToRows(Sheet sheet, int rowNumber, double reqImageHeightMM, int resizeBehaviour) {
        Row row = null;
        double rowHeightMM = 0.0;
        double rowCoordinatesPerMM = 0.0;
        int pictureHeightCoordinates = 0;
        ClientAnchorDetail rowClientAnchorDetail = null;
        row = sheet.getRow(rowNumber);
        if (row == null) {
            row = sheet.createRow(rowNumber);
        }
        if ((rowHeightMM = (double)row.getHeightInPoints() / 2.83) < reqImageHeightMM) {
            if (resizeBehaviour == 1 || resizeBehaviour == 3) {
                row.setHeightInPoints((float)(reqImageHeightMM * 2.83));
                if (sheet instanceof HSSFSheet) {
                    rowHeightMM = reqImageHeightMM;
                    rowCoordinatesPerMM = 255.0 / rowHeightMM;
                    pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
                } else {
                    pictureHeightCoordinates = (int)(reqImageHeightMM * 36000.0);
                }
                rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 2) {
                rowClientAnchorDetail = this.calculateRowLocation(sheet, rowNumber, reqImageHeightMM);
            }
        } else {
            if (sheet instanceof HSSFSheet) {
                rowCoordinatesPerMM = 255.0 / rowHeightMM;
                pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
            } else {
                pictureHeightCoordinates = (int)(reqImageHeightMM * 36000.0);
            }
            rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
        }
        return rowClientAnchorDetail;
    }

    private ClientAnchorDetail calculateColumnLocation(Sheet sheet, int startingColumn, double reqImageWidthMM) {
        ClientAnchorDetail anchorDetail = null;
        double totalWidthMM = 0.0;
        double colWidthMM = 0.0;
        double overlapMM = 0.0;
        double coordinatePositionsPerMM = 0.0;
        int toColumn = startingColumn;
        int inset = 0;
        while (totalWidthMM < reqImageWidthMM) {
            colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)sheet.getColumnWidth(toColumn));
            totalWidthMM += colWidthMM + 2.0;
            ++toColumn;
        }
        --toColumn;
        if ((int)totalWidthMM == (int)reqImageWidthMM) {
            anchorDetail = sheet instanceof HSSFSheet ? new ClientAnchorDetail(startingColumn, toColumn, 1023) : new ClientAnchorDetail(startingColumn, toColumn, (int)reqImageWidthMM * 36000);
        } else {
            overlapMM = reqImageWidthMM - (totalWidthMM - colWidthMM);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            if (sheet instanceof HSSFSheet) {
                coordinatePositionsPerMM = 1023.0 / colWidthMM;
                inset = (int)(coordinatePositionsPerMM * overlapMM);
            } else {
                inset = (int)overlapMM * 36000;
            }
            anchorDetail = new ClientAnchorDetail(startingColumn, toColumn, inset);
        }
        return anchorDetail;
    }

    private ClientAnchorDetail calculateRowLocation(Sheet sheet, int startingRow, double reqImageHeightMM) {
        ClientAnchorDetail clientAnchorDetail = null;
        Row row = null;
        double rowHeightMM = 0.0;
        double totalRowHeightMM = 0.0;
        double overlapMM = 0.0;
        double rowCoordinatesPerMM = 0.0;
        int toRow = startingRow;
        int inset = 0;
        while (totalRowHeightMM < reqImageHeightMM) {
            row = sheet.getRow(toRow);
            if (row == null) {
                row = sheet.createRow(toRow);
            }
            rowHeightMM = (double)row.getHeightInPoints() / 2.83;
            totalRowHeightMM += rowHeightMM;
            ++toRow;
        }
        --toRow;
        if ((int)totalRowHeightMM == (int)reqImageHeightMM) {
            clientAnchorDetail = sheet instanceof HSSFSheet ? new ClientAnchorDetail(startingRow, toRow, 255) : new ClientAnchorDetail(startingRow, toRow, (int)reqImageHeightMM * 36000);
        } else {
            overlapMM = reqImageHeightMM - (totalRowHeightMM - rowHeightMM);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            if (sheet instanceof HSSFSheet) {
                rowCoordinatesPerMM = 255.0 / rowHeightMM;
                inset = (int)(overlapMM * rowCoordinatesPerMM);
            } else {
                inset = (int)overlapMM * 36000;
            }
            clientAnchorDetail = new ClientAnchorDetail(startingRow, toRow, inset);
        }
        return clientAnchorDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String imageFile = null;
        String outputFile = null;
        FileOutputStream fos = null;
        HSSFWorkbook workbook = null;
        Sheet sheet = null;
        try {
            if (args.length < 2) {
                System.err.println("Usage: AddDimensionedImage imageFile outputFile");
                return;
            }
            workbook = new HSSFWorkbook();
            sheet = workbook.createSheet("Picture Test");
            imageFile = args[0];
            outputFile = args[1];
            new AddDimensionedImage().addImageToSheet("B5", sheet, sheet.createDrawingPatriarch(), new File(imageFile).toURI().toURL(), 100.0, 40.0, 3);
            fos = new FileOutputStream(outputFile);
            workbook.write((OutputStream)fos);
        }
        catch (FileNotFoundException fnfEx) {
            System.out.println("Caught an: " + fnfEx.getClass().getName());
            System.out.println("Message: " + fnfEx.getMessage());
            System.out.println("Stacktrace follows...........");
            fnfEx.printStackTrace(System.out);
        }
        catch (IOException ioEx) {
            System.out.println("Caught an: " + ioEx.getClass().getName());
            System.out.println("Message: " + ioEx.getMessage());
            System.out.println("Stacktrace follows...........");
            ioEx.printStackTrace(System.out);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                    fos = null;
                }
                catch (IOException ioEx) {}
            }
        }
    }

    public static class ConvertImageUnits {
        public static final int TOTAL_COLUMN_COORDINATE_POSITIONS = 1023;
        public static final int TOTAL_ROW_COORDINATE_POSITIONS = 255;
        public static final int PIXELS_PER_INCH = 96;
        public static final double PIXELS_PER_MILLIMETRES = 3.78;
        public static final double POINTS_PER_MILLIMETRE = 2.83;
        public static final double CELL_BORDER_WIDTH_MILLIMETRES = 2.0;
        public static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
        public static final int UNIT_OFFSET_LENGTH = 7;
        public static final int[] UNIT_OFFSET_MAP = new int[]{0, 36, 73, 109, 146, 182, 219};

        public static short pixel2WidthUnits(int pxs) {
            short widthUnits = (short)(256 * (pxs / 7));
            widthUnits = (short)(widthUnits + UNIT_OFFSET_MAP[pxs % 7]);
            return widthUnits;
        }

        public static int widthUnits2Pixel(short widthUnits) {
            int pixels = widthUnits / 256 * 7;
            int offsetWidthUnits = widthUnits % 256;
            return pixels += Math.round((float)offsetWidthUnits / 36.57143f);
        }

        public static double widthUnits2Millimetres(short widthUnits) {
            return (double)ConvertImageUnits.widthUnits2Pixel(widthUnits) / 3.78;
        }

        public static int millimetres2WidthUnits(double millimetres) {
            return ConvertImageUnits.pixel2WidthUnits((int)(millimetres * 3.78));
        }

        public static int pointsToPixels(double points) {
            return (int)Math.round(points / 72.0 * 96.0);
        }

        public static double pointsToMillimeters(double points) {
            return points / 72.0 * 25.4;
        }
    }

    public class ClientAnchorDetail {
        public int fromIndex = 0;
        public int toIndex = 0;
        public int inset = 0;

        public ClientAnchorDetail(int fromIndex, int toIndex, int inset) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.inset = inset;
        }

        public int getFromIndex() {
            return this.fromIndex;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public int getInset() {
            return this.inset;
        }
    }
}

