/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;

public class Msg2txt {
    private String fileNameStem;
    private MAPIMessage msg;

    public Msg2txt(String fileName) throws IOException {
        this.fileNameStem = fileName;
        if (this.fileNameStem.endsWith(".msg") || this.fileNameStem.endsWith(".MSG")) {
            this.fileNameStem = this.fileNameStem.substring(0, this.fileNameStem.length() - 4);
        }
        this.msg = new MAPIMessage(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage() throws IOException {
        String txtFileName = this.fileNameStem + ".txt";
        String attDirName = this.fileNameStem + "-att";
        PrintWriter txtOut = null;
        try {
            txtOut = new PrintWriter(txtFileName);
            try {
                String displayFrom = this.msg.getDisplayFrom();
                txtOut.println("From: " + displayFrom);
            }
            catch (ChunkNotFoundException e) {
                // empty catch block
            }
            try {
                String displayTo = this.msg.getDisplayTo();
                txtOut.println("To: " + displayTo);
            }
            catch (ChunkNotFoundException e) {
                // empty catch block
            }
            try {
                String displayCC = this.msg.getDisplayCC();
                txtOut.println("CC: " + displayCC);
            }
            catch (ChunkNotFoundException e) {
                // empty catch block
            }
            try {
                String displayBCC = this.msg.getDisplayBCC();
                txtOut.println("BCC: " + displayBCC);
            }
            catch (ChunkNotFoundException e) {
                // empty catch block
            }
            try {
                String subject = this.msg.getSubject();
                txtOut.println("Subject: " + subject);
            }
            catch (ChunkNotFoundException e) {
                // empty catch block
            }
            try {
                String body = this.msg.getTextBody();
                txtOut.println(body);
            }
            catch (ChunkNotFoundException e) {
                System.err.println("No message body");
            }
            AttachmentChunks[] attachments = this.msg.getAttachmentFiles();
            if (attachments.length > 0) {
                File d = new File(attDirName);
                if (d.mkdir()) {
                    for (AttachmentChunks attachment : attachments) {
                        this.processAttachment(attachment, d);
                    }
                } else {
                    System.err.println("Can't create directory " + attDirName);
                }
            }
        }
        finally {
            if (txtOut != null) {
                txtOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAttachment(AttachmentChunks attachment, File dir) throws IOException {
        String fileName = attachment.attachFileName.toString();
        if (attachment.attachLongFileName != null) {
            fileName = attachment.attachLongFileName.toString();
        }
        File f = new File(dir, fileName);
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(f);
            ((OutputStream)fileOut).write(attachment.attachData.getValue());
        }
        finally {
            if (fileOut != null) {
                ((OutputStream)fileOut).close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("No files names provided");
        } else {
            for (int i = 0; i < args.length; ++i) {
                try {
                    Msg2txt processor = new Msg2txt(args[i]);
                    processor.processMessage();
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Could not process " + args[i] + ": " + e);
                }
            }
        }
    }
}

