/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.plugins.codegenerator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.plc4x.plugins.codegenerator.language.LanguageOutput;
import org.apache.plc4x.plugins.codegenerator.protocol.Protocol;
import org.apache.plc4x.plugins.codegenerator.types.exceptions.GenerationException;

@Mojo(name="generate-driver", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/plc4x/", required=true)
    private File outputDir;
    @Parameter(required=true)
    private String protocolName;
    @Parameter(required=true)
    private String languageName;
    @Parameter(required=true)
    private String outputFlavor;

    public void execute() throws MojoExecutionException {
        URLClassLoader moduleClassloader;
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new MojoExecutionException("Could not generate output directory " + this.outputDir.getAbsolutePath());
        }
        try {
            Set artifacts = this.project.getArtifacts();
            ArrayList<URL> classpathElements = new ArrayList<URL>(artifacts.size() + 1);
            classpathElements.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
            for (Artifact artifact : artifacts) {
                classpathElements.add(artifact.getFile().toURI().toURL());
            }
            moduleClassloader = new URLClassLoader(classpathElements.toArray(new URL[0]), GenerateMojo.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error creating classloader for loading message format schema from module dependencies", (Exception)e);
        }
        Protocol protocol = null;
        ServiceLoader<Protocol> protocols = ServiceLoader.load(Protocol.class, moduleClassloader);
        for (Protocol curProtocol : protocols) {
            if (!curProtocol.getName().equalsIgnoreCase(this.protocolName)) continue;
            protocol = curProtocol;
            break;
        }
        if (protocol == null) {
            throw new MojoExecutionException("Unable to find protocol specification module '" + this.protocolName + "' on modules classpath");
        }
        LanguageOutput language = null;
        ServiceLoader<LanguageOutput> languages = ServiceLoader.load(LanguageOutput.class, moduleClassloader);
        for (LanguageOutput curLanguage : languages) {
            if (!curLanguage.getName().equalsIgnoreCase(this.languageName)) continue;
            language = curLanguage;
            break;
        }
        if (language == null) {
            throw new MojoExecutionException("Unable to find language output module '" + this.languageName + "' on modules classpath");
        }
        if (!language.supportedOutputFlavors().contains(this.outputFlavor)) {
            throw new MojoExecutionException("The selected language output module: " + this.languageName + " doesn't support the output flavor: " + this.outputFlavor + ". Supported output flavors are: " + String.join((CharSequence)", ", language.supportedOutputFlavors()));
        }
        try {
            Map types = protocol.getTypeDefinitions();
            language.generate(this.outputDir, this.languageName, this.protocolName, this.outputFlavor, types);
        }
        catch (GenerationException e) {
            throw new MojoExecutionException("Error generating sources", (Exception)((Object)e));
        }
        this.project.addCompileSourceRoot(this.outputDir.getPath());
    }
}

