/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.optimizer;

import io.vavr.control.Either;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;

public abstract class BaseOptimizer {
    protected List<PlcRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        return Collections.singletonList(readRequest);
    }

    protected PlcReadResponse processReadResponses(PlcReadRequest readRequest, Map<PlcRequest, Either<PlcResponse, Exception>> readResponses) {
        HashMap<String, ResponseItem<PlcValue>> fields = new HashMap<String, ResponseItem<PlcValue>>();
        for (Map.Entry<PlcRequest, Either<PlcResponse, Exception>> requestsEntries : readResponses.entrySet()) {
            PlcReadRequest curRequest = (PlcReadRequest)requestsEntries.getKey();
            Either<PlcResponse, Exception> readResponse = requestsEntries.getValue();
            for (String fieldName : curRequest.getFieldNames()) {
                if (readResponse.isLeft()) {
                    PlcReadResponse subReadResponse = (PlcReadResponse)readResponse.getLeft();
                    PlcResponseCode responseCode = subReadResponse.getResponseCode(fieldName);
                    PlcValue value = responseCode == PlcResponseCode.OK ? subReadResponse.getAsPlcValue().getValue(fieldName) : null;
                    fields.put(fieldName, new ResponseItem<PlcValue>(responseCode, value));
                    continue;
                }
                fields.put(fieldName, new ResponseItem<Object>(PlcResponseCode.INTERNAL_ERROR, null));
            }
        }
        return new DefaultPlcReadResponse((InternalPlcReadRequest)readRequest, fields);
    }

    protected List<PlcRequest> processWriteRequest(PlcWriteRequest writeRequest, DriverContext driverContext) {
        return Collections.singletonList(writeRequest);
    }

    protected PlcWriteResponse processWriteResponses(PlcWriteRequest writeRequest, Map<PlcRequest, Either<PlcResponse, Exception>> writeResponses) {
        HashMap<String, PlcResponseCode> fields = new HashMap<String, PlcResponseCode>();
        for (Map.Entry<PlcRequest, Either<PlcResponse, Exception>> requestsEntries : writeResponses.entrySet()) {
            PlcWriteRequest subWriteRequest = (PlcWriteRequest)requestsEntries.getKey();
            Either<PlcResponse, Exception> writeResponse = requestsEntries.getValue();
            for (String fieldName : subWriteRequest.getFieldNames()) {
                if (writeResponse.isLeft()) {
                    PlcWriteResponse subWriteResponse = (PlcWriteResponse)writeResponse.getLeft();
                    fields.put(fieldName, subWriteResponse.getResponseCode(fieldName));
                    continue;
                }
                fields.put(fieldName, PlcResponseCode.INTERNAL_ERROR);
            }
        }
        return new DefaultPlcWriteResponse((InternalPlcWriteRequest)writeRequest, fields);
    }

    protected List<PlcRequest> processSubscriptionRequest(PlcSubscriptionRequest subscriptionRequest, DriverContext driverContext) {
        return Collections.singletonList(subscriptionRequest);
    }

    protected PlcSubscriptionResponse processSubscriptionResponses(PlcSubscriptionRequest subscriptionRequest, Map<PlcRequest, Either<PlcResponse, Exception>> subscriptionResponses) {
        return null;
    }

    protected List<PlcRequest> processUnsubscriptionRequest(PlcRequest unsubscriptionRequest, DriverContext driverContext) {
        return Collections.singletonList(unsubscriptionRequest);
    }

    protected PlcUnsubscriptionResponse processUnsubscriptionResponses(PlcRequest unsubscriptionRequest, Map<PlcRequest, Either<PlcResponse, Exception>> unsubscriptionResponses) {
        return null;
    }

    public CompletableFuture<PlcReadResponse> optimizedRead(PlcReadRequest readRequest, Plc4xProtocolBase reader) {
        List<PlcRequest> subRequests = this.processReadRequest(readRequest, reader.getDriverContext());
        return this.send((PlcRequest)readRequest, subRequests, request -> reader.read((PlcReadRequest)request), response -> this.processReadResponses(readRequest, (Map<PlcRequest, Either<PlcResponse, Exception>>)response));
    }

    public CompletableFuture<PlcWriteResponse> optimizedWrite(PlcWriteRequest writeRequest, Plc4xProtocolBase writer) {
        List<PlcRequest> subRequests = this.processWriteRequest(writeRequest, writer.getDriverContext());
        return this.send((PlcRequest)writeRequest, subRequests, request -> writer.write((PlcWriteRequest)request), response -> this.processWriteResponses(writeRequest, (Map<PlcRequest, Either<PlcResponse, Exception>>)response));
    }

    public CompletableFuture<PlcSubscriptionResponse> optimizedSubscribe(PlcSubscriptionRequest subscriptionRequest, Plc4xProtocolBase subscriber) {
        List<PlcRequest> subRequests = this.processSubscriptionRequest(subscriptionRequest, subscriber.getDriverContext());
        return this.send((PlcRequest)subscriptionRequest, subRequests, request -> subscriber.subscribe((PlcSubscriptionRequest)request), response -> this.processSubscriptionResponses(subscriptionRequest, (Map<PlcRequest, Either<PlcResponse, Exception>>)response));
    }

    public CompletableFuture<PlcUnsubscriptionResponse> optmizedUnsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest, Plc4xProtocolBase subscriber) {
        List<PlcRequest> subRequests = this.processUnsubscriptionRequest((PlcRequest)unsubscriptionRequest, subscriber.getDriverContext());
        return this.send((PlcRequest)unsubscriptionRequest, subRequests, request -> subscriber.unsubscribe((PlcUnsubscriptionRequest)request), response -> this.processUnsubscriptionResponses((PlcRequest)unsubscriptionRequest, (Map<PlcRequest, Either<PlcResponse, Exception>>)response));
    }

    private CompletableFuture send(PlcRequest originalRequest, List<? extends PlcRequest> requests, Function<PlcRequest, CompletableFuture<PlcResponse>> sender, Function<Map<PlcRequest, Either<PlcResponse, Exception>>, PlcResponse> responseProcessor) {
        if (requests.size() == 1 && requests.get(0) == originalRequest) {
            return sender.apply(requests.get(0));
        }
        if (!requests.isEmpty()) {
            CompletableFuture parentFuture = new CompletableFuture();
            HashMap<PlcRequest, CompletableFuture<PlcResponse>> subFutures = new HashMap<PlcRequest, CompletableFuture<PlcResponse>>();
            for (PlcRequest plcRequest : requests) {
                subFutures.put(plcRequest, sender.apply(plcRequest));
            }
            CompletableFuture.allOf(subFutures.values().toArray(new CompletableFuture[0])).thenApply(aVoid -> {
                HashMap<PlcRequest, Either> results = new HashMap<PlcRequest, Either>();
                for (Map.Entry subFutureEntry : subFutures.entrySet()) {
                    PlcRequest subRequest = (PlcRequest)subFutureEntry.getKey();
                    CompletableFuture subFuture = (CompletableFuture)subFutureEntry.getValue();
                    try {
                        PlcResponse subResponse = (PlcResponse)subFuture.get();
                        results.put(subRequest, Either.left((Object)subResponse));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        results.put(subRequest, Either.right((Object)new Exception("Something went wrong")));
                    }
                    catch (ExecutionException e) {
                        results.put(subRequest, Either.right((Object)new Exception("Something went wrong")));
                    }
                }
                PlcResponse response = (PlcResponse)responseProcessor.apply(results);
                parentFuture.complete(response);
                return Void.TYPE;
            });
            return parentFuture;
        }
        return CompletableFuture.completedFuture(responseProcessor.apply(Collections.EMPTY_MAP));
    }
}

