/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.InternalPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.InternalPlcSubscriptionHandle;

public class DefaultPlcConsumerRegistration
implements InternalPlcConsumerRegistration {
    private final PlcSubscriber plcSubscriber;
    private final Collection<InternalPlcSubscriptionHandle> handles;
    private final int consumerHash;

    public DefaultPlcConsumerRegistration(PlcSubscriber plcSubscriber, Consumer<PlcSubscriptionEvent> consumer, InternalPlcSubscriptionHandle ... handles) {
        this.plcSubscriber = plcSubscriber;
        this.handles = Arrays.asList(Objects.requireNonNull(handles));
        this.consumerHash = Objects.requireNonNull(consumer).hashCode();
    }

    @Override
    public int getConsumerHash() {
        return this.consumerHash;
    }

    public Collection<InternalPlcSubscriptionHandle> getAssociatedHandles() {
        return this.handles;
    }

    public void unregister() {
        this.plcSubscriber.unregister(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPlcConsumerRegistration)) {
            return false;
        }
        DefaultPlcConsumerRegistration that = (DefaultPlcConsumerRegistration)o;
        return Objects.equals(this.plcSubscriber, that.plcSubscriber) && Objects.equals(this.handles, that.handles) && this.consumerHash == that.consumerHash;
    }

    public final int hashCode() {
        return Objects.hash(this.plcSubscriber, this.handles, this.consumerHash);
    }

    public String toString() {
        return "DefaultPlcConsumerRegistration{handles=" + this.handles + ", consumerHash=" + this.consumerHash + '}';
    }
}

