/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.messages.InternalPlcFieldRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.messages.utils.FieldValueItem;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcWriteRequest
implements InternalPlcWriteRequest,
InternalPlcFieldRequest {
    private final PlcWriter writer;
    private final LinkedHashMap<String, FieldValueItem> fields;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcWriteRequest(@JsonProperty(value="writer") PlcWriter writer, @JsonProperty(value="fields") LinkedHashMap<String, FieldValueItem> fields) {
        this.writer = writer;
        this.fields = fields;
    }

    @JsonIgnore
    public CompletableFuture<PlcWriteResponse> execute() {
        return this.writer.write(this);
    }

    @JsonIgnore
    public int getNumberOfFields() {
        return this.fields.size();
    }

    @JsonIgnore
    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fields.keySet());
    }

    @JsonIgnore
    public PlcField getField(String name) {
        return this.fields.get(name).getField();
    }

    @JsonIgnore
    public List<PlcField> getFields() {
        return this.fields.values().stream().map(FieldValueItem::getField).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    @JsonIgnore
    public PlcValue getPlcValue(String name) {
        return this.fields.get(name).getValue();
    }

    @Override
    @JsonIgnore
    public List<PlcValue> getPlcValues() {
        return this.fields.values().stream().map(FieldValueItem::getValue).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    @JsonIgnore
    public List<Pair<String, PlcField>> getNamedFields() {
        return this.fields.entrySet().stream().map(stringPairEntry -> Pair.of((Object)((String)stringPairEntry.getKey()), (Object)((FieldValueItem)stringPairEntry.getValue()).getField())).collect(Collectors.toCollection(LinkedList::new));
    }

    public PlcWriter getWriter() {
        return this.writer;
    }

    @Override
    @JsonIgnore
    public List<Triple<String, PlcField, PlcValue>> getNamedFieldTriples() {
        return this.fields.entrySet().stream().map(stringPairEntry -> Triple.of((Object)((String)stringPairEntry.getKey()), (Object)((FieldValueItem)stringPairEntry.getValue()).getField(), (Object)((FieldValueItem)stringPairEntry.getValue()).getValue())).collect(Collectors.toCollection(LinkedList::new));
    }

    @JsonIgnore
    public int getNumberOfValues(String name) {
        PlcValue value = this.fields.get(name).getValue();
        if (value instanceof PlcList) {
            PlcList list = (PlcList)value;
            return list.getLength();
        }
        return 1;
    }

    public static class Builder
    implements PlcWriteRequest.Builder {
        private final PlcWriter writer;
        private final PlcFieldHandler fieldHandler;
        private final Map<String, BuilderItem<Object>> fields;
        private final Map<Class<?>, BiFunction<PlcField, Object[], PlcValue>> handlerMap;

        public Builder(PlcWriter writer, PlcFieldHandler fieldHandler) {
            this.writer = writer;
            this.fieldHandler = fieldHandler;
            this.fields = new TreeMap<String, BuilderItem<Object>>();
            this.handlerMap = new HashMap();
            this.handlerMap.put(Boolean.class, fieldHandler::encodeBoolean);
            this.handlerMap.put(Byte.class, fieldHandler::encodeByte);
            this.handlerMap.put(Short.class, fieldHandler::encodeShort);
            this.handlerMap.put(Integer.class, fieldHandler::encodeInteger);
            this.handlerMap.put(BigInteger.class, fieldHandler::encodeBigInteger);
            this.handlerMap.put(Long.class, fieldHandler::encodeLong);
            this.handlerMap.put(Float.class, fieldHandler::encodeFloat);
            this.handlerMap.put(Double.class, fieldHandler::encodeDouble);
            this.handlerMap.put(BigDecimal.class, fieldHandler::encodeBigDecimal);
            this.handlerMap.put(String.class, fieldHandler::encodeString);
            this.handlerMap.put(LocalTime.class, fieldHandler::encodeTime);
            this.handlerMap.put(LocalDate.class, fieldHandler::encodeDate);
            this.handlerMap.put(LocalDateTime.class, fieldHandler::encodeDateTime);
        }

        public Builder addItem(String name, String fieldQuery, Boolean ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeBoolean);
        }

        public Builder addItem(String name, String fieldQuery, Byte ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeByte);
        }

        public Builder addItem(String name, String fieldQuery, Short ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeShort);
        }

        public Builder addItem(String name, String fieldQuery, Integer ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeInteger);
        }

        public PlcWriteRequest.Builder addItem(String name, String fieldQuery, BigInteger ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeBigInteger);
        }

        public Builder addItem(String name, String fieldQuery, Long ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeLong);
        }

        public Builder addItem(String name, String fieldQuery, Float ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeFloat);
        }

        public Builder addItem(String name, String fieldQuery, Double ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeDouble);
        }

        public Builder addItem(String name, String fieldQuery, BigDecimal ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeBigDecimal);
        }

        public Builder addItem(String name, String fieldQuery, String ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeString);
        }

        public Builder addItem(String name, String fieldQuery, LocalTime ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeTime);
        }

        public Builder addItem(String name, String fieldQuery, LocalDate ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeDate);
        }

        public Builder addItem(String name, String fieldQuery, LocalDateTime ... values) {
            return this.addItem(name, fieldQuery, (Object[])values, this.fieldHandler::encodeDateTime);
        }

        public <T> Builder addItem(String name, String fieldQuery, T ... values) {
            Objects.requireNonNull(values);
            Class<?> checkedClazz = null;
            for (T value : values) {
                if (checkedClazz == null) {
                    checkedClazz = value.getClass();
                }
                if (value.getClass() == checkedClazz) continue;
                throw new IllegalArgumentException("Invalid class found " + value.getClass() + ". should all be " + checkedClazz);
            }
            BiFunction<PlcField, Object[], PlcValue> plcFieldPlcValueBiFunction = this.handlerMap.get(checkedClazz);
            if (plcFieldPlcValueBiFunction == null) {
                throw new IllegalArgumentException("no field handler for " + checkedClazz + " found");
            }
            return this.addItem(name, fieldQuery, (Object[])values, plcFieldPlcValueBiFunction);
        }

        public PlcWriteRequest build() {
            LinkedHashMap<String, FieldValueItem> parsedFields = new LinkedHashMap<String, FieldValueItem>();
            this.fields.forEach((name, builderItem) -> {
                PlcField parsedField = this.fieldHandler.createField(((BuilderItem)builderItem).fieldQuery);
                PlcValue value = (PlcValue)((BuilderItem)builderItem).encoder.apply(parsedField, ((BuilderItem)builderItem).values);
                parsedFields.put((String)name, new FieldValueItem(parsedField, value));
            });
            return new DefaultPlcWriteRequest(this.writer, parsedFields);
        }

        private Builder addItem(String name, String fieldQuery, Object[] values, BiFunction<PlcField, Object[], PlcValue> encoder) {
            if (this.fields.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate field definition '" + name + "'");
            }
            this.fields.put(name, new BuilderItem(fieldQuery, values, encoder));
            return this;
        }

        private static class BuilderItem<T> {
            private final String fieldQuery;
            private final T[] values;
            private final BiFunction<PlcField, T[], PlcValue> encoder;

            private BuilderItem(String fieldQuery, T[] values, BiFunction<PlcField, T[], PlcValue> encoder) {
                this.fieldQuery = fieldQuery;
                this.values = values;
                this.encoder = encoder;
            }
        }
    }
}

